%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses the Real-time and Final data structures generated
% by Gen_RT_Final_Data.m to calculate forecast errors for
% the specified horizons and store them by variable and vintage 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

methods = fieldnames(RT_DATA);

for i = 1:size(methods,1) % Iterate over forecast methods

    
    variables = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))));

    for j = 1:size(variables,1) % Iterate over variables

        
        jumps = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))));
            
        for k = 1:size(jumps,1) % Iterate over jump-off delays
            
            
            vintages = fieldnames(FINAL_DATA.(sprintf(cell2mat(variables(j,1)))));
            
            REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))) = ...
                nan(size(vintages,1),PARAMS.horizons);
            
            REV1_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))) = ...
                nan(size(vintages,1),PARAMS.horizons);
            
            FC_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))) = ...
                nan(size(vintages,1),PARAMS.horizons);
        
            for l = 1:size(vintages,1) % Iterate over vintages
                
                
                horizons = size(FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1)))),2);
                
                for m = 1:horizons % Iterate over horizons  
                    
                    if strcmp(jumps(k),'jump_final')
                        
                        REV_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m) = ...
                            FINAL_LAST_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m) - ...
                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);

                        REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            REV_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m).^2;

                        REV1_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            REV_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);

                        REVISED_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            FINAL_LAST_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);   
                        
                        FC_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                        
                    else    
                                    
                        REV_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m) = ...
                            FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m) - ...
                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);

                        REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            REV_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m).^2;

                        REV1_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            REV_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);

                        REVISED_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                    
                        FC_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                        
                    end
                    
                    
                end

            end

        end
        
        
        for k = 1:size(jumps,1) % Iterate over jump-off delays
         
            RMSE_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(1,1:PARAMS.horizons) = ...
                sqrt(nansum(REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))),1) ...
                ./sum(~isnan(REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))),1));     
            
            MSE_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(1,1:PARAMS.horizons) = ...
                nansum(REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))),1) ...
                ./sum(~isnan(REV2_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))),1); 
                         
        end

        
    end

end


clearvars -except PARAMS DATA* FC_DATA RT_DATA FINAL*_DATA* REV_DATA* REV*_DATA ERRORS_STATS* *MSE* *RATIO* *L_DATA


