%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses any Y input series and extends it forward
% for 12 quarters using an out of sample dynamic simulation
% from an AR(p) process
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Y_reg = Y(p+1:end,1);

X_reg(:,1) = ones(size(Y_reg,1),1);

for lags = 1:p

    X_reg(:,lags+1) = Y(1+(p-lags):end-lags,1);
    
end

Beta = regress(Y_reg,X_reg);

Y_extended = Y;

for h = 1:12
    
    Y_temp = Y_extended;
    Y_temp(end+1,1) = Beta(1);

    for lags = 1:p
        
        Y_temp(end,1) = Y_temp(end,1) + Beta(lags+1)*Y_temp(end-lags,1);
        Y_extended = Y_temp;  
        
    end    
    
    clear Y_temp
    
end

clear Y_reg X_reg Beta