%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This program is used to produce the statistics necessary
% to create the figures and tables of the paper
% "Introducing the Bank of Canada Staff Economic Projections Database"
% August 2019
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clc; clear;

% Windows
cd('ADD_PATH_HERE');
addpath('ADD_PATH_HERE\Scripts');



%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set fixed parameters

PARAMS.test_no_ML = 1 ; % If you want to skip Maximum Likelyhood estimation to test the code MUCH faster, this should be equal to 1.

PARAMS.spreadsheet = 'log_staff_data_patched'; % Name of the spreadsheet where the data is stored

                                                            

PARAMS.variables = {'ly' 'lc' 'li' 'lg' 'lx' 'lm' 'lpcpi' 'bankrate' 'lpcpix'}; % List the tabs of the spreadsheet where the variables of interest are stored

PARAMS.var_growth = {'qq' 'qq' 'qq' 'qq' 'qq' 'qq' 'qq' 'level' 'qq'}; % For each of the variables, in order, specify if you want
%                                       to take the q/q annualized growth rate (qq), the y/y growth rate (yy) or
%                                       the variable in levels (level).
%                                       Growth rates assume that the variable are initially in log     
                                      
                                      
PARAMS.data_range = 'A1:GB205';  

PARAMS.delay = 2; % Number of quarters after the estimated period for the final release

PARAMS.horizons = 9; % Includes the nowcast. Therefore, 9 horizons include the nowcast thought horizon t+8
                     % Be careful that your horizons are continuously available in your sample 
                     % (There can be holes at the beginning or the end of the sample but not within the sample.)
                     % It might otherwise cause problems when estimating the newey-west standard errors.


                     
%%                     
                     
if PARAMS.test_no_ML ~= 1                     
    msgbox('This program takes forever to run because of the iterative estimations of multiple models by maximum likelyhood. You will be notified when the script is done compiling');                    
end                     

Main1;   

save './Workfiles/RT_data'


%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Set different samples and produce statistics 


%%

clearvars -except PARAMS

load './Workfiles/RT_data'

PARAMS.subsample = 'All';

Main2;

save '.\Workfiles\82_13_sample'



clearvars -except PARAMS

load './Workfiles/RT_data'

PARAMS.subsample = 'IT';

Main2;

save '.\Workfiles\82_13_IT_sample'



clearvars -except PARAMS

load './Workfiles/RT_data'

PARAMS.subsample = 'preIT';

Main2;

save '.\Workfiles\82_13_preIT_sample'



clearvars -except PARAMS

load './Workfiles/RT_data'

PARAMS.subsamples.recession = PARAMS.recession_dummy;

PARAMS.subsample = 'recession';

Main2;

save '.\Workfiles\82_13_recession_sample'


clearvars -except PARAMS

load './Workfiles/RT_data'

PARAMS.subsample = 'expansion';

Main2;

save '.\Workfiles\82_13_expansion_sample'


%%

msgbox('Program executed successfully'); 


