clc; clear;

addpath('ADD_PATH_HERE\Workfiles');
addpath('ADD_PATH_HERE\Scripts');

cd 'ADD_PATH_HERE'


%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load data

load RT_data
%%

methods = fieldnames(RT_DATA);

for i = 1:size(methods,1) % Iterate over forecast methods

    
    variables = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))));

    for j = 1:size(variables,1) % Iterate over variables

        
        jumps = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))));
            
        for k = 1:size(jumps,1) % Iterate over jump-off delays
            
            
            vintages = fieldnames(FINAL_DATA.(sprintf(cell2mat(variables(j,1)))));
            
            FORECAST_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))) = ...
                nan(size(vintages,1),PARAMS.horizons);
            

            
            for l = 1:size(vintages,1) % Iterate over vintages
                
                
                horizons = size(FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1)))),2);
                
                for m = 1:horizons % Iterate over horizons  
                                          
                        FORECAST_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                         
                        REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))(l,m) = ...
                            FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                        
                        ERROR_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))(l,m)-FORECAST_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m);
                            
                end
            end
            
            REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))(REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))==0) = NaN;
            
        end     
    end
end

%% Loop over all variables and horizons to produce charts

figure
panel = 1;

variables = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i-1,1)))));

for j = 1:size(variables,1) % Iterate over variables

    horizons = 9;

    for m = 1:horizons % Iterate over horizons  

        if and((strcmp(variables(j),'ly')|strcmp(variables(j),'lpcpi')|strcmp(variables(j),'bankrate')),(eq(m,2)|eq(m,5)))
            
            h=m-1;
            a = 1;
            time = datetime(1982,06,30):calquarters(1):datetime(2013,12,31);
            x=1:size(time,2)+1-m;
            zeroline=zeros(1,size(x,2));
            startdate = datenum(time(m));
            enddate = datenum(time(end));
            lenght = size(time,2)+1-m;
            dates = linspace(startdate,enddate,lenght);

            subplot(3,2,panel)
            
            STAFF = bar(dates,ERROR_DATA.Staff.(sprintf(cell2mat(variables(j,1)))).jump_0(1:x(end),m),'k');
            hold on;
            ZERO = plot(dates,zeroline,'-k','LineWidth',0.75);
            hold on;
            ylim([-10 10]);
            datetick('x','yyyy','keeplimits');

                       
                if panel == 1
                    title({'One-quarter ahead'},'Fontsize',10);
                    ylabel('GDP growth (%)');
                end
                
                if eq(panel,2)
                    title({'Four-quarter ahead'},'Fontsize',10);
                end
            
                if eq(panel,3)
                    ylabel('CPI inflation (%)');
                end
                
                if eq(panel,5)
                    ylabel('Policy rate (ppts)');
                end
                
            panel = panel+1;
        end
        

        
    end

end

saveas(gcf,'Figure_Paper_3','epsc'); 