clc; clear;
addpath('ADD_PATH_HERE\Workfiles');
addpath('ADD_PATH_HERE\Scripts');

cd 'ADD_PATH_HERE'


%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Load data

load RT_data
%%

methods = fieldnames(RT_DATA);

for i = 1:size(methods,1) % Iterate over forecast methods

    
    variables = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))));

    for j = 1:size(variables,1) % Iterate over variables

        
        jumps = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))));
            
        for k = 1:size(jumps,1) % Iterate over jump-off delays
            
            
            vintages = fieldnames(FINAL_DATA.(sprintf(cell2mat(variables(j,1)))));
            
            FORECAST_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))) = ...
                nan(size(vintages,1),PARAMS.horizons);
            

            
            for l = 1:size(vintages,1) % Iterate over vintages
                
                
                horizons = size(FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1)))),2);
                
                for m = 1:horizons % Iterate over horizons  
                                          
                        FORECAST_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1))))(l,m) = ...
                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                         
                            
                        REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))(l,m) = ...
                            FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,m);
                            
                            
                end
            end
                        
        end     
    end
end

%% Loop over all variables to produce charts for 1-year ahead forecast

variables = fieldnames(RT_DATA.(sprintf('VAR')));

figure

for j = 1:size(variables,1) % Iterate over variables

    horizons = 9;
    
    num = 1;
    
    subplot(3,1,j) 
    
    m = 5;
        

    h=m-1;
    a = 1;
    time = datetime(1982,06,30):calquarters(1):datetime(2015,12,31);
    x=m:size(time,2)-(PARAMS.horizons-m);

    startdate = datenum(time(m));
    enddate = datenum(time(x(end)));
    lenght = size(x,2);
    dates = linspace(startdate,enddate,lenght);

    STAFF = plot(dates,FORECAST_DATA.Staff.(sprintf(cell2mat(variables(j,1)))).jump_0(1:end,m),'ok','MarkerSize',6);
    hold on;
    REALIZED = plot(dates,REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))(1:end,m),'-k','Color',[0.6 0.6 0.6],'LineWidth',1.5);
    hold on;
    yticks([-10 -5 0 5 10 15 20])
    ax = gca;
    ax.YGrid = 'on';
    ylabel('Per cent');
    datetick('x','yyyy','keeplimits');


    set(gca,'XLim',[datenum(1980,01,01) datenum(2015,12,30)]);
    if strcmp(variables(j),'ly')
        title({'GDP growth'},'Fontsize',10);
        ylim([-10 10]);
    end

    if strcmp(variables(j),'lpcpi')  
        title({'CPI inflation'},'Fontsize',10);
        ylim([-5 15]);
    end

    if strcmp(variables(j),'bankrate')    
        title({'Policy rate'},'Fontsize',10);
        ylim([0 20]);
        legend([STAFF REALIZED],'Staff forecast','Actual','location','northeast'); 
    end
            


end

saveas(gcf,char(strcat('Figure_Paper_','1')),'epsc');  

%% Loop over all variables and other horizons to produce charts

variables = fieldnames(RT_DATA.(sprintf('VAR')));

for j = 1:size(variables,1) % Iterate over variables

    horizons = 9;
    
    figure
    pbaspect([1 2 1])
    num = 1;
    
    for m = 1:horizons % Iterate over horizons  
        
        if m ~= 5
            
            subplot(4,2,num) 
            
            num = num+1;
            
            h=m-1;
            a = 1;
            time = datetime(1982,06,30):calquarters(1):datetime(2015,12,31);
            x=m:size(time,2)-(PARAMS.horizons-m);
            zeroline=zeros(1,size(x,2));
            startdate = datenum(time(m));
            enddate = datenum(time(x(end)));
            lenght = size(x,2);
            dates = linspace(startdate,enddate,lenght);

            STAFF = plot(dates,FORECAST_DATA.Staff.(sprintf(cell2mat(variables(j,1)))).jump_0(1:end,m),'ok','MarkerSize',2);
            hold on;
            REALIZED = plot(dates,REALIZED_DATA.(sprintf(cell2mat(variables(j,1))))(1:end,m),'-k','Color',[0.6 0.6 0.6],'LineWidth',1);
            hold on;
            if m==1
                title({'nowcast'},'Fontsize',10);
            else
                title({char(strcat('horizon ',' {\itt}','+',num2str(m-1)))},'Fontsize',10);
            end
            ylabel('Per cent','Fontsize',10);
            
            datetick('x','yyyy','keeplimits');

            set(gca,'XLim',[datenum(1980,01,01) datenum(2015,12,30)]);
            
                yticks([-10 -5 0 5 10 15 20])
                
                ax = gca;
                ax.YGrid = 'on';
            
            if strcmp(variables(j),'ly')
                set(gca,'YLim',[-10 10])        
            end

            if strcmp(variables(j),'lpcpi')
                set(gca,'YLim',[-5 15])        
            end

            if strcmp(variables(j),'bankrate')
                set(gca,'YLim',[0 20])        
            end
            
            if m==9
                lgd = legend([STAFF REALIZED],'Staff forecast','Actual','Orientation','horizontal','location','best');
                lgd.FontSize=6;
            end
            
        end
              
    end

        saveas(gcf,char(strcat('Figure_Appendix_C_',variables(j))),'epsc');   

end

