
clc; clear;
addpath('ADD_PATH_HERE\Workfiles');
addpath('ADD_PATH_HERE\Scripts');

load 82_13_IT_sample

table_ratios_m1 = nan(2,9);
table_rmse_m1 = nan(2,9);
table_dmts_m1 = nan(2,9);


table_rmse_m1(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_rmse_m1(2,:) = RMSE_DATA.TARGET.lpcpi.jump_m1;


table_ratios_m1(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_ratios_m1(2,:) = rmse_ratio.TARGET.lpcpi.jump_m1;


table_dmts_m1(2,:) = dm_stats.TARGET.lpcpi.jump_m1;


figure


%% Plot


[row10,col10]=find(1.96>abs(table_dmts_m1)&abs(table_dmts_m1)>1.645);
[row5,col5]=find(abs(table_dmts_m1)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.lpcpi.jump_0,'-k','LineWidth',1);
hold on;
TARGET = plot(x,RMSE_DATA.TARGET.lpcpi.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
plot(col10'-1,(table_rmse_m1(find(1.96>abs(table_dmts_m1)&abs(table_dmts_m1)>1.645)))','ko','MarkerSize',3,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_m1(find(abs(table_dmts_m1)>1.96)))','ko','MarkerSize',3,'MarkerFaceColor','k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0.5 3.5]);



hL = legend([STAFF TARGET],'Staff','2% Target','location','SouthOutside','Orientation','horizontal');



matlab.graphics.internal.setPrintPreferences('DefaultPaperPositionMode','manual')
saveas(gcf,'Figure_Appendix_D7','epsc');


table_ratios_m1(:,[1 2 3 5 7 9])
table_dmts_m1(:,[1 2 3 5 7 9])