
clc; clear;

addpath('ADD_PATH_HERE\Workfiles');
addpath('ADD_PATH_HERE\Scripts');


%% GDP

table_ratios_full = nan(6,9);
table_rmse_full = nan(6,9);
table_dmts_full = nan(6,9);

table_ratios_exp = nan(6,9);
table_rmse_exp = nan(6,9);
table_dmts_exp = nan(6,9);

table_ratios_rec = nan(6,9);
table_rmse_rec = nan(6,9);
table_dmts_rec = nan(6,9);

figure

%% Full sample

load 82_13_sample

table_rmse_full(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_rmse_full(2,:) = RMSE_DATA.AR4.ly.jump_m1;
table_rmse_full(3,:) = RMSE_DATA.AORW4.ly.jump_m1;
table_rmse_full(4,:) = RMSE_DATA.MS2AR4.ly.jump_m1;
table_rmse_full(5,:) = RMSE_DATA.UCSV.ly.jump_m1;
table_rmse_full(6,:) = RMSE_DATA.VAR.ly.jump_m1;

table_ratios_full(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_ratios_full(2,:) = rmse_ratio.AR4.ly.jump_m1;
table_ratios_full(3,:) = rmse_ratio.AORW4.ly.jump_m1;
table_ratios_full(4,:) = rmse_ratio.MS2AR4.ly.jump_m1;
table_ratios_full(5,:) = rmse_ratio.UCSV.ly.jump_m1;
table_ratios_full(6,:) = rmse_ratio.VAR.ly.jump_m1;

table_dmts_full(2,:) = dm_stats.AR4.ly.jump_m1;
table_dmts_full(3,:) = dm_stats.AORW4.ly.jump_m1;
table_dmts_full(4,:) = dm_stats.MS2AR4.ly.jump_m1;
table_dmts_full(5,:) = dm_stats.UCSV.ly.jump_m1;
table_dmts_full(6,:) = dm_stats.VAR.ly.jump_m1;



%% expansion sample

clearvars -except table*
load 82_13_expansion_sample

table_rmse_exp(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_rmse_exp(2,:) = RMSE_DATA.AR4.ly.jump_m1;
table_rmse_exp(3,:) = RMSE_DATA.AORW4.ly.jump_m1;
table_rmse_exp(4,:) = RMSE_DATA.MS2AR4.ly.jump_m1;
table_rmse_exp(5,:) = RMSE_DATA.UCSV.ly.jump_m1;
table_rmse_exp(6,:) = RMSE_DATA.VAR.ly.jump_m1;

table_ratios_exp(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_ratios_exp(2,:) = rmse_ratio.AR4.ly.jump_m1;
table_ratios_exp(3,:) = rmse_ratio.AORW4.ly.jump_m1;
table_ratios_exp(4,:) = rmse_ratio.MS2AR4.ly.jump_m1;
table_ratios_exp(5,:) = rmse_ratio.UCSV.ly.jump_m1;
table_ratios_exp(6,:) = rmse_ratio.VAR.ly.jump_m1;

table_dmts_exp(2,:) = dm_stats.AR4.ly.jump_m1;
table_dmts_exp(3,:) = dm_stats.AORW4.ly.jump_m1;
table_dmts_exp(4,:) = dm_stats.MS2AR4.ly.jump_m1;
table_dmts_exp(5,:) = dm_stats.UCSV.ly.jump_m1;
table_dmts_exp(6,:) = dm_stats.VAR.ly.jump_m1;


%% Plot recession sample

subplot(3,2,1)

[row10,col10]=find(1.96>abs(table_dmts_exp)&abs(table_dmts_exp)>1.645);
[row5,col5]=find(abs(table_dmts_exp)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.ly.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.ly.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.ly.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.ly.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.ly.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.ly.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'GDP growth', 'Expansions'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0 7]);


%% Recession sample

clearvars -except table*
load 82_13_recession_sample

table_rmse_rec(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_rmse_rec(2,:) = RMSE_DATA.AR4.ly.jump_m1;
table_rmse_rec(3,:) = RMSE_DATA.AORW4.ly.jump_m1;
table_rmse_rec(4,:) = RMSE_DATA.MS2AR4.ly.jump_m1;
table_rmse_rec(5,:) = RMSE_DATA.UCSV.ly.jump_m1;
table_rmse_rec(6,:) = RMSE_DATA.VAR.ly.jump_m1;

table_ratios_rec(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_ratios_rec(2,:) = rmse_ratio.AR4.ly.jump_m1;
table_ratios_rec(3,:) = rmse_ratio.AORW4.ly.jump_m1;
table_ratios_rec(4,:) = rmse_ratio.MS2AR4.ly.jump_m1;
table_ratios_rec(5,:) = rmse_ratio.UCSV.ly.jump_m1;
table_ratios_rec(6,:) = rmse_ratio.VAR.ly.jump_m1;

table_dmts_rec(2,:) = dm_stats.AR4.ly.jump_m1;
table_dmts_rec(3,:) = dm_stats.AORW4.ly.jump_m1;
table_dmts_rec(4,:) = dm_stats.MS2AR4.ly.jump_m1;
table_dmts_rec(5,:) = dm_stats.UCSV.ly.jump_m1;
table_dmts_rec(6,:) = dm_stats.VAR.ly.jump_m1;



%% Plot +1

subplot(3,2,2)

[row10,col10]=find(1.96>abs(table_dmts_rec)&abs(table_dmts_rec)>1.645);
[row5,col5]=find(abs(table_dmts_rec)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.ly.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.ly.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.ly.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.ly.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.ly.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.ly.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'GDP growth', 'Recessions'},'Fontsize',10);
xlabel('Forecast horizon');
xlim([0 8]);
ylim([0 7]);



%% Inflation

table_ratios_full = nan(6,9);
table_rmse_full = nan(6,9);
table_dmts_full = nan(6,9);

table_ratios_exp = nan(6,9);
table_rmse_exp = nan(6,9);
table_dmts_exp = nan(6,9);

table_ratios_rec = nan(6,9);
table_rmse_rec = nan(6,9);
table_dmts_rec = nan(6,9);

%% Full sample

load 82_13_sample

table_rmse_full(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_rmse_full(2,:) = RMSE_DATA.AR4.lpcpi.jump_m1;
table_rmse_full(3,:) = RMSE_DATA.AORW4.lpcpi.jump_m1;
table_rmse_full(4,:) = RMSE_DATA.MS2AR4.lpcpi.jump_m1;
table_rmse_full(5,:) = RMSE_DATA.UCSV.lpcpi.jump_m1;
table_rmse_full(6,:) = RMSE_DATA.VAR.lpcpi.jump_m1;

table_ratios_full(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_ratios_full(2,:) = rmse_ratio.AR4.lpcpi.jump_m1;
table_ratios_full(3,:) = rmse_ratio.AORW4.lpcpi.jump_m1;
table_ratios_full(4,:) = rmse_ratio.MS2AR4.lpcpi.jump_m1;
table_ratios_full(5,:) = rmse_ratio.UCSV.lpcpi.jump_m1;
table_ratios_full(6,:) = rmse_ratio.VAR.lpcpi.jump_m1;

table_dmts_full(2,:) = dm_stats.AR4.lpcpi.jump_m1;
table_dmts_full(3,:) = dm_stats.AORW4.lpcpi.jump_m1;
table_dmts_full(4,:) = dm_stats.MS2AR4.lpcpi.jump_m1;
table_dmts_full(5,:) = dm_stats.UCSV.lpcpi.jump_m1;
table_dmts_full(6,:) = dm_stats.VAR.lpcpi.jump_m1;


%% Expansion sample

clearvars -except table*
load 82_13_expansion_sample

table_rmse_exp(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_rmse_exp(2,:) = RMSE_DATA.AR4.lpcpi.jump_m1;
table_rmse_exp(3,:) = RMSE_DATA.AORW4.lpcpi.jump_m1;
table_rmse_exp(4,:) = RMSE_DATA.MS2AR4.lpcpi.jump_m1;
table_rmse_exp(5,:) = RMSE_DATA.UCSV.lpcpi.jump_m1;
table_rmse_exp(6,:) = RMSE_DATA.VAR.lpcpi.jump_m1;

table_ratios_exp(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_ratios_exp(2,:) = rmse_ratio.AR4.lpcpi.jump_m1;
table_ratios_exp(3,:) = rmse_ratio.AORW4.lpcpi.jump_m1;
table_ratios_exp(4,:) = rmse_ratio.MS2AR4.lpcpi.jump_m1;
table_ratios_exp(5,:) = rmse_ratio.UCSV.lpcpi.jump_m1;
table_ratios_exp(6,:) = rmse_ratio.VAR.lpcpi.jump_m1;

table_dmts_exp(2,:) = dm_stats.AR4.lpcpi.jump_m1;
table_dmts_exp(3,:) = dm_stats.AORW4.lpcpi.jump_m1;
table_dmts_exp(4,:) = dm_stats.MS2AR4.lpcpi.jump_m1;
table_dmts_exp(5,:) = dm_stats.UCSV.lpcpi.jump_m1;
table_dmts_exp(6,:) = dm_stats.VAR.lpcpi.jump_m1;


%% Plot expansion sample

subplot(3,2,3)

[row10,col10]=find(1.96>abs(table_dmts_exp)&abs(table_dmts_exp)>1.645);
[row5,col5]=find(abs(table_dmts_exp)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.lpcpi.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.lpcpi.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.lpcpi.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.lpcpi.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.lpcpi.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.lpcpi.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'CPI inflation', 'Expansions'},'Fontsize',10);
ylabel('RMSPE');
xlim([0 8]);
ylim([0 5]);


%% Recession sample

clearvars -except table*
load 82_13_recession_sample

table_rmse_rec(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_rmse_rec(2,:) = RMSE_DATA.AR4.lpcpi.jump_m1;
table_rmse_rec(3,:) = RMSE_DATA.AORW4.lpcpi.jump_m1;
table_rmse_rec(4,:) = RMSE_DATA.MS2AR4.lpcpi.jump_m1;
table_rmse_rec(5,:) = RMSE_DATA.UCSV.lpcpi.jump_m1;
table_rmse_rec(6,:) = RMSE_DATA.VAR.lpcpi.jump_m1;

table_ratios_rec(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_ratios_rec(2,:) = rmse_ratio.AR4.lpcpi.jump_m1;
table_ratios_rec(3,:) = rmse_ratio.AORW4.lpcpi.jump_m1;
table_ratios_rec(4,:) = rmse_ratio.MS2AR4.lpcpi.jump_m1;
table_ratios_rec(5,:) = rmse_ratio.UCSV.lpcpi.jump_m1;
table_ratios_rec(6,:) = rmse_ratio.VAR.lpcpi.jump_m1;

table_dmts_rec(2,:) = dm_stats.AR4.lpcpi.jump_m1;
table_dmts_rec(3,:) = dm_stats.AORW4.lpcpi.jump_m1;
table_dmts_rec(4,:) = dm_stats.MS2AR4.lpcpi.jump_m1;
table_dmts_rec(5,:) = dm_stats.UCSV.lpcpi.jump_m1;
table_dmts_rec(6,:) = dm_stats.VAR.lpcpi.jump_m1;



%% Plot +1

subplot(3,2,4)

[row10,col10]=find(1.96>abs(table_dmts_rec)&abs(table_dmts_rec)>1.645);
[row5,col5]=find(abs(table_dmts_rec)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.lpcpi.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.lpcpi.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.lpcpi.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.lpcpi.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.lpcpi.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.lpcpi.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'CPI inflation', 'Recessions'},'Fontsize',10);
xlim([0 8]);
ylim([0 5]);


%%



%% Bank rate

table_ratios_full = nan(6,9);
table_rmse_full = nan(6,9);
table_dmts_full = nan(6,9);

table_ratios_exp = nan(6,9);
table_rmse_exp = nan(6,9);
table_dmts_exp = nan(6,9);

table_ratios_rec = nan(6,9);
table_rmse_rec = nan(6,9);
table_dmts_rec = nan(6,9);

%% Full sample

load 82_13_sample

table_rmse_full(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_rmse_full(2,:) = RMSE_DATA.AR4.bankrate.jump_m1;
table_rmse_full(3,:) = RMSE_DATA.AORW4.bankrate.jump_m1;
table_rmse_full(4,:) = RMSE_DATA.MS2AR4.bankrate.jump_m1;
table_rmse_full(5,:) = RMSE_DATA.UCSV.bankrate.jump_m1;
table_rmse_full(6,:) = RMSE_DATA.VAR.bankrate.jump_m1;

table_ratios_full(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_ratios_full(2,:) = rmse_ratio.AR4.bankrate.jump_m1;
table_ratios_full(3,:) = rmse_ratio.AORW4.bankrate.jump_m1;
table_ratios_full(4,:) = rmse_ratio.MS2AR4.bankrate.jump_m1;
table_ratios_full(5,:) = rmse_ratio.UCSV.bankrate.jump_m1;
table_ratios_full(6,:) = rmse_ratio.VAR.bankrate.jump_m1;

table_dmts_full(2,:) = dm_stats.AR4.bankrate.jump_m1;
table_dmts_full(3,:) = dm_stats.AORW4.bankrate.jump_m1;
table_dmts_full(4,:) = dm_stats.MS2AR4.bankrate.jump_m1;
table_dmts_full(5,:) = dm_stats.UCSV.bankrate.jump_m1;
table_dmts_full(6,:) = dm_stats.VAR.bankrate.jump_m1;


%% Expansion sample

clearvars -except table*
load 82_13_expansion_sample

table_rmse_exp(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_rmse_exp(2,:) = RMSE_DATA.AR4.bankrate.jump_m1;
table_rmse_exp(3,:) = RMSE_DATA.AORW4.bankrate.jump_m1;
table_rmse_exp(4,:) = RMSE_DATA.MS2AR4.bankrate.jump_m1;
table_rmse_exp(5,:) = RMSE_DATA.UCSV.bankrate.jump_m1;
table_rmse_exp(6,:) = RMSE_DATA.VAR.bankrate.jump_m1;

table_ratios_exp(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_ratios_exp(2,:) = rmse_ratio.AR4.bankrate.jump_m1;
table_ratios_exp(3,:) = rmse_ratio.AORW4.bankrate.jump_m1;
table_ratios_exp(4,:) = rmse_ratio.MS2AR4.bankrate.jump_m1;
table_ratios_exp(5,:) = rmse_ratio.UCSV.bankrate.jump_m1;
table_ratios_exp(6,:) = rmse_ratio.VAR.bankrate.jump_m1;

table_dmts_exp(2,:) = dm_stats.AR4.bankrate.jump_m1;
table_dmts_exp(3,:) = dm_stats.AORW4.bankrate.jump_m1;
table_dmts_exp(4,:) = dm_stats.MS2AR4.bankrate.jump_m1;
table_dmts_exp(5,:) = dm_stats.UCSV.bankrate.jump_m1;
table_dmts_exp(6,:) = dm_stats.VAR.bankrate.jump_m1;


%% Plot expansion sample

subplot(3,2,5)

[row10,col10]=find(1.96>abs(table_dmts_exp)&abs(table_dmts_exp)>1.645);
[row5,col5]=find(abs(table_dmts_exp)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.bankrate.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.bankrate.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.bankrate.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.bankrate.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.bankrate.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.bankrate.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'Policy rate', 'Expansions'},'Fontsize',10);
ylabel('RMSPE');
xlim([0 8]);
ylim([0 5]);


%% Recession sample

clearvars -except table*
load 82_13_recession_sample

table_rmse_rec(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_rmse_rec(2,:) = RMSE_DATA.AR4.bankrate.jump_m1;
table_rmse_rec(3,:) = RMSE_DATA.AORW4.bankrate.jump_m1;
table_rmse_rec(4,:) = RMSE_DATA.MS2AR4.bankrate.jump_m1;
table_rmse_rec(5,:) = RMSE_DATA.UCSV.bankrate.jump_m1;
table_rmse_rec(6,:) = RMSE_DATA.VAR.bankrate.jump_m1;

table_ratios_rec(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_ratios_rec(2,:) = rmse_ratio.AR4.bankrate.jump_m1;
table_ratios_rec(3,:) = rmse_ratio.AORW4.bankrate.jump_m1;
table_ratios_rec(4,:) = rmse_ratio.MS2AR4.bankrate.jump_m1;
table_ratios_rec(5,:) = rmse_ratio.UCSV.bankrate.jump_m1;
table_ratios_rec(6,:) = rmse_ratio.VAR.bankrate.jump_m1;

table_dmts_rec(2,:) = dm_stats.AR4.bankrate.jump_m1;
table_dmts_rec(3,:) = dm_stats.AORW4.bankrate.jump_m1;
table_dmts_rec(4,:) = dm_stats.MS2AR4.bankrate.jump_m1;
table_dmts_rec(5,:) = dm_stats.UCSV.bankrate.jump_m1;
table_dmts_rec(6,:) = dm_stats.VAR.bankrate.jump_m1;



%% Plot +1

subplot(3,2,6)

[row10,col10]=find(1.96>abs(table_dmts_rec)&abs(table_dmts_rec)>1.645);
[row5,col5]=find(abs(table_dmts_rec)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

STAFF = plot(x,RMSE_DATA.Staff.bankrate.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.bankrate.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.bankrate.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.bankrate.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.bankrate.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.bankrate.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'Policy rate', 'Recessions'},'Fontsize',10);
xlim([0 8]);
ylim([0 5]);



hL4 = legend([STAFF AR4 AORW4 MS2AR4 UCSV VAR],'Staff','AR4','AORW4','MS(2)-AR(4)','UCSV','VAR','location','south','Orientation','horizontal');
set(hL4,...
    'Position',[0.0886904859826675 0.0150793650793651 0.848214275922094 0.0440476180542083],...
    'Orientation','horizontal');
%%
matlab.graphics.internal.setPrintPreferences('DefaultPaperPositionMode','manual')
saveas(gcf,'Figure_Appendix_D3','epsc');
