
clc; clear;
addpath('ADD_PATH_HERE\Workfiles');
addpath('ADD_PATH_HERE\Scripts');

clearvars -except table*
load 82_13_sample

table_rmse(1,:) = RMSE_DATA.Staff.lpcpix.jump_0;
table_rmse(2,:) = RMSE_DATA.AR4.lpcpix.jump_m1;
table_rmse(3,:) = RMSE_DATA.AORW4.lpcpix.jump_m1;
table_rmse(4,:) = RMSE_DATA.MS2AR4.lpcpix.jump_m1;
table_rmse(5,:) = RMSE_DATA.UCSV.lpcpix.jump_m1;
table_rmse(6,:) = RMSE_DATA.VARc.lpcpix.jump_m1;

table_ratios(1,:) = RMSE_DATA.Staff.lpcpix.jump_0;
table_ratios(2,:) = rmse_ratio.AR4.lpcpix.jump_m1;
table_ratios(3,:) = rmse_ratio.AORW4.lpcpix.jump_m1;
table_ratios(4,:) = rmse_ratio.MS2AR4.lpcpix.jump_m1;
table_ratios(5,:) = rmse_ratio.UCSV.lpcpix.jump_m1;
table_ratios(6,:) = rmse_ratio.VARc.lpcpix.jump_m1;

table_dmts(2,:) = dm_stats.AR4.lpcpix.jump_m1;
table_dmts(3,:) = dm_stats.AORW4.lpcpix.jump_m1;
table_dmts(4,:) = dm_stats.MS2AR4.lpcpix.jump_m1;
table_dmts(5,:) = dm_stats.UCSV.lpcpix.jump_m1;
table_dmts(6,:) = dm_stats.VARc.lpcpix.jump_m1;



%% Plot

[row10,col10]=find(1.96>abs(table_dmts)&abs(table_dmts)>1.645);
[row5,col5]=find(abs(table_dmts)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;

figure

STAFF = plot(x,RMSE_DATA.Staff.lpcpix.jump_0,'-k','LineWidth',1);
hold on;
AR4 = plot(x,RMSE_DATA.AR4.lpcpix.jump_m1,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.lpcpix.jump_m1,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.lpcpix.jump_m1,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.lpcpix.jump_m1,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VARc.lpcpix.jump_m1,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse(find(1.96>abs(table_dmts)&abs(table_dmts)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse(find(abs(table_dmts)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'Core inflation'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0.5 4]);

hL4 = legend([STAFF AR4 AORW4 MS2AR4 UCSV VAR],'Staff','AR4','AORW4','MS(2)-AR(4)','UCSV','VAR','location','southoutside','Orientation','horizontal');


matlab.graphics.internal.setPrintPreferences('DefaultPaperPositionMode','manual')
saveas(gcf,'Figure_Appendix_D2','epsc');