
clc; clear;
addpath('ADD_PATH_HERE\Workfiles');
addpath('ADD_PATH_HERE\Scripts');

load 82_13_sample

table_ratios_0_gdp = nan(6,9);
table_rmse_0_gdp = nan(6,9);
table_dmts_0_gdp = nan(6,9);

table_ratios_2_gdp = nan(6,9);
table_rmse_2_gdp = nan(6,9);
table_dmts_2_gdp = nan(6,9);

table_ratios_0_inf = nan(6,9);
table_rmse_0_inf = nan(6,9);
table_dmts_0_inf = nan(6,9);

table_ratios_2_inf = nan(6,9);
table_rmse_2_inf = nan(6,9);
table_dmts_2_inf = nan(6,9);

table_ratios_0_br = nan(6,9);
table_rmse_0_br = nan(6,9);
table_dmts_0_br = nan(6,9);

table_ratios_2_br = nan(6,9);
table_rmse_2_br = nan(6,9);
table_dmts_2_br = nan(6,9);


%% jump_off 0, GDP

table_rmse_0_gdp(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_rmse_0_gdp(2,:) = RMSE_DATA.AR4.ly.jump_0;
table_rmse_0_gdp(3,:) = RMSE_DATA.AORW4.ly.jump_0;
table_rmse_0_gdp(4,:) = RMSE_DATA.MS2AR4.ly.jump_0;
table_rmse_0_gdp(5,:) = RMSE_DATA.UCSV.ly.jump_0;
table_rmse_0_gdp(6,:) = RMSE_DATA.VAR.ly.jump_0;

table_ratios_0_gdp(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_ratios_0_gdp(2,:) = rmse_ratio.AR4.ly.jump_0;
table_ratios_0_gdp(3,:) = rmse_ratio.AORW4.ly.jump_0;
table_ratios_0_gdp(4,:) = rmse_ratio.MS2AR4.ly.jump_0;
table_ratios_0_gdp(5,:) = rmse_ratio.UCSV.ly.jump_0;
table_ratios_0_gdp(6,:) = rmse_ratio.VAR.ly.jump_0;

table_dmts_0_gdp(2,:) = dm_stats.AR4.ly.jump_0;
table_dmts_0_gdp(3,:) = dm_stats.AORW4.ly.jump_0;
table_dmts_0_gdp(4,:) = dm_stats.MS2AR4.ly.jump_0;
table_dmts_0_gdp(5,:) = dm_stats.UCSV.ly.jump_0;
table_dmts_0_gdp(6,:) = dm_stats.VAR.ly.jump_0;

table_dmts_0_gdp(:,1) = NaN;


%% jump_off +2, GDP

table_rmse_2_gdp(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_rmse_2_gdp(2,:) = RMSE_DATA.AR4.ly.jump_2;
table_rmse_2_gdp(3,:) = RMSE_DATA.AORW4.ly.jump_2;
table_rmse_2_gdp(4,:) = RMSE_DATA.MS2AR4.ly.jump_2;
table_rmse_2_gdp(5,:) = RMSE_DATA.UCSV.ly.jump_2;
table_rmse_2_gdp(6,:) = RMSE_DATA.VAR.ly.jump_2;

table_ratios_2_gdp(1,:) = RMSE_DATA.Staff.ly.jump_0;
table_ratios_2_gdp(2,:) = rmse_ratio.AR4.ly.jump_2;
table_ratios_2_gdp(3,:) = rmse_ratio.AORW4.ly.jump_2;
table_ratios_2_gdp(4,:) = rmse_ratio.MS2AR4.ly.jump_2;
table_ratios_2_gdp(5,:) = rmse_ratio.UCSV.ly.jump_2;
table_ratios_2_gdp(6,:) = rmse_ratio.VAR.ly.jump_2;

table_dmts_2_gdp(2,:) = dm_stats.AR4.ly.jump_2;
table_dmts_2_gdp(3,:) = dm_stats.AORW4.ly.jump_2;
table_dmts_2_gdp(4,:) = dm_stats.MS2AR4.ly.jump_2;
table_dmts_2_gdp(5,:) = dm_stats.UCSV.ly.jump_2;
table_dmts_2_gdp(6,:) = dm_stats.VAR.ly.jump_2;

table_dmts_2_gdp(:,1) = NaN;

%% jump_off 0, Inflation

table_rmse_0_inf(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_rmse_0_inf(2,:) = RMSE_DATA.AR4.lpcpi.jump_0;
table_rmse_0_inf(3,:) = RMSE_DATA.AORW4.lpcpi.jump_0;
table_rmse_0_inf(4,:) = RMSE_DATA.MS2AR4.lpcpi.jump_0;
table_rmse_0_inf(5,:) = RMSE_DATA.UCSV.lpcpi.jump_0;
table_rmse_0_inf(6,:) = RMSE_DATA.VAR.lpcpi.jump_0;

table_ratios_0_inf(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_ratios_0_inf(2,:) = rmse_ratio.AR4.lpcpi.jump_0;
table_ratios_0_inf(3,:) = rmse_ratio.AORW4.lpcpi.jump_0;
table_ratios_0_inf(4,:) = rmse_ratio.MS2AR4.lpcpi.jump_0;
table_ratios_0_inf(5,:) = rmse_ratio.UCSV.lpcpi.jump_0;
table_ratios_0_inf(6,:) = rmse_ratio.VAR.lpcpi.jump_0;

table_dmts_0_inf(2,:) = dm_stats.AR4.lpcpi.jump_0;
table_dmts_0_inf(3,:) = dm_stats.AORW4.lpcpi.jump_0;
table_dmts_0_inf(4,:) = dm_stats.MS2AR4.lpcpi.jump_0;
table_dmts_0_inf(5,:) = dm_stats.UCSV.lpcpi.jump_0;
table_dmts_0_inf(6,:) = dm_stats.VAR.lpcpi.jump_0;

table_dmts_0_inf(:,1) = NaN;

%% jump_off +2, Inflation

table_rmse_2_inf(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_rmse_2_inf(2,:) = RMSE_DATA.AR4.lpcpi.jump_2;
table_rmse_2_inf(3,:) = RMSE_DATA.AORW4.lpcpi.jump_2;
table_rmse_2_inf(4,:) = RMSE_DATA.MS2AR4.lpcpi.jump_2;
table_rmse_2_inf(5,:) = RMSE_DATA.UCSV.lpcpi.jump_2;
table_rmse_2_inf(6,:) = RMSE_DATA.VAR.lpcpi.jump_2;

table_ratios_2_inf(1,:) = RMSE_DATA.Staff.lpcpi.jump_0;
table_ratios_2_inf(2,:) = rmse_ratio.AR4.lpcpi.jump_2;
table_ratios_2_inf(3,:) = rmse_ratio.AORW4.lpcpi.jump_2;
table_ratios_2_inf(4,:) = rmse_ratio.MS2AR4.lpcpi.jump_2;
table_ratios_2_inf(5,:) = rmse_ratio.UCSV.lpcpi.jump_2;
table_ratios_2_inf(6,:) = rmse_ratio.VAR.lpcpi.jump_2;

table_dmts_2_inf(2,:) = dm_stats.AR4.lpcpi.jump_2;
table_dmts_2_inf(3,:) = dm_stats.AORW4.lpcpi.jump_2;
table_dmts_2_inf(4,:) = dm_stats.MS2AR4.lpcpi.jump_2;
table_dmts_2_inf(5,:) = dm_stats.UCSV.lpcpi.jump_2;
table_dmts_2_inf(6,:) = dm_stats.VAR.lpcpi.jump_2;

table_dmts_2_inf(:,1) = NaN;

%% jump_off 0, Bankrate

table_rmse_0_br(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_rmse_0_br(2,:) = RMSE_DATA.AR4.bankrate.jump_0;
table_rmse_0_br(3,:) = RMSE_DATA.RW.bankrate.jump_0;
table_rmse_0_br(4,:) = RMSE_DATA.MS2AR4.bankrate.jump_0;
table_rmse_0_br(5,:) = RMSE_DATA.UCSV.bankrate.jump_0;
table_rmse_0_br(6,:) = RMSE_DATA.VAR.bankrate.jump_0;

table_ratios_0_br(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_ratios_0_br(2,:) = rmse_ratio.AR4.bankrate.jump_0;
table_ratios_0_br(3,:) = rmse_ratio.RW.bankrate.jump_0;
table_ratios_0_br(4,:) = rmse_ratio.MS2AR4.bankrate.jump_0;
table_ratios_0_br(5,:) = rmse_ratio.UCSV.bankrate.jump_0;
table_ratios_0_br(6,:) = rmse_ratio.VAR.bankrate.jump_0;

table_dmts_0_br(2,:) = dm_stats.AR4.bankrate.jump_0;
table_dmts_0_br(3,:) = dm_stats.RW.bankrate.jump_0;
table_dmts_0_br(4,:) = dm_stats.MS2AR4.bankrate.jump_0;
table_dmts_0_br(5,:) = dm_stats.UCSV.bankrate.jump_0;
table_dmts_0_br(6,:) = dm_stats.VAR.bankrate.jump_0;

table_dmts_0_br(:,1) = NaN;

%% jump_off 0, Bankrate

table_rmse_2_br(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_rmse_2_br(2,:) = RMSE_DATA.AR4.bankrate.jump_2;
table_rmse_2_br(3,:) = RMSE_DATA.RW.bankrate.jump_2;
table_rmse_2_br(4,:) = RMSE_DATA.MS2AR4.bankrate.jump_2;
table_rmse_2_br(5,:) = RMSE_DATA.UCSV.bankrate.jump_2;
table_rmse_2_br(6,:) = RMSE_DATA.VAR.bankrate.jump_2;

table_ratios_2_br(1,:) = RMSE_DATA.Staff.bankrate.jump_0;
table_ratios_2_br(2,:) = rmse_ratio.AR4.bankrate.jump_2;
table_ratios_2_br(3,:) = rmse_ratio.RW.bankrate.jump_2;
table_ratios_2_br(4,:) = rmse_ratio.MS2AR4.bankrate.jump_2;
table_ratios_2_br(5,:) = rmse_ratio.UCSV.bankrate.jump_2;
table_ratios_2_br(6,:) = rmse_ratio.VAR.bankrate.jump_2;

table_dmts_2_br(2,:) = dm_stats.AR4.bankrate.jump_2;
table_dmts_2_br(3,:) = dm_stats.RW.bankrate.jump_2;
table_dmts_2_br(4,:) = dm_stats.MS2AR4.bankrate.jump_2;
table_dmts_2_br(5,:) = dm_stats.UCSV.bankrate.jump_2;
table_dmts_2_br(6,:) = dm_stats.VAR.bankrate.jump_2;

table_dmts_2_br(:,1) = NaN;

%%

figure

%% Plot -1, GDP

subplot(3,2,1)

[row10,col10]=find(1.96>abs(table_dmts_0_gdp)&abs(table_dmts_0_gdp)>1.645);
[row5,col5]=find(abs(table_dmts_0_gdp)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;


AR4 = plot(x,RMSE_DATA.AR4.ly.jump_0,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.ly.jump_0,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.ly.jump_0,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.ly.jump_0,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.ly.jump_0,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse_0_gdp(find(1.96>abs(table_dmts_0_gdp)&abs(table_dmts_0_gdp)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_0_gdp(find(abs(table_dmts_0_gdp)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
STAFF = plot(x,RMSE_DATA.Staff.ly.jump_0,'-k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'GDP','jump-off: 0'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([1.5 4]);

%% Plot +1, GDP

subplot(3,2,2)

[row10,col10]=find(1.96>abs(table_dmts_2_gdp)&abs(table_dmts_2_gdp)>1.645);
[row5,col5]=find(abs(table_dmts_2_gdp)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;


AR4 = plot(x,RMSE_DATA.AR4.ly.jump_2,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.ly.jump_2,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.ly.jump_2,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.ly.jump_2,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.ly.jump_2,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse_2_gdp(find(1.96>abs(table_dmts_2_gdp)&abs(table_dmts_2_gdp)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_2_gdp(find(abs(table_dmts_2_gdp)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
STAFF = plot(x,RMSE_DATA.Staff.ly.jump_0,'-k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'GDP','jump-off: +2'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([1.5 4]);


%% Plot -1, Inflation

subplot(3,2,3)

[row10,col10]=find(1.96>abs(table_dmts_0_inf)&abs(table_dmts_0_inf)>1.645);
[row5,col5]=find(abs(table_dmts_0_inf)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;


AR4 = plot(x,RMSE_DATA.AR4.lpcpi.jump_0,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.lpcpi.jump_0,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.lpcpi.jump_0,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.lpcpi.jump_0,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.lpcpi.jump_0,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse_0_inf(find(1.96>abs(table_dmts_0_inf)&abs(table_dmts_0_inf)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_0_inf(find(abs(table_dmts_0_inf)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
STAFF = plot(x,RMSE_DATA.Staff.lpcpi.jump_0,'-k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'CPI inflation','jump-off: 0'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0.5 3.5]);

%% Plot +1, Inflation

subplot(3,2,4)

[row10,col10]=find(1.96>abs(table_dmts_2_inf)&abs(table_dmts_2_inf)>1.645);
[row5,col5]=find(abs(table_dmts_2_inf)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;


AR4 = plot(x,RMSE_DATA.AR4.lpcpi.jump_2,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.AORW4.lpcpi.jump_2,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.lpcpi.jump_2,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.lpcpi.jump_2,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.lpcpi.jump_2,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse_2_inf(find(1.96>abs(table_dmts_2_inf)&abs(table_dmts_2_inf)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_2_inf(find(abs(table_dmts_2_inf)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
STAFF = plot(x,RMSE_DATA.Staff.lpcpi.jump_0,'-k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'CPI inflation','jump-off: +2'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0.5 3.5]);


%% Plot -1, Bank rate

subplot(3,2,5)

[row10,col10]=find(1.96>abs(table_dmts_0_br)&abs(table_dmts_0_br)>1.645);
[row5,col5]=find(abs(table_dmts_0_br)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;


AR4 = plot(x,RMSE_DATA.AR4.bankrate.jump_0,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.RW.bankrate.jump_0,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.bankrate.jump_0,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.bankrate.jump_0,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.bankrate.jump_0,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse_0_br(find(1.96>abs(table_dmts_0_br)&abs(table_dmts_0_br)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_0_br(find(abs(table_dmts_0_br)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
STAFF = plot(x,RMSE_DATA.Staff.bankrate.jump_0,'-k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'Policy rate','jump-off: 0'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0 3.5]);

%% Plot +1, Bank rate

subplot(3,2,6)

[row10,col10]=find(1.96>abs(table_dmts_2_br)&abs(table_dmts_2_br)>1.645);
[row5,col5]=find(abs(table_dmts_2_br)>1.96);

PARAMS.irfhorizon       = 8;

zeroline = zeros(PARAMS.irfhorizon,1);
a = 1;
x = 0:8;


AR4 = plot(x,RMSE_DATA.AR4.bankrate.jump_2,':b','Color',[1 0 0],'LineWidth',1.5);
hold on;
AORW4 = plot(x,RMSE_DATA.RW.bankrate.jump_2,'--b','Color',[0 1 0],'LineWidth',1);
hold on;
MS2AR4 = plot(x,RMSE_DATA.MS2AR4.bankrate.jump_2,'--k','Color',[1 0 1],'LineWidth',1);
hold on;
UCSV = plot(x,RMSE_DATA.UCSV.bankrate.jump_2,':k','Color',[0 0 1],'LineWidth',1.5);
hold on;
VAR = plot(x,RMSE_DATA.VAR.bankrate.jump_2,'-b','Color',[0 1 1],'LineWidth',1);
hold on;
plot(col10'-1,(table_rmse_2_br(find(1.96>abs(table_dmts_2_br)&abs(table_dmts_2_br)>1.645)))','ko','MarkerSize',4,'LineWidth',1);
hold on;
plot(col5'-1,(table_rmse_2_br(find(abs(table_dmts_2_br)>1.96)))','ko','MarkerSize',4,'MarkerFaceColor','k','LineWidth',1);
hold on;
STAFF = plot(x,RMSE_DATA.Staff.bankrate.jump_0,'-k','LineWidth',1);
hold on;
plot(zeroline,':k');
grid on;
ax=gca;
ax.GridLineStyle = ':';
ax.FontSize = 8;
set(gca,'Xtick',linspace(0,8,9));
title({'Policy rate','jump-off: +2'},'Fontsize',10);
xlabel('Forecast horizon');
ylabel('RMSPE');
xlim([0 8]);
ylim([0 3.5]);


hL = legend([STAFF AR4 AORW4 MS2AR4 UCSV VAR],'Staff','AR4','AORW4','MS(2)-AR(4)','UCSV','VAR','location','south','Orientation','horizontal');
set(hL,...
    'Position',[0.0886904859826675 0.0150793650793651 0.848214275922094 0.0440476180542083],...
    'Orientation','horizontal');

matlab.graphics.internal.setPrintPreferences('DefaultPaperPositionMode','manual')
saveas(gcf,'Figure_Appendix_D1','epsc');
