
%% graph settings
step=24;

dateslabshort=regexprep(dateslab,'^19|^20','');


xtick=sort(T:-step:1);

usedfont='Garamond';
fontaxsize=10;
qualitystr='-r200';

b_savefig=true;



%%
FigW=16; FigH=20;
figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);

for j=1:n
    subaxis(5,4,j,'Margin',.06,'SpacingVertical',0.08,'SpacingHorizontal',0.04);
    
    hold on
    plot(Y(j,:),'k');
    hold on
    str_title=short_desc{j};
    set(gca,'XTick',xtick); 
    set(gca,'xticklabel',dateslabshort(xtick),'XTickLabelRotation',90)
   
    plotband5(standardize(qfactors,1));
    
   axis tight
 grid on
 
 set(gca,'fontname',usedfont,'fontsize',fontaxsize);
  title(str_title,'fontname',usedfont,'fontsize',fontaxsize)
 
 
end

if b_savefig
namefileplot=['./figures/' model '_DataVsObsFactor_subplot.png'];
    print('-dpng',qualitystr,namefileplot)
end
%%
FigW=20; FigH=10;





figure
set(gcf,'color', 'white',...
    'PaperUnits','centimeters','PaperSize',[FigW FigH],...
    'PaperPosition',[0,0,FigW,FigH],'PaperPositionMode','manual',...
    'Units','normalized',...
    'OuterPosition',[0,0,1,1]);

subaxis(1,1,1,'Margin',.03,'MarginBottom',.15,'SpacingVertical',0.1,'SpacingHorizontal',0.05);
     linetdata=plot(Y',':','LineWidth',1);
    hold on
    set(gca,'XTick',xtick,'YTick',[]); 
    set(gca,'xticklabel',dateslab(xtick),'XTickLabelRotation',45)

    plotband5(standardize(qfactors,1));
   axis tight
 grid on
 
 set(gca,'fontname',usedfont,'fontsize',fontaxsize);
  title('','fontname',usedfont,'fontsize',fontaxsize)
  
 
 
 if b_savefig
 namefileplot=['./figures/' model '_DataVsObsFactor.png'];
 print('-dpng',qualitystr,namefileplot)
 end

 


