function [A,T]=make_tril_A_pages(alphas)

%INPUTS: alphas is rxT
% Copyright (c) 2013-2018, Francesco Corsello, All Rights Reserved.
[r,T]=size(alphas);
m=(1/2)*sqrt((8.*r+1))+(1/2);

    if mod(m,1)==0  
        AA=zeros(m^2,T);
        zz=triu(ones(m))-eye(m);
        z=zz(:);
        AA(logical(z),:)=alphas;
        A=permute(reshape(AA,m,m,T),[2 1 3])+repmat(eye(m),[1,1,T]);
    else
        error('input should be of the proper dimension!')
    end


end