function B0=make_B0_restricted(b0_tilde,fblks)

% b0_tilde is the vector of the unrestricted coefficients free to change
% b0_tilde is   (n-r)x 1  or 1x (n-r)
% fblks is the 1xr  vector containing how many
% components for each block [  n_1, n_2, ..., n_r ]  .

r=length(fblks);
n=sum(fblks);

 if not(length(b0_tilde) == n-r)
     errmsg=['Dimensionality error of factor blocks: ' num2str(n) ...
         ' variables, ' num2str(r) ' blocks and  ' num2str(length(b0_tilde)) ...
          ' unrestricted coefficients instead of ' num2str(n-r) ];
    error(errmsg) 
 end

cfblks=[ 0 cumsum(vec(fblks-1,1)) ];

b0th=vec(b0_tilde,1);

B0_restr_base=sparse(1:r, cumsum(vec(fblks,1))-fblks+1,ones(1,r),r,n);


indrows=[];
indcol=[];
for j=1:r
    fbs=fblks(j)-1;
    if fbs>0
    indrows=[indrows ,j*ones(1,fbs)];
    indcol=[indcol, cfblks(j)+j+1 :  cfblks(j)+j+fbs];
    else
        continue
    end
end
B0=sparse(indrows,indcol,b0th,r,n)    +B0_restr_base;