function prior=build_prior_std_MAIAR_SV(Y,info_argument,qp,tend_training,mfirstlag,tstart_est)

%           prior the structure containing
%           prior.a_bar, prior.Va
%           prior.mb0,prior.vb0,
%           prior.g_bar, prior.Vg
%           prior.logsigma_bar ,prior.Ps_bar, prior.Qs_bar, prior.tau0s

if nargin < 6
    tstart_est=1;
end
%setting the number of ingredients

n=size(Y,2);  
q=qp(1);
p=qp(2);
int_train=tstart_est:tend_training;

r=length(info_argument);

warning off


%% gamma
prior.gamma_bar=[vec(mfirstlag);zeros(n*(q-1),1)];

lambda=1;
prior.Vgamma=diag((lambda^2)* kron(vec(1:q).^(-1) ,  ones(n,1) )  );

%% B0

        prior.mb0=zeros(n-r,1);
        prior.vb0=zeros(n-r,1);
        fblks=info_argument;
        if sum(fblks)~=n
             error('The numbers of variables in the blocks allocation does not correspond to the counterpart in the data')
        end
        cfblks=[ 0 cumsum(vec(fblks-1,1)) ];
        for j=1:r
            
            nj=fblks(j);
            if nj<2
                continue
            else
                
                fbs=fblks(j)-1;          cfbs=cfblks(j);
                yj=Y(int_train,cfbs+j :  cfbs+j+fbs );
                [aaj,scorej]=pca(yj);
                 coeff1=quickOLS_omitNan(Y(int_train,cfbs+j), scorej(:,1),false);
                 
                for k=2:nj
                    yjk=yj(:,k);
                    [jcoeff,~,~,~,jSE]=quickOLS_omitNan(coeff1*yjk, scorej(:,1),false);
                    prior.mb0(cfbs+k-1)=jcoeff;
                    prior.vb0(cfbs+k-1)=(jSE)^2;
                end
                
            end
            
        end

%% prepare prior for A 

prior.a_bar=zeros(n*r*p,1);
[y_train,~,~,~,m,~,Ttrain]=prep_data_TV_VAR(  transpose(Y(int_train,:)) ,p);%n x T_train

var_y_ar1=zeros(n,1);
for jj=1:n
    var_y_ar1(jj)=compute_ar1_err_variance(y_train(jj,:));
end
lambda=sqrt(0.2);
Ups=diag((lambda^2)* kron([1:p]'.^(-2) ,  ones(r,1) )  );
prior.Va=kron(eye(n),Ups);

%%  prepare prior for G and sigma
%           prior.g_bar, prior.Vg
%           prior.logsigma_bar ,prior.Ps_bar, prior.Qs_bar, prior.tau0s
prior.g_bar= zeros(m,1);
prior.Vg=1e6*eye(m);
prior.logsigma_bar=log(sqrt(var_y_ar1));
prior.Ps_bar=eye(n);
ks=1e-1;
Qs_full=(ks^2)*(n+1)*eye(n);
prior.Qs_bar=Qs_full;
prior.tau0s=n+1;
