function  [b0new,acc]=RW_metro_step_b0(loglik_str,b0_tilde,info_argument,y,A,x_bul,G_g,sigmas,c,mb0,vb0)


%  Metropolis step for the j-th component of the b0_tilde vector
%
%   INPUT:
%  -loglik_str is the string name of the likelihood function
%  -b0_tilde is the previous step vector of unrestricted coefficients%
%  -y is the nxT matrix containing data
%  -A is the nxrp or nxrpxT matrix containing the loadings (TV or constant)
%  -G_g and sigmas are the components of the triangular decomposition of  Omegas
%  -c is the scaling factor that needs calibration (scalar)
%  -mb0 and vb0 are the (n-r)x1 vectors of means and variances of the normal
%  independent priors of each b0j
%  -fblks is the 1xr  vector containing how many components for each block [  n_1, n_2, ..., n_r ] 
%  -x_bul  is  nxpxT  matrix of lagged variables

%  Z_t= vec ( B0 * x_t_bul)   , x_t_bul=[y_t-1 ... y_t-p] ,   nxp matrix
%  B0 is rxn,  Z_t is rpx1  

%  Author: Francesco Corsello, November 2015

r=length(info_argument);


rp=size(A,2);
[n,T]=size(y);

sizeb0=size(mb0,1);

acc=zeros(sizeb0,1);

B0=make_B0_restricted(b0_tilde,info_argument);
Z=reshape(mtimesx(B0, x_bul),[rp,T]);     %  rpxT

logLk=feval(loglik_str,y,A,Z,G_g,sigmas);

b0new=b0_tilde;

b_mult_c=length(c)>1;

for j=1:sizeb0
    if b_mult_c
        cc=c(j);
    else
        cc=c;
    end
    %Random walk candidate
    b0j_cand=b0_tilde(j)+cc*(sqrt(vb0(j))*randn);
    b0_tilde_=b0_tilde;
    b0_tilde_(j)=b0j_cand;
    
    B0_=make_B0_restricted(b0_tilde_,info_argument);
    Z_=reshape(mtimesx(B0_, x_bul),[rp,T]);     %  rpxT
    
    logLk_=feval(loglik_str,y,A,Z_,G_g,sigmas);    

    logpost_= logLk_ +     log(normpdf(  b0j_cand  , mb0(j), sqrt(vb0(j))   ));
    logpost = logLk  +   log(normpdf(  b0_tilde(j)  , mb0(j), sqrt(vb0(j))   ));
    fratio=exp(logpost_-logpost);

    alpha=min([ 1 fratio]);
   
    u=rand;
    if u<=alpha
        b0new(j)=b0j_cand;
        acc(j)=1;
    end
end
    
    
    
    