function ml = mlikelihood_condTight(para_,Ystar,YY,XX,XY,lambdas)
global  GXX0 GXY0 GYY0 SS0 JSZ k N T %YY XX XY %K0P_cP K1P_cP;
% global datamat W dt maturity;%

Tstar=lambdas*T;

if JSZ==0; %minnesota
        GXX=GXX0/T;     GXY=GXY0/T;   GYY=GYY0/T;   
        Phi_stard = GXX\GXY; 
        Sig_stard = lambdas*SS0;  % which is equal to S_prior =Tstar*(GYY-GXY'/GXX*GXY);
elseif JSZ==1; %JSZ
        [GYY,GXY,GXX,retcode] = Moments(para_); %compute moments
        if retcode == 0; ml = -3e+10; return; end; % case of nonstationarity or other problems
        Phi_stard = GXX\GXY;
        Sig_stard = GYY -GXY'*Phi_stard;
end;

if isinf(lambdas)
    
    
    ml = -0.5*N*T*log(2*pi)-0.5*T*log(det(Sig_stard)) ...
         -0.5*sum(diag(inv(Sig_stard)*(YY-2*Phi_stard'*XY+Phi_stard'*XX*Phi_stard))); %#ok<MINV>
     
elseif ~isinf(lambdas);
    
    %mixed moments
	MYY = YY + Tstar*GYY;
	MXY = XY + Tstar*GXY;
	MXX = XX + Tstar*GXX;
    Sig_tilde = (MYY -MXY'/MXX*MXY)/(T+Tstar);
    
    % check positive definiteness of inv(S)
    [~,p] = chol(inv(Sig_tilde*(T+Tstar)));
    if p > 0; ml = -3e+10; return; end;

    %ML (Eq. A5)
	lnkapt = -0.5*N*T*log(2*pi) + 0.5*N*T*log(2);
    for i = 1:N
    lnkapt = lnkapt+gammaln(0.5*(T+Tstar-k+1-i))-gammaln(0.5*(Tstar-k+1-i));  
    end
    %this seems to provide the best numerical behavior
    ml  = lnkapt  - 0.5*(T+Tstar-k)*log(det((T+Tstar)*Sig_tilde)) + 0.5*(Tstar-k)*log(det(Tstar*Sig_stard)) ...
    - 0.5*N*log(det(MXX)) + 0.5*N*log(det(Tstar*GXX));
    
end

         

