%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Likelihoood function.  Very extreme parameters may have numerical
% problems since some intermediate matrices may be nearly non-singular.  In
% this case set the likelihood to a "bad" default value.
function [llk, K1Q_X, Sigma_cP] = llk_fun0(yields, W, dlamQ, cholSigma_cP, mats, dt)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Extract the vector parameters:
N = length(dlamQ);
K1Q_X = diag(cumsum(dlamQ));
inds = find(tril(ones(N)));
L(inds) = cholSigma_cP;
L = reshape(L, [N,N]);
Sigma_cP = L*L';
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

default_llk = 1000; 
try
    llk = mean(jszLLK_kinf_conc(yields, W, K1Q_X, Sigma_cP, mats, dt));
    if isnan(llk) || ~isreal(llk) || ~isfinite(llk)
        llk = default_llk;
    end
catch
	llk = default_llk;
end

if llk<-100
    [llks, AcP, BcP, AX, BX, kinfQ, K0P_cP, K1P_cP, sigma_e, K0Q_cP, K1Q_cP, rho0_cP, rho1_cP, cP, llkP, llkQ,  K0Q_X, K1Q_X, rho0_X, rho1_X] = ...
        jszLLK_kinf_conc(yields, W, K1Q_X, Sigma_cP, mats, dt);
    keyboard
end
