function [B0,B1,Omega0,Omega1,S0,S1,v0,v1]=create_prior(teta_draw,YY,XX,XY)
global lambdas T k

        if  ~isinf(lambdas); %% && lambdas>0; 

            % prior moment matrices
            if lambdas~=0;     [GYY,GXY,GXX,~] = Moments(teta_draw); 
            elseif lambdas==0;  GYY=0; GXY=0; GXX=0;
            end
            
            % cure some ill conditioned cases
            if lambdas~=0 && sum(sum(GXX))==0; GYY=0; GXY=0; GXX=0; end;
            
            iGXX=GXX\eye(k);
            Tstar=lambdas*T;
            
            %Prior moments
            B0=iGXX*GXY;            Omega0=iGXX;
            v0=Tstar-k;             S0=Tstar*(GYY-GXY'/GXX*GXY); 
                       
            %mixed moment matrices
            MYY = YY + Tstar*GYY;	MXY = XY + Tstar*GXY;	
            MXX = XX + Tstar*GXX;   iMXX = MXX\eye(k);
            
            %posterior moments to use in next step
            B1  = iMXX*MXY; %%Eq.21 (ML of joint sample)
            Omega1= iMXX;
            S1 =(MYY-MXY'*iMXX*MXY); %% This is sig_tilda*(T + Tstar), scale matrix in Eq.20
            v1 = round(T + v0);
            
        elseif isinf(lambdas);

            %moment matrices
            [GYY,GXY,GXX,~] = Moments(teta_draw); 
            iGXX=GXX\eye(k);
            Tstar=lambdas*T;
            
            %Prior and posterior moments
            B0=iGXX*GXY;            Omega0=iGXX;
            v0=Tstar-k; %this will be infinity!  see DNS page 654
            S0=(GYY-GXY'/GXX*GXY); % therefore this is no longer the scale matrix but
                                   % its epectation, fixed at its prior mode! see DNS page 654
                                   % However, this
                                   % result does not imply that the actual observations 
                                   % have no influence on the overall
                                   % posterior distribution! it simply
                                   % means that the
                                   % marginal-likelihood function approaches
                                   % the (quasi)-likelihood function
                                   % of the JSZ model. So it coincides
                                   % with the estimation of the JSZ model
                                   
           B1=B0; Omega1=Omega0; v1=v0; S1=S0;
        end;