function [yyyyd,xxyyd,xxxxd,retcode] = Moments(para)
%adaptation from An/Schorfheide gauss code
global N NoF nlags k dt maturity  K0P_cP_ K1P_cP_ W_ cP_;
retcode=1;

%% Compute state space 
% note for the posterior mode we impose stationarity on F ex post

% %  OLD VERSION
% % % datamat_star=Ystar;
% % % W_ = pcacov(cov(datamat_star));
% % % W_ = W_(:,1:NoF)';  % N*J
% % % cP_ = datamat_star*W_'; % T*N
% % % % Run OLS on PC to obtain maximum likelihood estimates of K0P, K1P
% % % [K1PplusI_, K0P_cP_, ScP] = regressVAR(cP_);
% % % K1P_cP_ = K1PplusI_ - eye(NoF);

% keyboard;
% datamat_star=Ystar;
[mu,mp,F,Q,Q0,D,H,R] = ss_JSZ(para,  W_, maturity, dt,  K0P_cP_, K1P_cP_,cP_); % state space


%% checks

%check if teta is well behaved
if mu==999; %display('nonstationary draw');
retcode=0; yyyyd = zeros(N,N); xxyyd = zeros(k,N); xxxxd = zeros(k,k);
return; 
end;

%check F is well behaved
if isnan(sum(sum(F))) || isinf(sum(sum(F))); display('F is NaN or Inf');
retcode=0; 
yyyyd = zeros(N,N);
xxyyd = zeros(k,N);
xxxxd = zeros(k,k);
return; 
end;

%check F is stationary
if max(eig(F))>0.999 || rcond(F)<1e-15; 
%     display('F is nonstationary');
%     display(F); display(eigs(F));
retcode=0; 
yyyyd = zeros(N,N);
xxyyd = zeros(k,N);
xxxxd = zeros(k,k);
return; 
end;

%% compute moments

% coefficients
B=H; ZZ=B;
A=D; Astar=A+B*mp; DD=Astar;
TTT=F;

% variances
RRR=chol(Q);
HH=R;
GA0 = Q0; 
VV=zeros(NoF,N);

% % % no measurement error
% % RRR=0*chol(Q);
% % GA0 = 0*Q0; 

%% Compute moments

% Compute nlags autocovariances
GAMM0 = zeros(N^2,nlags+1);
Gl   = ZZ*GA0*ZZ' + ZZ*RRR*VV + (ZZ*RRR*VV)' + HH;
Gl = Gl';
GAMM0(:,1) = Gl(:);

TTl = TTT;
for l = 1:nlags;        
    GAMM0(:,l+1) = vec((ZZ*(TTl*GA0)*ZZ' + ZZ*(TTl*RRR*VV))');
	TTl = TTl*TTT;
end

% Create limit cross product matrices
yyyyd = reshape(GAMM0(:,1)',N,N)' + DD*DD';

xxyyd = DD;
for l = 1:nlags;
    xxyyd = [xxyyd  (reshape(GAMM0(:,l+1)',N,N)' + DD*DD')]; %#ok<AGROW>
end
xxyyd = xxyyd';

xxxxd = zeros(k,k);
xxxxd(1,1) = 1;
xxxxd(1,2:k) = kron(ones(1,nlags),DD');
xxxxd(2:k,1) = kron(ones(nlags,1),DD);
for r = 1:nlags;
	for l = r:nlags;	
		xxxxd(1+N*(r-1)+1:1+N*r,1+N*(l-1)+1:1+N*l) = reshape(GAMM0(:,l-r+1)',N,N)'+DD*DD';
		xxxxd(1+N*(l-1)+1:1+N*l,1+N*(r-1)+1:1+N*r) = reshape(GAMM0(:,l-r+1)',N,N) +DD*DD';
	end
end

    
%% checks

%%check xxxxd is well conditioned
ck=xxxxd;
if rcond(ck)<1e-15 || isnan(rcond(ck))==1;
retcode=0;  display('draw rejected: inv(XX) is ill condintioned');
yyyyd = zeros(N,N);
xxyyd = zeros(k,N);
xxxxd = zeros(k,k);
return; 
end;

%%check ixxxxd is pd
ixxxxd=xxxxd\eye(k); %inv(xxxxd)
ck=ixxxxd;
[~,p] =chol(ck);
if  p>0; display('draw rejected: inv(XX) is not pd');
retcode=0; 
yyyyd = zeros(N,N);
xxyyd = zeros(k,N);
xxxxd = zeros(k,k);
return; 
end

%%check if the implied VAR posterior mean is stationary
ps = reshape(vec(ixxxxd*xxyyd),k,N)';		
ck =  [ps(:,(1+1):k) ; [eye(N*(nlags-1)),zeros(N*(nlags-1),N)]];                        
if  max(abs(eig(ck))) >= 1; display('draw rejected: explosive fscts');
retcode=0; 
yyyyd = zeros(N,N);
xxyyd = zeros(k,N);
xxxxd = zeros(k,k);
return; 
end;



