function [f,teta,standarderrors]=MaxLikJSZ(datamat_o,computehessianJSZ)
global  NoF maturity dt N crit

%% ML estimate of the JSZ model
% this is performed in 3 steps. First optimal initial conditions are
% found using OLS and PC. Then we generate randomly around these
% parameters, to improve the starting point. These two parts are based on 
% code from JSZ. Finally, optimization takes place using SIMS algorithm. 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Part 1: OLS and PC
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % extract PC
W = pcacov(cov(datamat_o));
W = W(:,1:NoF)';  % N*J
cP = datamat_o*W'; % T*N

% Run OLS on PC to obtain maximum likelihood estimates of K0P, K1P (concentrated
% out) and initial values for Sigma_cP (6 params)
[K1PplusI, K0P_cP, Sigma_cP] = regressVAR(cP);
K1P_cP = K1PplusI - eye(NoF);
L = chol(Sigma_cP, 'lower');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Part 2: Random generation to improve starting point
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% STARTING POINT FOR K1Q_X (lamQ) (3 params)
% Generate some random seeds so we don't waste time searching with very weird parameters.
rng(1234589);
nSeeds = 5000;  % Number of random starting points.  We want to avoid really bad starting values.
% mlam = .95;   % most negative eigenvalue is greater than -mlam
bestllk = inf; 
for n=1:nSeeds
    % To be sure the eigenvalues are ordered, we parameterize the difference in eigenvalues, dlamQ.
    dlamQ(1,1) = -abs(.01*randn);  % When this is positive we'll have Q-non-stationary model
    dlamQ(2:NoF,1) = -diff(sort([dlamQ(1); rand(NoF-1,1)]));
    llk_fun = @(dlamQ, cholSigma_cP) llk_fun0(datamat_o, W, dlamQ, cholSigma_cP, maturity, dt);
    llk = llk_fun(dlamQ, L(find(tril(ones(NoF))))); %#ok<FNDSB>
    if llk<bestllk
        fprintf('seed %5.5g\n',n), fprintf(' Improved seed llk to %5.5g\n',llk)
        bestllk = llk; dlamQ0 = dlamQ;
    end
end
K1Q_X = diag(cumsum(dlamQ0));

% STARTING POINT FOR kinfQ (1 param)
kinfQ=-K1Q_X(1,1)*mean(datamat_o(:,end));

% STARTING POINT FOR SIGMAy (7 params) (9 params for updateddata)
% COMPUTE THE JSZ-Normalized version of the model:
% yt = AcP' + BcP'*cPt, AcP is 1*J, BcP is N*J
[BcP, AcP, ~, ~, ~, ~, ~, ~, ~, ~, ~] = ...
    jszLoadings(W, K1Q_X, kinfQ, Sigma_cP, maturity, dt);
yields_m =  ones(rows(datamat_o),1)*AcP + cP*BcP; % (T+1)*J, model-implied yields
yield_errors = datamat_o(2:end,:) - yields_m(2:end,:); % T*J
square_orthogonal_yield_errors = (yield_errors).^2; % T*J, but N-dimensional projection onto W is always 0, so effectively (J-N) dimensional
% Compute optimal sigma_e if it is not supplied
% sigma_e = sqrt( sum(square_orthogonal_yield_errors(:))/(rows(datamat_o)*(cols(datamat_o)-NoF)) );
sigma_e = diag(sqrt(mean(square_orthogonal_yield_errors))); % J*J
 
% Optimization
% Assign initial point matrices to vector to teta
teta_=[];
teta_(1:3)=diag(K1Q_X);
teta_(4)=kinfQ;
teta_(5)=L(1,1);
teta_(6)=L(2,1);teta_(7)=L(2,2);
teta_(8)=L(3,1);teta_(9)=L(3,2);teta_(10)=L(3,3);
teta_(11:11+N-1)=diag(sigma_e);
teta_=teta_';
nparam=rows(teta_);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Part 3: Optimization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%optimization
%         SIMS rotine: works better, but has random numbers 
[f,teta,~,~,~,~,~] = csminwel('jszLLK_KF_a',teta_,0.001*eye(nparam),...
                     [],crit,1000,datamat_o,  W, maturity, dt, K0P_cP, K1P_cP,cP);
 
% keyboard
% sd at likelihood
if computehessianJSZ==1;
    hessian = hessi('jszLLK_KF_a',teta,1,datamat_o,  W, maturity, dt,...
                    K0P_cP, K1P_cP,cP);             
    [u,s,~] = svd(hessian);
    fac= u*sqrt(s); 
    fac= fac*fac';
    standarderrors=1./sqrt(diag(fac)); 
else
standarderrors=NaN;
end
