% code used with permission from Joslin Singleton and Zhu (2011)
% Title of publication in reference - A New Perspective on Gaussian
%                                   Dynamic Term Structure Models
% Authors - Scott Joslin MIT Sloan
%         - Kenneth J Singleton Standford GSB
%         - Haoxiang Zhu Stanford GSB
% Date of publication - 2011
% Journal - Reviwe of Financial Studies 24, pg 926-970
% DOI - 10.1093/rfs/hhq128

function [x00 alpha Phi Q P00  b A R] = ...
    ss_JSZ(teta_,  W, mats, dt, K0P_cP, K1P_cP, cP)
global Model T nlags N BOLS 

% INPUTS:
% teta_      : np*1      vector of structural parameters
% yields_o   : T*J,      matrix of observed yields (first row are t=0 observations, which likelihood conditions on)
% mats       : 1*J,      maturities in years
% dt         : scalar,   length of period in years
% W          : N*J,      vector of portfolio weights
% K0P_cP     : N*1,      conditional mean of PC (concentrated out)
% K1P_cP     : N*N,      transition matrix of PC (concentrated out)

% intermediate output:
% K1Q_X      : N*N,      normalized latent-model matrix (does not have to be diagonal, see form below)
% kinfQ      : scalar,   when the model is stationary, the long run mean of the annualized short rate under Q is -kinfQ/K1(m1,m1) 
% Sigma_cP   : N*N,      positive definite matrix that is the covariance of innovations to cP
% sigma_e    : scalar,   standard error of yield observation errors
% AcP        : 1*J       yt = AcP' + BcP'*cPt  (yt is J*1 vector)
% BcP        : N*J       AcP, BcP satisfy internal consistency condition that AcP*W' = 0, BcP*W' = I_N

% output is the state space reprentation ready to go in the filter.

% initial checks 
global hessfun;
if hessfun==0;
    if teta_(2)>teta_(1) ||  teta_(3)>teta_(2) 
        x00=999; 'incorrect order'; alpha=999; Phi=999; Q=999; P00=999; A=999; b=999; R=999;
    return; 
    end
end;

% Setup pointers
% [tt,J] = size(yields_o);
tt = T-nlags; 
J=N;
Nw = size(W,1);

% load parameters into matrices
K1Q_X=diag(teta_(1:3)); 
% if use_rinf==1;
% kinfQ=-K1Q_X(1,1)*rinfQ;
% else
kinfQ=teta_(4);
% end
Sigma_cPchol=[[teta_(5) 0 0]; [teta_(6) teta_(7) 0]; [teta_(8) teta_(9) teta_(10)]];
Sigma_cP=Sigma_cPchol*Sigma_cPchol';
sigma_e=diag(teta_(11:11+J-1));

if Model~=11;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% COMPUTE THE JSZ-Normalized version of the model to get BcP and AcP
% yt = AcP' + BcP'*cPt, AcP is 1*J, BcP is N*J
[BcP,AcP,~,~,~,~,~,~,~,~,~] = jszLoadings(W,K1Q_X,kinfQ,Sigma_cP,mats,dt);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
else
% % % datamat_star=yields_o;
% % % W_ = pcacov(cov(datamat_star));
% % % W_ = W_(:,1:3)';  % N*J
% % % cP_ = datamat_star*W_'; % T*N
% % cP_=cP; % equal to the global
% % BOLS=[ones(tt,1) cP_]\datamat_star;
AcP=BOLS(1,:);
BcP=BOLS(2:4,:);  
end    
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Now setup Kalman filter.
% y = yields_o;  % T*J
Phi = eye(Nw) + K1P_cP; % N*N
alpha = K0P_cP; % N*1
Q = Sigma_cP;  % N*N
R = eye(J)*sigma_e.^2;

% Assume that the t=0 states (the time before any yields are observed)
% are distributed N(mu, Sigma) with the model stationary distribution,
[x00, P00] = asymptoticMomentsGaussian(K0P_cP, K1P_cP, Sigma_cP);
A = BcP.';
b = AcP.';

% If K1P_cP is non-stationary, we will have a problem with this assumption,
% so use something else assuming LLK will let us evaluate the likelihood
%  keyboard;

% if BcP==99999; R=99999; return; end; 

if any(any(isnan(P00))) || any(any(isinf(P00))) 
    x00 = mean(cP).';
    P00 = cov(cP);
    return;
end;  

eigP00 = eig(P00);
if any(~isreal(eigP00)) || any(eigP00<0)
    x00 = mean(cP).';
    P00 = cov(cP);
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


