% code used with permission from Joslin Singleton and Zhu (2011)
% Title of publication in reference - A New Perspective on Gaussian
%                                   Dynamic Term Structure Models
% Authors - Scott Joslin MIT Sloan
%         - Kenneth J Singleton Standford GSB
%         - Haoxiang Zhu Stanford GSB
% Date of publication - 2011
% Journal - Reviwe of Financial Studies 24, pg 926-970
% DOI - 10.1093/rfs/hhq128

function [llk, yields_filtered, cP_filtered] = ...
    jszLLK_KF_a(teta_,yields_o,  W, mats, dt, K0P_cP, K1P_cP, cP)


N=cols(yields_o);

%%ensure stationarity %%avoid jumps
if max(teta_(1:3))>0 || teta_(2)>teta_(1) ||  teta_(3)>teta_(2) || ...
        teta_(4)<0  ||    min((teta_(11:11+N-1)))<0;    

    llk=1e+6; yields_filtered=0; cP_filtered=0; 
    return; 
end

%%avoid jumps
%if min(teta_(11:11+N-1))<0; llk=1e+6; yields_filtered=0; cP_filtered=0; return; end 
%%the line above is key to get good psrf as it avoids flipping sign of
%%sigmas (f(-sigma)=f(sigma) might cause algorithm jumping from these two
%%values compromising convergence)

%%create SS
[x00 alpha Phi Q P00  b A R] = ...
    ss_JSZ(teta_,  W, mats, dt, K0P_cP, K1P_cP, cP);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Run Kalman Filter:
[~, ~, x_tt, ~, ~, llk] = kf(yields_o.', Phi, alpha, A, b, Q, R, x00, P00);
% llk = -mean(llk); % we return negative of the llk
llk = -sum(llk); % we return negative of the llk
cP_filtered = x_tt.';     % T*N  E[cPt|y^o(t), y^o(t-1), .., y^o(1)]
BcP = A.'; AcP = b.'; T= rows(yields_o);
yields_filtered = cP_filtered*BcP + ones(T,1)*AcP; % T*J
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

