% code used with permission from Joslin Singleton and Zhu (2011)
% Title of publication in reference - A New Perspective on Gaussian
%                                   Dynamic Term Structure Models
% Authors - Scott Joslin MIT Sloan
%         - Kenneth J Singleton Standford GSB
%         - Haoxiang Zhu Stanford GSB
% Date of publication - 2011
% Journal - Reviwe of Financial Studies 24, pg 926-970
% DOI - 10.1093/rfs/hhq128

function [Minf, Vinf] = asymptoticMomentsGaussian(K0Pd, K1Pd, H0d)
% function [Minf, Vinf] = asymptoticMomentsGaussian(K0Pd, K1Pd, H0d)
%
%   X(t+1) - X(t) = K0Pd + K1Pd*X(t) + eps(t+1),  cov(eps(t)) = H0d
%
% Compute the stationary distribution of X is N(Minf,Vinf)
% (Assuming negative real parts of the eigenvalues of K1Pd)
%
% K0Pd : N*1
% K1Pd : N*N
% H0d  : N*N
% 
% Minf : N*1
% Vinf : N*N

N = length(K0Pd);

Minf = - K1Pd\K0Pd;
A = K1Pd + eye(N);
% vec(A*B*C) = kron(C'*A)*vec(B)
% Vinf = A*Vinf*A' + H0d
Vinf = reshape( (eye(N^2) - kron(A, A))\H0d(:),[N,N]);