********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 6 after reading in estimates created by other estimation program

dis %dateandtime()
dis %ratsversion()

*env noshowgraphs
*gsave(format=pdf) "Figure7.pdf"

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp ndraws = 5000                     ;* # of draws used

comp styr = 1983
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2013:3      ;* last data observation (will use same data sample as for other models)

comp nvar = 67	;* number of variables in the VAR
comp nus = 26   ;* number of U.S. variables in the model (variables 1 through nus in order)
comp nfact = 2  ;* number of common volatility factors in the model
comp nfactx = 1 ;* only the first factor is in the VAR's conditional mean

comp fixlags = 2	;* fixed lag order to use in VAR
comp flags = 2      ;* AR order of log factor process, corresponding to length of lags included in VAR's conditional mean

all endsmpl
smpl stsmpl endsmpl

*********************
********************* READING IN DATA and determining available sample
*********************
dec vec[ser] y(nvar) yraw(nvar)
dec vec[str] varlabel(nvar+nfact)
do i = 1,nfact
 comp varlabel(nvar+i) = "log uncertainty factor " + %string(i)
end do i

open data data/GCPdata.xlsx

data(format=xlsx,org=col,sheet="US") / REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2 $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
comp n = 0
dofor i =  REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "US " + %l(i)
end do i

clear REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI

data(format=xlsx,org=col,sheet="EA") / REAL_GDP REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS	REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP	ULC	TOTAL_EMPLOYMENT	UNEMPLOYMENT_RATE	SHORT_TERM_RATE	BOND_YIELD_2Y $
  BOND_YIELD_10Y	$
  M3		$
  GDP_DEFLATOR	CONSUMER_PRICES	CONSUMER_PRICES_EXCL_ENERGY_FOOD	PPI	REAL_HOUSING_INVESTMENT	$
  STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	INDUSTRIAL_CONFIDENCE	PMI	LABOR_SHORTAGES
dofor i = REAL_GDP REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS	REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP		ULC	TOTAL_EMPLOYMENT	UNEMPLOYMENT_RATE	SHORT_TERM_RATE	BOND_YIELD_2Y $
  BOND_YIELD_10Y	$
  M3		$
  GDP_DEFLATOR	CONSUMER_PRICES	CONSUMER_PRICES_EXCL_ENERGY_FOOD	PPI	REAL_HOUSING_INVESTMENT	$
  STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	INDUSTRIAL_CONFIDENCE	PMI	LABOR_SHORTAGES
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "EA " + %l(i)
end do i
close

open data data/UK_Haver.xlsx

data(format=xlsx,org=col,sheet="quarterly") / gdp	consumption	gov	investment	export	import	ulc	industrial_confidence
dofor i =  gdp	consumption	gov	investment	export	import	ulc	industrial_confidence
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "UK " + %l(i)
end do i

data(format=xlsx,org=col,sheet="monthly") / consumer_confidence employment	unemployment_rate ppi rpi policy_rate bondyield10y stockprice
dofor i = consumer_confidence employment	unemployment_rate ppi rpi policy_rate bondyield10y stockprice
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "UK " + %l(i)
end do i
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=yraw(i)) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) yraw(i)
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

*** data transformations
comp [vec[int]] transvec = ||5,5,5,5,5,5,1,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,1,5,5,1,1,5||
if %rows(transvec)<>nvar
 dis "mismatch of nvar and rows of transvec; nvar, rows = " nvar transvec
endif

*** set up data vector
smpl basestsmpl endsmpl
do i = 1,nvar
 if transvec(i)==1
  set y(i) = yraw(i){0}
 else if transvec(i)==2
  diff yraw(i) basestsmpl+1 endsmpl y(i)
 else if transvec(i)==3
  diff(diffs=2) yraw(i)  basestsmpl+2 endsmpl y(i)
 else if transvec(i)==4
  set y(i) = 100.*log(yraw(i){0})
 else if transvec(i)==5
  set y(i) basestsmpl+1 endsmpl = 100.*log(yraw(i){0}/yraw(i){1})
 else if transvec(i)==6
  {
   set tempser = 100.*log(yraw(i){0})
   diff(diffs=2) tempser  basestsmpl+2 endsmpl y(i)
  }
end do i

** now adjust basestsmpl to reflect differencing
comp basestsmpl = basestsmpl+1

******************************** define sample and standardize data
********************************
********************************
comp basestsmpl = basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp [vec] keepscales = %fill(nvar,1,1.0)
do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
 comp keepscales(i) = %variance^0.5
end do i

comp [vec[str]] varlabel = ||"U.S. real GDP",$
"U.S. real consumption",$
"U.S. real government consumption",$
"U.S. real investment",$
"U.S. real exports",$
"U.S. real imports",$
"U.S. real inventories",$
"U.S. unit labor costs",$
"U.S. employment",$
"U.S. hours worked",$
"U.S. unemployment rate",$
"U.S. federal funds rate",$
"U.S. 2-year bond yield",$
"U.S. 10-year bond yield",$
"U.S. M2",$
"oil price",$
"commodity prices",$
"U.S. consumer prices",$
"U.S. core consumer prices",$
"U.S. producer prices",$
"U.S. real housing investment",$
"U.S. stock price index",$
"U.S. capacity utilization",$
"U.S. consumer confidence",$
"U.S. industrial confidence",$
"U.S. purchasing managers' index",$
"E.A. real GDP",$
"E.A. real consumption",$
"E.A. real government consumption",$
"E.A. real investment",$
"E.A. real exports",$
"E.A. real imports",$
"E.A. real inventories",$
"E.A. unit labor costs",$
"E.A. employment",$
"E.A. unemployment rate",$
"E.A. Eonia rate",$
"E.A. 2-year bond yield",$
"E.A. 10-year bond yield",$
"E.A. M3",$
"E.A. GDP deflator",$
"E.A. consumer prices",$
"E.A. core consumer prices",$
"E.A. producer prices",$
"E.A. real housing investment",$
"E.A. stock price index",$
"E.A. capacity utilization",$
"E.A. consumer confidence",$
"E.A. industrial confidence",$
"E.A. purchasing managers' index",$
"E.A. labor shortages",$
"U.K. real GDP",$
"U.K. real consumption",$
"U.K. real government consumption",$
"U.K. real investment",$
"U.K. real exports",$
"U.K. real imports",$
"U.K. unit labor costs",$
"U.K. industrial confidence",$
"U.K. consumer confidence",$
"U.K. employment",$
"U.K. unemployment rate",$
"U.K. producer prices",$
"U.K. retail price index",$
"U.K. official bank rate",$
"U.K. 10-year bond yield",$
"U.K. stock price index",$
"international uncertainty factor",$
"2nd international uncertainty factor"||

/*
do i = 1,%rows(varlabel)
 dis i @5 varlabel(i)
end do i
*/

********************* now set period of decomposition
comp decstpt = 1998:1  ;* 1990:1  ;* 1987:1 ;* 2003:1
comp decendpt = endsmpl

********************************
******************************** reading in contribution estimates (these are medians)
********************************
comp totvar = nvar+nfact

** comp0: baseline forecast
** comp1: direct contrib of uncertainty shock
** comp2: direct contrib of VAR's shocks

dec vec[ser] comp0_50(totvar) comp1_50(totvar) comp2_50(totvar)

do i = 1,totvar
 label comp0_50(i)
 # "comp0_"+i
 label comp1_50(i)
 # "comp1_"+i
 label comp2_50(i)
 # "comp2_"+i
end do i

comp filename = "estimatesforfigures/estimatesforFigure7.xlsx"
open data &filename
data(for=xlsx,org=col) / comp0_50(1) to comp0_50(totvar) comp1_50(1) to comp1_50(totvar) comp2_50(1) to comp2_50(totvar)
close data

inquire(series=comp0_50(1)) decstpt2 decendpt2
dis %datelabel(decstpt2) %datelabel(decendpt2)

smpl decstpt decendpt

********************************
******************************** reading draws of params. and states from files
******************************** note: to reduce storage needs, rather than store draws of Sigma(t), we will reconstruct them from the draws of A and Lambda(t)
********************************
comp directory = "draws_3economies/"

**** dimensioning
dec rec[ser] factorRes(ndraws,nfact)

**** vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label factorRes(i,j)
  # "factor_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = directory+'factor.n'+i  
 comp filename = thisroot+'.csv'
 open data &filename
 data(org=row,for=cdf) basestsmpl endsmpl factorRes(1,i) to factorRes(ndraws,i)
 close data
end do i

**** construct median estimate of (log) uncertainty for use in charts
dec vec[ser] actuallogfactors(nfact)
clear(length=endsmpl) actuallogfactors

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nfact
   set statser = log(factorRes(t,i)(vtime))
   comp [vec] frac = %fractiles(statser,||.5||)
   comp actuallogfactors(i)(vtime) = frac(1)
  end do i
end do vtime

******************************** charts with SUBSET OF VARIABLES
******************************** create STACKED BAR charts, using medians of contribution estimates
********************************

*** variable numbers for variables to be included in charts
comp [vec[int]] incldummy = ||1,2,4,12,18,21,22,27,30,37,42,45,46,52,53,55,64,65,67,68||
comp nvarx = %rows(incldummy)
dis nvarx

************* chart settings
comp perpage = 20
comp vf = 4
comp hf = 5

comp [vec[str]] keylab = ||"data","VAR shocks","m shocks"||

comp nline = 3
dec vect[int] symbols(nline)
comp symbols = ||1,4,5||

smpl decstpt decendpt

grparm(bold) header 44
grparm axislabeling 46
grparm keylabeling 12
/*
grparm(bold) header 36
grparm axislabeling 36
grparm keylabeling 10
*/
do i = 1,nvarx,perpage
 spgraph(vfields=vf,hfields=hf,klab=keylab,key=below,style=stackedbar,nopatterns,symbols=symbols) ;*
 do j = 1,perpage  
  comp jj = incldummy((i-1)+j)
  if jj<=nvar
   set actualseries = y(jj){0}
  else
   set actualseries = actuallogfactors(jj-nvar){0}
  comp header1 = varlabel(jj)
  *
  set series1 = comp1_50(jj){0}
  set series2 = comp2_50(jj){0}   ;* -comp1_50(jj){0}

  extremum(noprint) actualseries
  comp vmin = %minimum
  comp vmax = %maximum
  set checkser = series1+series2
  extremum(noprint) checkser
  comp vmin = %min(%minimum,vmin)-0.25
  comp vmax = %max(%maximum,vmax)+0.25

  graph(dates,style=line,overlay=stackedbar,ovcount=(nline-1),ovsame,symbols=symbols,header=header1) nline  ;* ,max=vmax,min=vmin
  # actualseries / 1
  # series2
  # series1

 end do j
 spgraph(done)
end do i
