********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 4 after reading in estimates created by other estimation program

comp nvar = 19	;* number of variables in the VAR
comp nfact = 1  ;* # of factors
comp totvar = nvar+nfact

comp freq = 4
comp nsteps = 4*freq

all nsteps
smpl 1 nsteps

grparm(bold) header 38
grparm axislabeling 40

env nowshowgraphs
gsave(format=pdf) "Figure4.pdf"

*********************
********************* READING IN IRs
********************* 
dec rec[ser] IR(totvar,3) IR_avgBVARSV(totvar,3)

comp filename1 = "estimatesforfigures/estimatesforFigure4.xlsx"

open data &filename1
data(format=xlsx,org=col) / 
close
do i = 1,totvar
 set IR(i,1) = %s("SIMIRMEDIAN"+%string(i)){0}
 set IR(i,2) = %s("SIMIR15"+%string(i)){0}
 set IR(i,3) = %s("SIMIR85"+%string(i)){0}
end do i
comp basesize = %s("SIMIRMEDIAN"+%string(totvar))(1)

comp [vec[str]] varlabel = ||"U.S.",$
"Australia",$	
"Austria",$ 	
"Belgium",$	 	
"Canada",$		
"Denmark",$		
"Finland",$		
"France",$		
"Germany",$		
"Italy",$		
"Japan",$		
"Luxembourg",$	
"Netherlands",$
"Norway",$		
"Portugal",$	
"Spain",$		
"Sweden",$		
"Switzerland",$
"U.K.",$
"International uncertainty factor"|| 

comp IRperpage = 20
comp vf = 4
comp hf = 5

********************************
******************************** charts:  
********************************

** just GFSV with confidence bands
do i = 1,totvar,IRperpage
 spgraph(vfields=vf,hfields=hf) ;* 
 do j = i,%imin(i+IRperpage-1,totvar)
  comp header1 = varlabel(j)
  graph(ticks,number=0,ovcount=2,overlay=fan,ovsame,header=header1) 3
  # IR(j,1) / 1
  # IR(j,2) / 8
  # IR(j,3) / 8
 end do j
 spgraph(done)
end do i
