********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* estimating BVAR-SV model with quarterly data for the U.S.
********************* 

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp skipint = 5                      ;* save only every kth draw of MCMC (out of skipint*ndraws)
comp ndraws = 5000                    ;* # of draws retained
comp burnindraws = 5000               ;* # of draws burned

/*
comp ndraws = 200                     ;* # of draws retained
comp burnindraws = 50                ;* # of draws burned
comp skipint = 1                      ;* save only every 20th draw of MCMC (out of skipint*ndraws)
*/

comp styr = 1983
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2013:3      ;* last data observation (will use same data sample as for other models)

comp nvar = 26	;* number of variables in the VAR
comp fixlags = 2	;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

comp seedval = 3000
seed seedval
dis seedval

grparm(bold) header 14 subheader 12
grparm axislabeling 24
env nowshowgraphs
comp modeldesc = "BVAR-SV model, U.S. data only, N=26"
gsave(format=pdf) "BVARSV_USonly_*.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
dec vec[ser] y(nvar) yraw(nvar)
dec vec[str] varlabel(nvar)

open data data/GCPdata.xlsx

data(format=xlsx,org=col,sheet="US") / REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2 $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
comp n = 0
dofor i =  REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "US " + %l(i)
end do i

close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=yraw(i)) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) yraw(i)
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

*** data transformations
comp [vec[int]] transvec = ||5,5,5,5,5,5,1,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1||
if %rows(transvec)<>nvar
 dis "mismatch of nvar and rows of transvec; nvar, rows = " nvar transvec
endif

*** set up data vector
smpl basestsmpl endsmpl
do i = 1,nvar
 if transvec(i)==1
  set y(i) = yraw(i){0}
 else if transvec(i)==2
  diff yraw(i) basestsmpl+1 endsmpl y(i)
 else if transvec(i)==3
  diff(diffs=2) yraw(i)  basestsmpl+2 endsmpl y(i)
 else if transvec(i)==4
  set y(i) = 100.*log(yraw(i){0})
 else if transvec(i)==5
  set y(i) basestsmpl+1 endsmpl = 100.*log(yraw(i){0}/yraw(i){1})
 else if transvec(i)==6
  {
   set tempser = 100.*log(yraw(i){0})
   diff(diffs=2) tempser  basestsmpl+2 endsmpl y(i)
  }
end do i

** now adjust basestsmpl to reflect differencing
comp basestsmpl = basestsmpl+1

********************************
******************************** stuff for estimation
********************************
sou(noecho) procedures/BVARBE.SV.src

******** prior means of first lag of dep variable in each equation (basic intention is to push VAR towards AR(1) models with coef of 0)
comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* default prior mean is 0.0
ewise bvarprior(i) = %if(transvec(i)==4.,1.,0.)
comp [vec] shrinkage = ||.1,0.5,1.,1000.|| ;* overall tightness, relative weight on other lags, decay on lag, intercept hyperparm.

dec vec dpriormean(nvar)
dec vec[symm] dpriorvar(nvar)
do i = 1,nvar
 comp dpriormean(i) = 0.95   ;* prior mean on slope of st vol process; prior mean set within procedure based on this slope and period 0 mean
 comp dpriorvar(i) = ||2.| 0.0, 0.3^2.||
end do i

********* mean and variance of Phi, var-cov matrix of innovations to log stochastic volatility
dec symm muPhi(nvar,nvar)
comp muPhi = %mscalar(.03)
dec symm Omegalambda0(nvar,nvar)
comp Omegalambda0 = %mscalar(2.)
comp priordfPhi = nvar+2 

** now adjust muPhi to get the intended prior mean 
comp adjustment = (priordfPhi-nvar-1.)/priordfPhi
comp muphi = adjustment*muphi 

******************************** define sample and
******************************** set initial values needed
******************************** and then standardize data
comp basestsmpl = basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
end do i

comp [vec] lnlambdainp = %zeros(nvar,1)
dec vec[ser] Aresids(nvar)
do i = 1,nvar
  linreg(noprint) y(i) / Aresids(i)
  # constant y(i){1 to fixlags}
  sstats(mean) / Aresids(i){0}**2.>>lnlambdainp(i)
  comp lnlambdainp(i) = log(lnlambdainp(i))
end do i

********************************
******************************** model estimation
********************************

smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp starttime = %cputime()
@BVARBESV(prmean,lnlambdainp=lnlambdainp,noinclconst) y basestsmpl endsmpl 0 fixlags ndraws burnindraws skipint bvarprior shrinkage Omegalambda0 muPhi $
 priordfPhi dpriormean dpriorvar 0 PiRes ARes PhiRes SigmaRes LambdaRes stdevRes svcoefRes ForecastRes volinnovations meanresids normresids

dis 'run time in minutes = ' (%cputime()-starttime)/60.

********************************
******************************** volatility, calculating posterior stats
********************************
dec vec[ser] rfvolmedian(nvar) rfvol15(nvar) rfvol85(nvar) loglambda(nvar)
clear(length=endsmpl) rfvolmedian rfvol15 rfvol85 loglambda

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nvar
    set(scratch) statser = stdevRes(t,i)(vtime)
    stats(noprint,fractiles) statser
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp rfvolmedian(i)(vtime) = %median
    comp rfvol15(i)(vtime) = frac(1)
    comp rfvol85(i)(vtime) = frac(3)
    *
    set(scratch) statser = log(lambdaRes(t,i)(vtime))
    stats(noprint,fractiles) statser
    comp loglambda(i)(vtime) = %median
  end do i
end do vtime

**** now write to Excel files
comp filename = %unitfnroot("input")+".xls"
open copy &filename
copy(dates,org=col,for=xls) basestsmpl endsmpl loglambda rfvolmedian rfvol15 rfvol85
close copy

********************************
******************************** charts
********************************
comp perpage = 16
comp vf = 4
comp hf = 4

comp [vec[string]] mykey_full = ||'median','15%ile','85%ile'||
smpl basestsmpl endsmpl

******************************** reduced-form volatilities
comp header1 = 'Innovation volatility estimate: ' + modeldesc
comp subheader = '(standard deviation)'
do i = 1,nvar,perpage
 grparm(bold) header 14 
 spgraph(vfields=vf,hfields=hf,header=header1,subheader=subheader)
 grparm(bold) header 22
 do j = i,%imin(i+perpage-1,nvar)
  comp header = varlabel(j)
  graph(header=header,dates,key=below,klab=mykey_full) 3
  # rfvolmedian(j) / 1
  # rfvol15(j) / 2
  # rfvol85(j) / 2
 end do j
 spgraph(done)
end do i
