********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* reading in BVAR-SV estimates of volatility from BVAR-SV models estimated separately for the US, UK, and EA
********************* and conducting PC analysis
********************* 

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp npc = 5
comp totvar = 67
comp nus = 26
comp nuk = 16
comp nea = totvar-nus-nuk

comp styr = 1980
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2013:3

all endsmpl
smpl stsmpl endsmpl

grparm(bold) header 14 subheader 12
grparm axislabeling 24
env noshowgraphs
gsave(format=pdf) "BVARSVPCanalysis_3economies_*.pdf"

*********************
********************* READING IN vol estimates and determining available sample
*********************

dec vec[ser] volest(totvar) stvolest(totvar)

comp filename = "out/BVARSV_USonly.xls"
open data &filename
data(format=xls,org=col,skiplines=1,nolabels) / volest(1) to volest(nus)
close data
comp filename = "out/BVARSV_EAonly.xls"
open data &filename
data(format=xls,org=col,skiplines=1,nolabels) / volest(nus+1) to volest(nus+nea)
close data
comp filename = "out/BVARSV_UKonly.xls"
open data &filename
data(format=xls,org=col,skiplines=1,nolabels) / volest(nus+nea+1) to volest(totvar)
close data

comp basestsmpl = stsmpl
dofor i = 1 nus+1 totvar
 inquire(series=volest(i)) stpt *
 comp basestsmpl = %imax(basestsmpl,stpt)
end do i
dis %datelabel(basestsmpl) %datelabel(endsmpl)
smpl basestsmpl endsmpl

******************************** set up
dec vec[ser] factors(npc) 
comp stpt = basestsmpl
comp endpt = endsmpl
smpl stpt endpt

*** standardize data
do i = 1,totvar
 diff(standardize) volest(i) / stvolest(i)
end do i

******************************* full sample factor analysis, all variables together
*** form data matrix
make datamat
# stvolest
dis %rows(datamat) %cols(datamat)

*** compute eigen values and factors
if %rows(datamat)<%cols(datamat)
 {
  comp xx = %outerxx(datamat)
  eigen xx eigvals eigenvec
  comp eigenvec = eigenvec*(sqrt(float(%rows(xx))))
  do i = 1,npc
   set factors(i) stpt endpt = eigenvec(t-stpt+1,i)
  end do i
 }
else
 {
  comp xx = %innerxx(datamat)
  eigen xx eigvals eigenvec
  do i = 1,npc
   comp [vec] princoef=%xcol(eigenvec,i)*(1./sqrt(float(%rows(xx))))
   comp [vec] factorvec = datamat*princoef
   set factors(i) stpt endpt = factorvec(t-stpt+1)
  end do i
 }
endif

*** check and flip signs as need be to make correlations with first variable positive
do i = 1,npc
 set gapseries = abs(factors(i){0}-stvolest(1))
 set gapseries2 = abs(-1.*factors(i){0}-stvolest(1))
 if %sum(gapseries2)<%sum(gapseries)
  set factors(i) = -1.*factors(i){0}
end do i

*** compute and show incremental R2's and Ahn-Horenstein eigen value ratio
do i = 1,npc
 if i==1
  dis ""
 dis "share of PC and A-H measure " i @35 "= " #####.### eigvals(i)/%sum(eigvals) eigvals(i)/eigvals(i+1)
end do i 

*** run regressions to get R'2s for each variable, and loading coefficients
dec rec coefs(totvar,npc) rsquares(totvar,npc)
do i = 1,totvar
 do j = 1,npc
  linreg(noprint) stvolest(i)
  # factors(j)
  comp coefs(i,j) = %beta(1)
  comp rsquares(i,j) = %rsquared
 end do j
end do i 

*** dis loadings on 1st two factors
do i = 1,totvar
 if i==1
  dis ""
 dis "1st three factor loadings for var " i @40 "= " ###.### coefs(i,1) coefs(i,2)
end do i 

*** tabulate percentiles of R-square distributions
do j = 1,npc
 set statser 1 totvar = rsquares(t,j)
 stats(fractiles,noprint) statser 1 totvar
 dis "PC " j @14 "mean, median, 25%, 75% =   " ####.### %mean %median %fract25 %fract75
end do j

******************************* charts
comp header = "Principal components from all data, U.S., U.K., and E.A."
graph(dates,header=header,key=below) 2
# factors(1)
# factors(2)
