function CombinedD = my_weighted_Distance_matrix(DistanceMatrix1, DistanceMatrix2, WGT, IndexM, NoGroups);
% Compute weighted average of scalled distance matrices
%
% Proceed recursively by adding the rows of the distance matrix associated
% with a certain group

CombinedD = DistanceMatrix1*0;
for gg=1:NoGroups
    CombinedD = CombinedD + diag(IndexM(:,gg))*(WGT(gg)*DistanceMatrix1+(1-WGT(gg))*DistanceMatrix2);
end;