function [hndls, fig_hndl]=my_make_IRF(HH, varargin)
% my_make_IRF(HH,Data1, Data2, ..., DataN, 'DoAreaPlot', True/False)

if nargin<=2
    error('Need to provide both the horizon and some data');
end;
if nargin==2
    if ~isnumeric(varargin{2})
        error('Need to provide both the horizon and some data');
    else
        DoAreaPlot=false;
    end;
else
    
    NoDataPoints=min([find(cellfun(@isstr,varargin)), length(varargin)+1]-1);
    if NoDataPoints<length(varargin)
        if ~isempty(find(strcmp('DoOverLap',varargin)))
            DoOverLap=varargin{find(strcmp('DoOverLap',varargin))+1};
        else
            DoOverLap=0;
        end;
        if ~isempty(find(strcmp('DoStretched',varargin)))
            DoStretched=varargin{find(strcmp('DoStretched',varargin))+1};
        else
            DoStretched=false;
        end;
        if ~isempty(find(strcmp('DoAreaPlot',varargin)))
            DoAreaPlot=varargin{find(strcmp('DoAreaPlot',varargin))+1};
        else
            DoAreaPlot=false;
        end;
        if ~isempty(find(strcmp('XLabel',varargin)))
            MyXLabel=varargin{find(strcmp('XLabel',varargin))+1};
        else
            MyXLabel='';
        end;
        if ~isempty(find(strcmp('YLabel',varargin)))
            MyYLabel=varargin{find(strcmp('YLabel',varargin))+1};
        else
            MyYLabel='';
        end;
        if ~isempty(find(strcmp('FontSize',varargin)))
            MyFontSize=varargin{find(strcmp('FontSize',varargin))+1};
        else
            MyFontSize=18;
        end;

    end;
    
end;

if DoOverLap>0
    fig_hndl=figure(DoOverLap);
else
    fig_hndl=figure;
end;
if DoStretched
    subplot(2,1,1);
end;
if numel(HH)==1
    XCoordinates=0:HH;
else
	XCoordinates=HH(:)';
end;
if DoAreaPlot
    X=[XCoordinates,fliplr(XCoordinates)];

    switch size(varargin{1},2)
        case 5
            hndl5=fill(X,[varargin{1}(:,1)', fliplr(varargin{1}(:,5)')],[1 1 1]*0.7,'LineStyle','none');              
            hold all;
            hndl16=fill(X,[varargin{1}(:,2)', fliplr(varargin{1}(:,4)')],[1 1 1]*0.5,'LineStyle','none');              
            hndl50=plot(XCoordinates, varargin{1}(:,3), '-k','LineWidth',3);
            hndls=[hndl5(:); hndl16(:); hndl50];
        case 3
            hndl16=fill(X,[varargin{1}(:,1)', fliplr(varargin{1}(:,3)')],[1 1 1]*0.5,'LineStyle','none');              
            hold all;
            hndl50=plot(XCoordinates, varargin{1}(:,2), '-k','LineWidth',3);
            hndls=[hndl16(:); hndl50];
        case 1
            hndl50=plot(XCoordinates, varargin{1}(:,1), '-k','LineWidth',3);
            hold all;
            hndls=hndl50;
        otherwise
            error('Data must be median only, or median and one or two sets of CI');
    end;
else
    hndls=[];
end;

% Add line plots on top
for nn=(DoAreaPlot+1):NoDataPoints

    switch size(varargin{nn},2)
        case 5
            hndl5=plot(XCoordinates, varargin{nn}(:,[1 5]), '--r','LineWidth',2);
            hold all;
            hndl16=plot(XCoordinates, varargin{nn}(:,[2 4]), '--r','LineWidth',2);
            hndl50=plot(XCoordinates, varargin{nn}(:,3), '--r','LineWidth',3);
            hndls=[hndls(:); hndl5(:); hndl16(:); hndl50];
        case 3
            hndl16=plot(XCoordinates, varargin{nn}(:,[1 3]), '--r','LineWidth',2);
            hold all;
            hndl50=plot(XCoordinates, varargin{nn}(:,2), '--r','LineWidth',2);
            hndls=[hndls(:); hndl16(:); hndl50];
        case 1
            hndl50=plot(XCoordinates, varargin{nn}(:,1), '--r','LineWidth',3);
            hold all;
            hndls=[hndls(:); hndl50];
        otherwise
            error('Data must be median only, or median and one or two sets of CI');
    end;
end;

xlabel(MyXLabel);
ylabel(MyYLabel);
set(findall(gcf,'type','axes'),'fontsize',MyFontSize);
set(findall(gcf,'type','text'),'fontSize',MyFontSize);    
grid on;