set(groot,'defaultLegendAutoUpdate','off');

DO_NARROW=0;
% DO_NARROW=1;
PlotNames  = [VarNames(1:p); PerNames(:)];
PlotLabels = [VarLabels(1:p); PerLabels(:)];
PlotScale= [VarScale(1:p), PerScale(1:pp)];

close all;
for gg=1:NoGroups
    for ci_idx=1:(1+(DO_NARROW==1)*2)
        if ci_idx==1
            CI_lvls=[5 16 50 84 95];
            AddSuffix='_wide';
        else
            CI_lvls=[16 50 84];
            AddSuffix='';
        end
        for p_idx=1:p+pp
            for pz_idx=1:pv1

                if PlotScale(p_idx)==1
                    DisplayUnit='p.p.';
                else
                    DisplayUnit='%';
                end

                YData=prctile(squeeze(IRF_pooled_b{1,gg}(p_idx,pz_idx,1:h+1,:))', CI_lvls);
                hndl=my_make_IRF(h,YData','DoAreaPlot', true, 'YLabel',DisplayUnit,'XLabel','years after shock');
                if length(CI_lvls)==5
                    legend(hndl(1:3), {[num2str(CI_lvls(1), '%1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                        [num2str(CI_lvls(2), '%1.0f') '% / ' num2str(CI_lvls(4), '%1.0f') '%'] ; ...
                            'median'},'Location','Best');
                else
                    legend(hndl(1:2), {[num2str(CI_lvls(1), '%1.0f') '% / ' num2str(CI_lvls(3), '%1.0f') '%']; ...
                        'median'},'Location','Best');
                end
                title('');
                plot([0 h], [0 0], '-k');

                pause(1/2);
                print('-depsc', ['../Graphs/IRF_' PlotNames{p_idx} '-' PlotNames{pz_idx} Suffix num2str(gg,'_%1.0f') AddSuffix '.eps']);
                title([PlotLabels{p_idx} ' to ' ShockLabels{pz_idx} ' shock - group ' num2str(gg,'%1.0f')], 'FontSize', 20);

                close(gcf)
                if any(strmatch('vlog_emp_pop',PlotNames)==p_idx)
                    pop_idx=strmatch('dlog_pop',PlotNames);
                    YData=prctile(squeeze(IRF_pooled_b{1,gg}(p_idx,pz_idx,1:h+1,:)+cumsum(IRF_pooled_b{1,gg}(pop_idx,pz_idx,1:h+1,:),3))', CI_lvls);
                    hndl=my_make_IRF(h,YData','DoAreaPlot', true, 'YLabel',DisplayUnit,'XLabel','years after shock');
                    if length(CI_lvls)==5
                        legend(hndl(1:3), {[num2str(CI_lvls(1), '%1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                            [num2str(CI_lvls(2), '%1.0f') '% / ' num2str(CI_lvls(4), '%1.0f') '%'] ; ...
                                'median'},'Location','Best');
                    else
                        legend(hndl(1:2), {[num2str(CI_lvls(1), '%1.0f') '% / ' num2str(CI_lvls(3), '%1.0f') '%']; ...
                            'median'},'Location','Best');
                    end
                title('');
                    plot([0 h], [0 0], '-k');

                    pause(1/2);
                    print('-depsc', ['../Graphs/IRF_log_emp_lvl-' PlotNames{pz_idx} Suffix num2str(gg,'_%1.0f') AddSuffix '.eps']);
                    title(['Employment level to ' ShockLabels{pz_idx} ' shock - group ' num2str(gg,'%1.0f')], 'FontSize', 20);
                    close(gcf);


                end;
                
                if sum(strmatch('dlog_', PlotNames)==p_idx)
                    YData=prctile(squeeze(cumsum(IRF_pooled_b{1,gg}(p_idx,pz_idx,1:h+1,:),3))', CI_lvls);
                    hndl=my_make_IRF(h,YData','DoAreaPlot', true, 'YLabel',DisplayUnit,'XLabel','years after shock');
                    if length(CI_lvls)==5
                        legend(hndl(1:3), {[num2str(CI_lvls(1), '%1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                            [num2str(CI_lvls(2), '%1.0f') '% / ' num2str(CI_lvls(4), '%1.0f') '%'] ; ...
                                'median'},'Location','Best');
                    else
                        legend(hndl(1:2), {[num2str(CI_lvls(1), '%1.0f') '% / ' num2str(CI_lvls(3), '%1.0f') '%']; ...
                            'median'},'Location','Best');
                    end
                    plot([0 h], [0 0], '-k');
                title('');
                    pause(1/2);
                    print('-depsc', ['../Graphs/IRF_' PlotNames{p_idx} '_cum-' PlotNames{pz_idx} Suffix num2str(gg,'_%1.0f') AddSuffix '.eps']);
                    title([regexprep(PlotLabels{p_idx}, 'growth', 'level') ' to ' ShockLabels{pz_idx} ' shock - group ' num2str(gg,'%1.0f')], 'FontSize', 20);

                end
            end
        end
    end
end