* Does VS relate to our shock

clear all
cd ../Data

* Clean data
global WhichFile="_Identification" // baseline
//global WhichFile="_op" // TFP shocks as Bartik instrument
global DoMblock = 1

* Matlab shocks
* generated from my_Counterfactual.m
global Suffix=2
*global Prefix="Mean" // (instead of median otherwise)
global Prefix=""

* Adjust file name 
import excel using ${Prefix}ShockSeries_SPVAR_per_tmp_1986_2013_Org2_split_sm_wage_mig_pooled${WhichFile}_geo_mblck_cf${Suffix}.xlsx
global WhichFile="_Identification_mblock" 	

rename A fips 
rename B name
ds fips name, not

local ii=1985
foreach vv of varlist `r(varlist)' {
	local ii=`ii'+1
	rename `vv' shock`ii'
} 


replace name=subinstr(name, " Metropolitan Statistical Area", "", .)
ge shortname=substr(name, 1, 7) + substr(name, -2,.)
replace shortname=subinstr(shortname, "-", ",", .)

save ShockData, replace

* VC data
clear
import excel using Venture-Investment-by-MSA-2015-1.xlsx, sheet("YoY MSA % Change") cellra(A6) firstrow 
rename MSA name 
ds name, not

local ii=2000
foreach vv of varlist `r(varlist)' {
	local ii=`ii'+1
	rename `vv' vc`ii'
} 

destring vc*, replace
* clean data
drop if strpos(name, ":")>0

ge shortname=substr(name, 1, 7) + substr(name, -2,.)
replace shortname=subinstr(shortname, "-", ",", .)
replace shortname="MemphisAR" if shortname=="MemphisMS" 
drop if shortname==""


merge 1:1 shortname using ShockData


* Reshape
keep if _merge==3
reshape long vc shock, i(fips) j(year)

* report summary statistics for referee -- note that this is for a subsample
sum shock,de

tsset fips year, y

ge transform=exp(vc)/(1+exp(vc))

preserve
qui xi: reg transform i.fips
predict tr_msa_fe, xb
qui xi: reg transform i.year
predict tr_year_fe, xb
corr tr*

replace vc=vc*100
qui xi: reg vc i.fips
predict msa_fe, xb
qui xi: reg vc i.year
predict year_fe, xb
corr msa_fe vc
local r2=round(r(rho)^2, 0.01)
global msa_r2="MSA FE R-squared=`r2'" 
corr year_fe vc
local r2=round(r(rho)^2, 0.01)
global year_r2="Year FE R-squared=`r2'" 

collapse (p5) p5_vc=vc p5_transform=transform (p25) p25_vc=vc p25_transform=transform (p50) p50_vc=vc p50_transform=transform (p75) p75_vc=vc p75_transform=transform (p95) p95_vc=vc p95_transform=transform , by(year)
tsset year, y
tsline p*vc if p50_vc~=., lcolor(maroon maroon black maroon maroon) lwidth(1.5 1 1.5 1 1.5 ) lpattern(dot dash solid dash dot) ///
		graphregion(color(white)) bgcolor(white)  legend(off) ytitle("%", size(large)) ylabel(, labsize(large)) xtitle("") xlabel(, labsize(large)) ///
		title("$msa_r2 $year_r2")
graph export ../Graphs/MSA_VC_RegionalVar${Prefix}${Suffix}.eps, replace mag(200)
restore

rreg shock transform, genwt(rregwgt)
sum rregwgt,de
ge constant=1

reghdfe shock vc l.vc, absorb(fips year) vce(cluster fips year)
estimates store both_fe_unwgt_raw
estadd local Transform="No"
estadd local FixedEffects="Yes"
estadd local Weights="No"

reghdfe shock vc l.vc [aweight=rregwgt], absorb(fips year) vce(cluster fips year)
estimates store both_fe_wgt_raw
estadd local Transform="No"
estadd local FixedEffects="Yes"
estadd local Weights="Yes"

reghdfe shock transform l.transform , absorb(fips year) vce(cluster fips year)
estimates store both_fe_unwgt
estadd local Transform="Yes"
estadd local FixedEffects="Yes"
estadd local Weights="No"

reghdfe shock transform , absorb(fips year) vce(cluster fips year)
estimates store lag_fe_unwgt
estadd local Transform="Yes"
estadd local FixedEffects="Yes"
estadd local Weights="No"

reghdfe shock transform , absorb(constant) vce(cluster fips year)
estimates store lag_unwgt
estadd local Transform="Yes"
estadd local FixedEffects="No"
estadd local Weights="No"

reghdfe shock transform l.transform [aweight=rregwgt], absorb(fips year) vce(cluster fips year)
estimates store both_fe_wgt
estadd local Transform="Yes"
estadd local FixedEffects="Yes"
estadd local Weights="Yes"

reghdfe shock transform [aweight=rregwgt], absorb(fips year) vce(cluster fips year)
estimates store lag_fe_wgt
estadd local Transform="Yes"
estadd local FixedEffects="Yes"
estadd local Weights="Yes"

reghdfe shock transform [aweight=rregwgt], absorb(constant) vce(cluster fips year)
estimates store lag_wgt
estadd local Transform="Yes"
estadd local FixedEffects="No"
estadd local Weights="Yes"

//
estout both_fe_unwgt_raw both_fe_unwgt lag_fe_unwgt lag_unwgt both_fe_wgt_raw both_fe_wgt lag_fe_wgt lag_wgt , replace   ///
	starlevels(* 0.10 ** 0.05 *** 0.01) cells(b(fmt(3) star ) t(fmt(2) par)  ) stats(N N_clust1 N_clust2 Transform FixedEffects Weights,  ///
	fmt(0 0 0 0 0) label("Observations" "MSAs" "Years" "Transformation" "Fixed effects" "Weights")) mlabels("(1) " "(2) " "(3) " "(4) " "(5) " "(6) " "(7) " "(8) ") ///
	posthead(\hline) prefoot(\hline) collabels(none) label rename(vc transform L.vc L.transform _cons Constant) ///
	varlabel(vc "VC growth" L.vc "Lagged VC growth" L.transform  "Lagged VC growth" transform "VC growth" )
	
estout both_fe_unwgt_raw both_fe_unwgt lag_fe_unwgt lag_unwgt both_fe_wgt_raw both_fe_wgt lag_fe_wgt lag_wgt using ///
	../Tables/VS_Shocks${WhichFile}${Prefix}${Suffix}.tex, replace style(tex) ///
	starlevels(* 0.10 ** 0.05 *** 0.01) cells(b(fmt(3) star ) t(fmt(2) par)  ) stats(N N_clust1 N_clust2 Transform FixedEffects Weights,  ///
	fmt(0 0 0 0 0) label("Observations" "MSAs" "Years" "Transformation" "Fixed effects" "Weights")) mlabels("(1) " "(2) " "(3) " "(4) " "(5) " "(6) " "(7) " "(8) ") ///
	posthead(\hline) prefoot(\hline) collabels(none) label rename(vc transform L.vc L.transform _cons Constant) ///
	varlabel(vc "VC growth" L.vc "Lagged VC growth" L.transform  "Lagged VC growth" transform "VC growth" )
	
ge MA = (vc + l.vc )/2 if vc~=. & l.vc~=. 
ge TransformMA = (transform+ l.transform)/2 if vc~=. & l.vc~=. 
ge ShockMA = (shock + l.shock )/2 if shock ~=. & l.shock ~=. 


	

* Read Philly Inquirer data
do ../Code/GeneTherapy.do

rreg shock  vc if fips==37980, ge(PHL_WT)
reg shock  vc [w=PHL_WT]  if fips==37980, robust

twoway (scatter shock vc [w=PHL_WT] if fips==37980 & PHL_WT~=. , msymbol(T)  mlabel(year) mlabsize(large)) ///
	(scatter shock vc if fips==37980 & vc~=. & PHL_WT==., msymbol(O)  mlabel(year) mlabsize(large)) , graphregion(color(white)) bgcolor(white) ///
	legend(ring(0) bplace(6) label(1 "weighted")  label(2 "excluded")) ytitle("startup shock (st.devs.)", size(large)) xtitle("growth of VC funded firms (%)", size(large)) ///
	xlabel(, labsize(large))  ylabel(, labsize(large)) 
graph export ../Data/PHL_VC_shocks${WhichFile}${Prefix}${Suffix}.eps, replace mag(200)
	
	
ge MAgene = gene + L.gene
corr ShockMA MAgene if fips==37980 & MAgene~=0
reg ShockMA MAgene if fips==37980 & MAgene~=0, robust
twoway (scatter ShockMA MAgene if fips==37980 & MAgene~=0, msymbol(T) mlabel(year) mlabsize(large)) , graphregion(color(white)) bgcolor(white) ///
	legend(ring(0) bplace(6) label(1 "weighted")  label(2 "excluded")) ytitle("startup shock (m.avg., st.devs.)", size(large)) xtitle("#gene therapy funded firms (m.avg., number)", size(large)) ///
	xlabel(, labsize(large))  ylabel(, labsize(large)) 
graph export ../Data/PHL_gene_shocks${WhichFile}${Prefix}${Suffix}.eps, replace mag(200)

tobit ShockMA MAgene if fips==37980 & year>=1988, ll(0) vce(robust)
tobit ShockMA MAgene if fips==37980 & year>=1989, ll(0) vce(robust)

expand 2, gen(expanded)
replace rregwgt=1 if expanded

reghdfe shock transform [aweight=rregwgt] if expanded, absorb(constant) vce(cluster fips year)
local p_unweigthed=round(2 * ttail(e(N_clust), abs(_b[transform]/_se[transform])), 0.001)
reghdfe shock transform [aweight=rregwgt] if ~expanded, absorb(constant) vce(cluster fips year)
local p_weigthed=round(2 * ttail(e(N_clust), abs(_b[transform]/_se[transform])), 0.001)
binscatter shock transform [aweight=rregwgt], by(expanded) xtitle("growth in VC (logit transform)", size(large)) msymbol(D T) legend(ring(0) bplace(4) label(1 "weighted (p=`p_weigthed')") label(2 "unweighted (p=`p_unweigthed')")) ytitle("startup shock (st.dev)", size(large)) /// 
	graphregion(color(white)) bgcolor(white) reportreg xlabel(, labsize(large)) ylabel(, labsize(large)) 
	
graph export ../Graphs/VC_shocks${WhichFile}${Prefix}${Suffix}.eps, replace mag(200)

reghdfe shock vc [aweight=rregwgt] if expanded, absorb(constant) vce(cluster fips year)
local p_unweigthed=round(2 * ttail(e(N_clust), abs(_b[vc]/_se[vc])), 0.001)
reghdfe shock vc [aweight=rregwgt] if ~expanded, absorb(constant) vce(cluster fips year)
local p_weigthed=round(2 * ttail(e(N_clust), abs(_b[vc]/_se[vc])), 0.001)
binscatter shock vc [aweight=rregwgt], by(expanded) xtitle("growth in VC ", size(large)) msymbol(D T) legend(ring(0) bplace(4) label(1 "weighted (p=`p_weigthed')") label(2 "unweighted (p=`p_unweigthed')")) ytitle("startup shock (st.dev)", size(large)) /// 
	graphregion(color(white)) bgcolor(white) reportreg xlabel(, labsize(large)) ylabel(, labsize(large)) 
	
graph export ../Graphs/VC_raw_shocks${WhichFile}${Prefix}${Suffix}.eps, replace mag(200)

