close all;

if ~exist('PlotNames', 'var')
    PlotNames  = [VarNames(1:p); PerNames(:)];
    PlotLabels = [VarLabels(1:p); PerLabels(:)];
    PlotScale= [VarScale(1:p), PerScale(1:pp)];
end

pz_idx=2;
for p_idx=1:p+pp
    for ci_idx=1:(1+(DO_NARROW==1)*2)
        if ci_idx==1
            CI_lvls=[5 16 50 84 95];
            AddPostFix='_wide';
        else
            CI_lvls=[16 50 84];
            AddPostFix='';
        end    
        if PlotScale(p_idx)==1
            DisplayUnit='p.p.';
        else
            DisplayUnit='%';
        end

        YData=prctile(squeeze(IRF_pooled_b{1}(p_idx,pz_idx,:,:)-IRF_alt_b{1}(p_idx,pz_idx,:,:) ), CI_lvls, 2);
        hndl_diff=my_make_IRF(h,YData,'DoAreaPlot', true, 'YLabel',DisplayUnit,'XLabel','years after shock');
        hold all;
        hndl_base   = plot(0:h, prctile(squeeze(IRF_pooled_b{1}(p_idx,pz_idx,:,:)), 50,2), '-r', 'LineWidth', 3);
        hndl_cf     = plot(0:h, prctile(squeeze(IRF_alt_b{1}(p_idx,pz_idx,:,:)), 50,2), '--k', 'LineWidth', 3);
%         legend({'indirect only (no direct effect of TFP on startups)';'baseline';'baseline-indirect only'}, 'location','best')
        if length(CI_lvls)==5
    %                 set(hndl, {'LineStyle'},{'-.';'--';'-';'--';'-.'},{'LineWidth'}, {2;2;3;2;2});
            legend([hndl_base, hndl_cf, hndl_diff(1:2)'], {'Baseline'; 'no direct startup effect';...
                [num2str(CI_lvls(1), 'Difference: %1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                [num2str(CI_lvls(2), 'Difference: %1.0f') '% / ' num2str(CI_lvls(4), '%1.0f') '%'] ; ...
                },'Location','Best','AutoUpdate','off')
            delete(hndl_diff(3));
        else
    %                 set(hndl, {'LineStyle'},{'--';'-';'--';},{'LineWidth'}, {2;3;2});
            legend([hndl_base, hndl_cf, hndl_diff(1)], {'Baseline'; 'no direct startup effect';...
                [num2str(CI_lvls(1), 'Difference: %1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                },'Location','Best','AutoUpdate','off')
            delete(hndl_diff(2));
        end
        if p_idx<=p
            set(gcf, 'Name', [VarLabels{p_idx} ' to ' ShockLabels{pz_idx} ' shock - group ' num2str(gg,'%1.0f')]);
        else
            set(gcf, 'Name', [PerLabels{p_idx-p} ' to ' ShockLabels{pz_idx} ' shock - group ' num2str(gg,'%1.0f')]);
        end
        plot(xlim, [0,0],'-k');
        
        print('-depsc', ['Graphs/CF_IRF_' PlotNames{p_idx} '-' PlotNames{pz_idx} PostFix num2str(gg,'_%1.0f') AddPostFix '.eps']);
        
    end
    if any(strmatch('vlog_emp_pop',PlotNames)==p_idx)
        pop_growth_indirect=cumsum(IRF_alt_b{1}(3,pz_idx,:,:),3);
        pop_growth_baseline=cumsum(IRF_pooled_b{1}(3,pz_idx,:,:),3);
        YData=prctile(squeeze(IRF_pooled_b{1}(p_idx,pz_idx,:,:)-IRF_alt_b{1}(p_idx,pz_idx,:,:) +pop_growth_baseline - pop_growth_indirect), CI_lvls, 2);
        
        hndl_diff=my_make_IRF(h,YData,'DoAreaPlot', true, 'YLabel',DisplayUnit,'XLabel','years after shock');
        set(gcf, 'Name', ['Employment level to ' ShockLabels{pz_idx} ' shock - group ' num2str(gg,'%1.0f')]);
        hold all;
        hndl_base   = plot(0:h, prctile(squeeze(IRF_pooled_b{1}(p_idx,pz_idx,:,:)+pop_growth_baseline), 50,2), '-r', 'LineWidth', 3);
        hndl_cf     = plot(0:h, prctile(squeeze(IRF_alt_b{1}(p_idx,pz_idx,:,:)+pop_growth_indirect), 50,2), '--k', 'LineWidth', 3);
%         legend({'indirect only (no direct effect of TFP on startups)';'baseline';'baseline-indirect only'}, 'location','best')
        if length(CI_lvls)==5
    %                 set(hndl, {'LineStyle'},{'-.';'--';'-';'--';'-.'},{'LineWidth'}, {2;2;3;2;2});
            legend([hndl_base, hndl_cf, hndl_diff(1:2)'], {'Baseline'; 'no direct startup effect';...
                [num2str(CI_lvls(1), 'Difference: %1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                [num2str(CI_lvls(2), 'Difference: %1.0f') '% / ' num2str(CI_lvls(4), '%1.0f') '%'] ; ...
                },'Location','Best','AutoUpdate','off')
            delete(hndl_diff(3));
        else
    %                 set(hndl, {'LineStyle'},{'--';'-';'--';},{'LineWidth'}, {2;3;2});
            legend([hndl_base, hndl_cf, hndl_diff(1)], {'Baseline'; 'no direct startup effect';...
                [num2str(CI_lvls(1), 'Difference: %1.0f') '% / ' num2str(CI_lvls(5), '%1.0f') '%']; ...
                },'Location','Best','AutoUpdate','off')
            delete(hndl_diff(2));
        end
        if p_idx<=p
            title([VarLabels{p_idx} ' to overall labor demand shock']);
        else
            title([PerLabels{p_idx-p} ' to overall labor demand shock']);
        end
        plot(xlim, [0,0],'-k');

        print('-depsc', ['Graphs/CF_IRF_' PlotNames{p_idx} '_cum-' PlotNames{pz_idx} PostFix num2str(gg,'_%1.0f') AddPostFix '.eps']);
    end
end
% ii=2;jj=2;
% close all;
% pop_growth_indirect=cumsum(IRF_alt_b{1}(3,jj,:,:),3);
% pop_growth_baseline=cumsum(IRF_pooled_b{1}(3,jj,:,:),3);
% plot(0:h, mean(squeeze(IRF_alt_b{1}(ii,jj,:,:)+(ii==2)*pop_growth_indirect),  2), '--k', 'LineWidth', 2);
% hold all;
% plot(0:h, mean(squeeze(IRF_pooled_b{1}(ii,jj,:,:)+(ii==2)*pop_growth_baseline),  2), '-r', 'LineWidth', 2);
% keks=plot(0:h, mean(squeeze(IRF_pooled_b{1}(ii,jj,:,:)-IRF_alt_b{1}(ii,jj,:,:) +(ii==2)*pop_growth_baseline - (ii==2)*pop_growth_indirect),  2), ':b');
% set(keks, {'LineWidth'}, {1;2;1});
% legend({'indirect only';'baseline';'baseline-indirect only'}, 'location','best')
% title(VarLabels{ii})