% create motivating scatter plot for intro

clear all;
close all;
% load ../Data/msa_data_jae.mat
load ../Data/VAR_DATA.mat

%%
MyFontSize=18;

[NUM,TXT,RAW]=xlsread('../data/bds_f_motivating_fact.xlsx');
for jj=1:length(TXT)
    assignin('caller', ['US_' TXT{jj}], NUM(:, jj));
end
[TT,NN]=size(vZit_age0_emp_msa);

plotData=100*prctile(vZit_age0_job_ctn_msa(:,:)./vpop, [5 25 50 75 95], 2);
MSA_year_FE=mean(vZit_age0_job_ctn_msa(:,:)./vpop, 2);
R2_year_FE = corr(reshape(MSA_year_FE*ones(1, NN), 1, [])', vZit_age0_job_ctn_msa(:)./vpop(:))^2;
MSA_msa_FE=mean(vZit_age0_job_ctn_msa(:,:)./vpop, 1);
R2_msa_FE = corr(reshape(ones(TT,1)*MSA_msa_FE, 1, [])', vZit_age0_job_ctn_msa(:)./vpop(:))^2;

figure;
hndl=plot(vYear, plotData, 'LineWidth', 3);
set(hndl, {'Color'}, {[0.5 0 0];[0.5 0 0];[0 0 0]; [0.5 0 0];[0.5 0 0]},{'LineStyle'}, {':';'--';'-';'--';':'});
axis([min(vYear) max(vYear) ylim]);
old_ylim=ylim;
ylabel('% of population');
grid on;
set(findall(gcf,'type','axes'),'fontsize',MyFontSize, 'fontweight', 'normal');
set(findall(gcf,'type','text'),'fontSize',MyFontSize, 'fontweight', 'normal');                
axis([min(vYear) max(vYear) old_ylim]);
print('-depsc', '../Graphs/Motivating_StartupJobs.eps');
close(gcf);

figure;
hndl_hist=histogram(100*mean(vZit_age0_job_ctn_msa(:,:)./vpop,1), 20, 'Normalization', 'probability');
hold all
US_all_mean=mean((US_job_creation-US_job_destruction)./(1000*US_pop))*100;
MSA_all_mean=mean(mean((vZit_ageall_job_ctn_msa-vZit_ageall_job_dtn_msa)./vpop,1)*100);
MSA_age0_mean=mean(mean(vZit_age0_job_ctn_msa(:,:)./vpop,1))*100;
US_age0_mean=mean(US_Job_Creation_age0./(1000*US_pop)*100);
hndl_all_US=plot([1, 1]*US_all_mean, ylim, '-', 'LineWidth', 3);
hndl_all=plot([1, 1]*MSA_all_mean, ylim, '--', 'LineWidth', 3);
set(hndl_all, 'Color', hndl_all_US.Color);
hndl_age0=plot([1, 1]*MSA_age0_mean, ylim, '--', 'LineWidth', 3);
hndl_age0_US=plot([1, 1]*US_age0_mean, ylim, '-', 'LineWidth', 3);
set(hndl_age0_US, 'Color', hndl_age0.Color);
set(findall(gcf,'type','axes'),'fontsize',MyFontSize, 'fontweight', 'normal');
set(findall(gcf,'type','text'),'fontSize',MyFontSize, 'fontweight', 'normal');                
legend([hndl_all_US, hndl_all, hndl_age0_US, hndl_age0], ...
                   {['All firms:' newline num2str(US_all_mean, 'U.S. mean=%1.2f%%')]; ...
                    ['All firms:' newline num2str(MSA_all_mean, 'MSA mean=%1.2f%%')]; ...
                    ['Startups:' newline num2str(US_age0_mean, 'U.S. mean=%1.2f%%')]; ...
                    ['Startups:' newline num2str(MSA_age0_mean, 'MSA mean=%1.2f%%')]}, ...
                    'location', 'northeast');
legend('boxoff');
xlabel('net job creation (% of population)');
ylabel('share of MSAs');
grid on;
axis([0 3 ylim]);

print('-depsc', '../Graphs/Motivating_Hist.eps');