
capture clear;

capture log close;


use "burgesspandeaerraw.dta", clear


# delimit;

*ALL VARIABLES WILL BE DEFLATED RELATIVE TO POPULATION IN 1961;





local population "pop1 pop2";
foreach v of local population {;
quietly ipolate `v' year, gen(`v'x) by(state) epolate;
replace `v'=`v'x if state==5 & year==1961;
drop `v'x ;
};
bys state: gen tpop61=(pop1+pop2) if year==1961;

egen pop61=max(tpop61), by (state);

drop tpop61;
replace pop61=pop61/100;


label variable pop61 "population in 1961";

*DEFLATORS AND INCOME VARIABLES;
sort state year;
quietly ipolate scpial1u year, gen(scpx) by(state) epolate;
replace scpial1u=scpx if year>1960 & state==7;
drop scpx;

gen deflate = (pop2/(pop1+pop2))*stcpiw1u+(pop1/(pop1+pop2))*scpial1u;
label variable deflate "deflator";
quietly ipolate nsdp year, gen(nsdpx) by(state);

replace nsdpx=. if year>1997;
replace nsdpx=. if year<1960;

gen stinc= (100*nsdpx)/((pop61)*deflate);
label variable stinc "real per capita net state domestic product";

gen lstinc = log(stinc);
label variable lstinc "log real per capita net state domestic product";
sort state year;
by state: gen tstinc61=lstinc if year==1961;

egen stinc61=max(tstinc61), by (state);
label variable stinc61 "log state income in 1961";
drop tstinc61;


*WAGE VARIABLES;

gen lrwagenew=log((nom_wage*100)/scpial1u);
label variable lrwagenew "log real agricultural wage";

gen lsalpw= log((zsalemp)/((zpertot)*deflate));
label variable lsalpw "log factory wage";
                                 
*POVERTY VARIABLES;

for X in any h1 h2: quietly ipolate X year, gen(Xx) by(state) \
replace X=Xx if year>1992 & X==.\ 
drop Xx;
label variable h1 "rural headcount ratio";

label variable h2 "urban headcount ratio";

gen head =  (pop2/(pop1+pop2))*h2+(pop1/(pop1+pop2))*h1;
label variable head "aggregate headcount ratio";

*POLITICAL VARIABLES;

* This generates the proportions of seats held by different groupings;

egen cona = rsum(inc incu ics);
label variable cona "Congress seats in state legislature";
gen pcona =cona/no_seat;
label variable pcona "proportion Congress seats in state legislature"; 
egen hdlft = rsum(cpi cpm);
label variable hdlft "hard left seats in state legislation";
gen phdlft =hdlft/no_seat;
label variable phdlft "proportion hard left seats in state legislation";
egen jan = rsum(jd jp lkdp);
label variable jan "Janata seats in state legislature";
gen pjan =jan/no_seat;
label variable pjan "proportion Janata seats in state legislature";
gen phind = (bjp)/no_seat;
label variable phind "proportion hindu party seats in state legislature";
egen reg = rsum(tdp agp jknc shs uc sad dmk r);
label variable reg "regional party seats in state legislature";
gen preg = reg/no_seat;
label variable preg "proportion regional party seats in state legislature";

*LAND REFORM VARIABLE: extrapolation for robustness;
quietly ipolate clr year, gen(clre) by(state) epolate;

label variable clre "cumulative land reform acts";

*TAX AND EXPENDITURE VARIABLES;

*interpolation;
sort state year;
for X in any eduexp hlthexp: quietly ipolate X year, gen(Xx) by(state)\

replace X=Xx if year==1995|year==1998\ 
drop Xx;
sort state year;

for X in any totexp devexp: quietly ipolate X year, gen(Xx) by(state)\

replace X=Xx if year==1998\ 
drop Xx;
sort state year;


for X in any totexp eduexp  hlthexp devexp:replace X =  (10000*X)/((pop61)*deflate);

gen hcapexp=eduexp+hlthexp;
gen odevexp=devexp-hcapexp;
gen hcapsh2=hcapexp/totexp;
gen odevsh2=odevexp/totexp;


label variable hcapexp "health/education spending";
label variable odevexp "other development spending";
label variable hcapsh2 "health/education spending share";
label variable odevsh2 "other development spending share";



sort state year;


for X in var radvall cbadvall rdepall cbdepall: quietly ipolate X year, gen(Xx) by(state)\

replace X=Xx if year==1970|year==1971|year==1972|year==1973|year==1994\ 
drop Xx;

gen rurcrsh=(radvall*100)/cbadvall;
label variable rurcrsh " rural credit share";
gen rursavsh=(rdepall*100)/cbdepall;
label variable rursavsh " rural savings share";

*CREDIT AND SAVING BANK VARIABLES;
*interpolate for 1989;
 sort state year;
for X in var itbtcred atbtcred: quietly ipolate X year, gen(Xx) by(state)\
replace X=Xx if year==1989\ 
drop Xx;

 
 by state: gen ragrbcr=(atbtcred)/(deflate*(pop61)*1000);
        label variable ragrbcr " real percapita agri. bank finance(total)";
 by state: gen rinbcr=(itbtcred)/(deflate*(pop61)*1000);
        label variable rinbcr " real percapita indy. bank finance(total)";
          by state: gen bankcr=(btcredit)/(deflate*(pop61)*1000);
        label variable bankcr "real percapita total bankcredit";   
    gen priorsh=(100*(ragrbcr+rinbcr))/bankcr;

 label variable priorsh "Priority sector lending share";   

*cooperative measures;

by state: gen rpacslo=(pacsloan)/(deflate*(pop61)*1000);
        label variable rpacslo " real percapita loans from primary agricultural cooperative society";
    
    


        
gen pcoopsh=(rpacslo*100)/(rpacslo+bankcr);

label variable pcoopsh " cooperative lending share";


for X in var town1 town2 town3 town4 town5 town6 vill4 vill5 vill6: replace X=. if  state==15 & year==1961;

*EPOLATE VILLAGE DATA;

for X in var vill vill1 vill2 vill3 vill4 vill5 vill6 vill7:  quietly ipolate X year, gen(ipX) by(state) epolate; 

*EPOLATE TOWN BY CLASS DATA;

for X in var town1 town2 town3 town4 town5 town6: ipolate X year, gen(ipX) by(state) epolate;

*LABEL EPOLATED DATA;

label variable iptown1 "extrapolation of town1"; label variable iptown2 "extrapolation

of town2"; label variable iptown3 "extrapolation of town3"; label variable iptown4 "extrapolation of town4"; label

variable iptown5 "extrapolation of town5"; label variable iptown6 "extrapolation of town6";

*towns and villages;

gen tovi1=iptown1;

gen tovi2=iptown2;

gen tovi3=iptown3;

gen tovi4=iptown4;

gen tovi5=(iptown5+ipvill6);

gen tovi6=(iptown6+ipvill5);

gen tovi7=ipvill7;

gen tovi8=ipvill6;

by state: gen tset=(iptown1+iptown2+iptown3+iptown4+tovi5+tovi6+ipvill4);

label variable tset "total census locations";

by state: gen rursh=log((iptown5+iptown6+ipvill5+ipvill6)/(pop61*10));

label variable rursh "log number of rural locations per capita";

*initial settlement distribution;

by state: gen ttovi61=rursh if year==1961;

egen rursh61=max(ttovi61), by (state);

label variable rursh61 "log number of rural locations per capita in 1961";

drop ttovi61;

by state: gen set61=(tset) if year==1961;

egen tset61=max(set61), by (state);

label variable tset61 "total census locations in 1961";

drop set61;

drop tovi* ip*;

by state: gen unbfor=unbank1/(pop61);
by state: gen runbfor=ruunb1/(pop61);

by state: gen bfor=bank1/(pop61);
by state: gen allfor=all1/(pop61);

label variable unbfor "cumulative bank branches opened in unbanked locations per capita";
label variable runbfor "cumulative bank branches opened in rural, unbanked locations per capita";
label variable bfor "cumulative bank branches opened in banked locations per capita";
label variable allfor "cumulative bank branches opened per capita";


by state: gen tub61=all1 if year==1961;


egen unbnk61=max(tub61), by (state);

label variable unbnk61 "bank branches in 1961";

drop tub61;


by state: gen tub61=bank1 if year==1961;

egen bnk61=max(tub61), by (state);

label variable bnk61 "bank branches in banked locations in 1961";

drop tub61;

by state: gen unb61=unbnk61/(pop61);
label variable unb61 "bank branches per capita in 1961";
drop if year < 1961;
cap drop yrdum* stdum* ;


quietly tab state, gen (stdum);

quietly tab year, gen (yrdum);

gen trend61=year-1960;

gen trend77=year-1976;

replace trend77=0 if year<1977;

gen trend90=year-1989;

replace trend90=0 if year<1990;

gen dum77=0;

replace dum77=1 if year>1976;

gen dum90=0;

replace dum90=1 if year>1989;

gen ubt61=unb61*trend61;

gen ubt77=unb61*trend77*dum77;
 
gen ubdum77=unb61*dum77; 

gen ubt90=unb61*trend90*dum90;

gen ubdum90=unb61*dum90; 


gen popt61=((pop61)/larea)*trend61;

gen popt77=((pop61)/larea)*trend77*dum77;

gen popd77=((pop61)/larea)*dum77;

gen popt90=((pop61)/larea)*trend90*dum90;


gen popdum90=((pop61)/larea)*dum90; 


gen stint61=stinc61*trend61;
gen stint77=stinc61*trend77;
gen stin77d=stinc61*dum77;
gen stint90=stinc61*trend90*dum90;
gen stindum90=stinc61*dum90; 


gen rursht61=rursh61*trend61;
gen rursht77=rursh61*trend77*dum77;
gen rurshd77=rursh61*dum77;
gen rursht90=rursh61*trend90*dum90;
gen rurshd90=rursh61*dum90; 



*yearwise dummies;
gen unbk61=unb61*yrdum1;

gen unbk62=unb61*yrdum2;

gen unbk63=unb61*yrdum3;

gen unbk64=unb61*yrdum4;

gen unbk65=unb61*yrdum5;

gen unbk66=unb61*yrdum6;

gen unbk67=unb61*yrdum7;

gen unbk68=unb61*yrdum8;

gen unbk69=unb61*yrdum9;

gen unbk70=unb61*yrdum10;

gen unbk71=unb61*yrdum11;

gen unbk72=unb61*yrdum12;

gen unbk73=unb61*yrdum13;

gen unbk74=unb61*yrdum14;

gen unbk75=unb61*yrdum15;

gen unbk76=unb61*yrdum16;

gen unbk77=unb61*yrdum17;

gen unbk78=unb61*yrdum18;

gen unbk79=unb61*yrdum19;

gen unbk80=unb61*yrdum20;

gen unbk81=unb61*yrdum21;

gen unbk82=unb61*yrdum22;

gen unbk83=unb61*yrdum23;

gen unbk84=unb61*yrdum24;

gen unbk85=unb61*yrdum25;

gen unbk86=unb61*yrdum26;

gen unbk87=unb61*yrdum27;

gen unbk88=unb61*yrdum28;

gen unbk89=unb61*yrdum29;

gen unbk90=unb61*yrdum30;

gen unbk91=unb61*yrdum31;

gen unbk92=unb61*yrdum32;

gen unbk93=unb61*yrdum33;

gen unbk94=unb61*yrdum34;

gen unbk95=unb61*yrdum35;

gen unbk96=unb61*yrdum36;

gen unbk97=unb61*yrdum37;

gen unbk98=unb61*yrdum38;

gen unbk99=unb61*yrdum39;

gen unbk00=unb61*yrdum40;


gen stin61=stinc61*yrdum1;

gen stin62=stinc61*yrdum2;

gen stin63=stinc61*yrdum3;

gen stin64=stinc61*yrdum4;

gen stin65=stinc61*yrdum5;

gen stin66=stinc61*yrdum6;

gen stin67=stinc61*yrdum7;

gen stin68=stinc61*yrdum8;

gen stin69=stinc61*yrdum9;

gen stin70=stinc61*yrdum10;

gen stin71=stinc61*yrdum11;

gen stin72=stinc61*yrdum12;

gen stin73=stinc61*yrdum13;

gen stin74=stinc61*yrdum14;

gen stin75=stinc61*yrdum15;

gen stin76=stinc61*yrdum16;

gen stin77=stinc61*yrdum17;

gen stin78=stinc61*yrdum18;

gen stin79=stinc61*yrdum19;

gen stin80=stinc61*yrdum20;

gen stin81=stinc61*yrdum21;

gen stin82=stinc61*yrdum22;

gen stin83=stinc61*yrdum23;

gen stin84=stinc61*yrdum24;

gen stin85=stinc61*yrdum25;

gen stin86=stinc61*yrdum26;

gen stin87=stinc61*yrdum27;

gen stin88=stinc61*yrdum28;

gen stin89=stinc61*yrdum29;

gen stin90=stinc61*yrdum30;

gen stin91=stinc61*yrdum31;

gen stin92=stinc61*yrdum32;

gen stin93=stinc61*yrdum33;

gen stin94=stinc61*yrdum34;

gen stin95=stinc61*yrdum35;

gen stin96=stinc61*yrdum36;

gen stin97=stinc61*yrdum37;

gen stin98=stinc61*yrdum38;

gen stin99=stinc61*yrdum39;

gen stin00=stinc61*yrdum40;


gen popn61=((pop61)/larea)*yrdum1;

gen popn62=((pop61)/larea)*yrdum2;

gen popn63=((pop61)/larea)*yrdum3;

gen popn64=((pop61)/larea)*yrdum4;

gen popn65=((pop61)/larea)*yrdum5;

gen popn66=((pop61)/larea)*yrdum6;

gen popn67=((pop61)/larea)*yrdum7;

gen popn68=((pop61)/larea)*yrdum8;

gen popn69=((pop61)/larea)*yrdum9;

gen popn70=((pop61)/larea)*yrdum10;

gen popn71=((pop61)/larea)*yrdum11;

gen popn72=((pop61)/larea)*yrdum12;

gen popn73=((pop61)/larea)*yrdum13;

gen popn74=((pop61)/larea)*yrdum14;

gen popn75=((pop61)/larea)*yrdum15;

gen popn76=((pop61)/larea)*yrdum16;

gen popn77=((pop61)/larea)*yrdum17;

gen popn78=((pop61)/larea)*yrdum18;

gen popn79=((pop61)/larea)*yrdum19;

gen popn80=((pop61)/larea)*yrdum20;

gen popn81=((pop61)/larea)*yrdum21;

gen popn82=((pop61)/larea)*yrdum22;

gen popn83=((pop61)/larea)*yrdum23;

gen popn84=((pop61)/larea)*yrdum24;

gen popn85=((pop61)/larea)*yrdum25;

gen popn86=((pop61)/larea)*yrdum26;

gen popn87=((pop61)/larea)*yrdum27;

gen popn88=((pop61)/larea)*yrdum28;

gen popn89=((pop61)/larea)*yrdum29;

gen popn90=((pop61)/larea)*yrdum30;

gen popn91=((pop61)/larea)*yrdum31;

gen popn92=((pop61)/larea)*yrdum32;

gen popn93=((pop61)/larea)*yrdum33;

gen popn94=((pop61)/larea)*yrdum34;

gen popn95=((pop61)/larea)*yrdum35;

gen popn96=((pop61)/larea)*yrdum36;

gen popn97=((pop61)/larea)*yrdum37;

gen popn98=((pop61)/larea)*yrdum38;

gen popn99=((pop61)/larea)*yrdum39;

gen popn00=((pop61)/larea)*yrdum40;

/**/
gen rshare61=rursh61*yrdum1;

gen rshare62=rursh61*yrdum2;

gen rshare63=rursh61*yrdum3;

gen rshare64=rursh61*yrdum4;

gen rshare65=rursh61*yrdum5;

gen rshare66=rursh61*yrdum6;

gen rshare67=rursh61*yrdum7;

gen rshare68=rursh61*yrdum8;

gen rshare69=rursh61*yrdum9;

gen rshare70=rursh61*yrdum10;

gen rshare71=rursh61*yrdum11;

gen rshare72=rursh61*yrdum12;

gen rshare73=rursh61*yrdum13;

gen rshare74=rursh61*yrdum14;

gen rshare75=rursh61*yrdum15;

gen rshare76=rursh61*yrdum16;

gen rshare77=rursh61*yrdum17;

gen rshare78=rursh61*yrdum18;

gen rshare79=rursh61*yrdum19;

gen rshare80=rursh61*yrdum20;

gen rshare81=rursh61*yrdum21;

gen rshare82=rursh61*yrdum22;

gen rshare83=rursh61*yrdum23;

gen rshare84=rursh61*yrdum24;

gen rshare85=rursh61*yrdum25;

gen rshare86=rursh61*yrdum26;

gen rshare87=rursh61*yrdum27;

gen rshare88=rursh61*yrdum28;

gen rshare89=rursh61*yrdum29;

gen rshare90=rursh61*yrdum30;

gen rshare91=rursh61*yrdum31;

gen rshare92=rursh61*yrdum32;

gen rshare93=rursh61*yrdum33;

gen rshare94=rursh61*yrdum34;

gen rshare95=rursh61*yrdum35;

gen rshare96=rursh61*yrdum36;

gen rshare97=rursh61*yrdum37;

gen rshare98=rursh61*yrdum38;

gen rshare99=rursh61*yrdum39;

gen rshare00=rursh61*yrdum40;

save "burgesspandeaerfinal.dta", replace;
