

*===========================================================================
*Table 1: Banking as a Function of Initial financial development
*===========================================================================

local table1outcomes "rurcrsh rursavsh bfor priorsh pcoopsh"

*Column 1: Branches in rural unbanked locations
*---------------------------------------------------------------------------
reg runbfor $main $controls stdum* yrdum*,cluster(state)

	test ubt61+ubtA=0
	local F1 = r(F) 
	local p1 = r(p) 
	*test ubt61+ubtA+ubtB+ubtC+ubtD+ubtE=0
	test ubt61 + $test  = 0
	
outreg2 using "table_1.tex", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
	
	
*Columns 2 & 3 - Rural bank: Rural bank Credit and Savings share
*& Column 4 - Branches in banked locations
*&& Columns 5 & 6 - Credit share: Priority sector and Cooperative
*---------------------------------------------------------------------------	
foreach v of local table1outcomes {
reg `v' $main $controls stdum* yrdum*, cluster(state)

	test ubt61+ubtA=0
	local F1 = r(F) 
	local p1 = r(p) 
	test ubt61 + $test = 0
	
outreg2 using "table_1.tex", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,`r(F)', P2,`r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons append 
}
