
clear all 
macro drop _all 

import excel "additionalcharacteristics.xlsx", sheet("STATA") firstrow
merge m:m state year using "burgesspandeaerfinal.dta"

* add labels: 
label variable infmor "State-wise infant mortality rate per newborn for 1961"
label variable litr "State-wise literacy rates for 1961 in population aged five years and above."
label variable prod "Crop production per farm worker"
label variable rwork "Percent laborers of rural farm workers"

*===========================================================================
*adjust data of additional characteristics 
replace infmor = infmor/1000
replace litr = litr/100
replace rwork =rwork/100
replace prod = prod

mvdecode  prod, mv(0)
mvdecode  infmor, mv(0)
mvdecode  litr, mv(0)
mvdecode  rwork, mv(0)
*===========================================================================
*Generate variables x62-x00 for figure 1. 

*"Crop production per farm worker"
gen prod61=prod*yrdum1
gen prod62=prod*yrdum2
gen prod63=prod*yrdum3
gen prod64=prod*yrdum4
gen prod65=prod*yrdum5
gen prod66=prod*yrdum6
gen prod67=prod*yrdum7
gen prod68=prod*yrdum8
gen prod69=prod*yrdum9
gen prod70=prod*yrdum10
gen prod71=prod*yrdum11
gen prod72=prod*yrdum12
gen prod73=prod*yrdum13
gen prod74=prod*yrdum14
gen prod75=prod*yrdum15
gen prod76=prod*yrdum16
gen prod77=prod*yrdum17
gen prod78=prod*yrdum18
gen prod79=prod*yrdum19
gen prod80=prod*yrdum20
gen prod81=prod*yrdum21
gen prod82=prod*yrdum22
gen prod83=prod*yrdum23
gen prod84=prod*yrdum24
gen prod85=prod*yrdum25
gen prod86=prod*yrdum26
gen prod87=prod*yrdum27
gen prod88=prod*yrdum28
gen prod89=prod*yrdum29
gen prod90=prod*yrdum30
gen prod91=prod*yrdum31
gen prod92=prod*yrdum32
gen prod93=prod*yrdum33
gen prod94=prod*yrdum34
gen prod95=prod*yrdum35
gen prod96=prod*yrdum36
gen prod97=prod*yrdum37
gen prod98=prod*yrdum38
gen prod99=prod*yrdum39
gen prod00=prod*yrdum40

*rwork "Percent laborers of rural farm workers"
gen rwork61=rwork*yrdum1
gen rwork62=rwork*yrdum2
gen rwork63=rwork*yrdum3
gen rwork64=rwork*yrdum4
gen rwork65=rwork*yrdum5
gen rwork66=rwork*yrdum6
gen rwork67=rwork*yrdum7
gen rwork68=rwork*yrdum8
gen rwork69=rwork*yrdum9
gen rwork70=rwork*yrdum10
gen rwork71=rwork*yrdum11
gen rwork72=rwork*yrdum12
gen rwork73=rwork*yrdum13
gen rwork74=rwork*yrdum14
gen rwork75=rwork*yrdum15
gen rwork76=rwork*yrdum16
gen rwork77=rwork*yrdum17
gen rwork78=rwork*yrdum18
gen rwork79=rwork*yrdum19
gen rwork80=rwork*yrdum20
gen rwork81=rwork*yrdum21
gen rwork82=rwork*yrdum22
gen rwork83=rwork*yrdum23
gen rwork84=rwork*yrdum24
gen rwork85=rwork*yrdum25
gen rwork86=rwork*yrdum26
gen rwork87=rwork*yrdum27
gen rwork88=rwork*yrdum28
gen rwork89=rwork*yrdum29
gen rwork90=rwork*yrdum30
gen rwork91=rwork*yrdum31
gen rwork92=rwork*yrdum32
gen rwork93=rwork*yrdum33
gen rwork94=rwork*yrdum34
gen rwork95=rwork*yrdum35
gen rwork96=rwork*yrdum36
gen rwork97=rwork*yrdum37
gen rwork98=rwork*yrdum38
gen rwork99=rwork*yrdum39
gen rwork00=rwork*yrdum40


*infmor "State-wise infant mortality rate for 1961"
gen infmor61=infmor*yrdum1
gen infmor62=infmor*yrdum2
gen infmor63=infmor*yrdum3
gen infmor64=infmor*yrdum4
gen infmor65=infmor*yrdum5
gen infmor66=infmor*yrdum6
gen infmor67=infmor*yrdum7
gen infmor68=infmor*yrdum8
gen infmor69=infmor*yrdum9
gen infmor70=infmor*yrdum10
gen infmor71=infmor*yrdum11
gen infmor72=infmor*yrdum12
gen infmor73=infmor*yrdum13
gen infmor74=infmor*yrdum14
gen infmor75=infmor*yrdum15
gen infmor76=infmor*yrdum16
gen infmor77=infmor*yrdum17
gen infmor78=infmor*yrdum18
gen infmor79=infmor*yrdum19
gen infmor80=infmor*yrdum20
gen infmor81=infmor*yrdum21
gen infmor82=infmor*yrdum22
gen infmor83=infmor*yrdum23
gen infmor84=infmor*yrdum24
gen infmor85=infmor*yrdum25
gen infmor86=infmor*yrdum26
gen infmor87=infmor*yrdum27
gen infmor88=infmor*yrdum28
gen infmor89=infmor*yrdum29
gen infmor90=infmor*yrdum30
gen infmor91=infmor*yrdum31
gen infmor92=infmor*yrdum32
gen infmor93=infmor*yrdum33
gen infmor94=infmor*yrdum34
gen infmor95=infmor*yrdum35
gen infmor96=infmor*yrdum36
gen infmor97=infmor*yrdum37
gen infmor98=infmor*yrdum38
gen infmor99=infmor*yrdum39
gen infmor00=infmor*yrdum40

*litr "State-wise literacy rates for 1961 in population aged five years and above."
gen litr61=litr*yrdum1
gen litr62=litr*yrdum2
gen litr63=litr*yrdum3
gen litr64=litr*yrdum4
gen litr65=litr*yrdum5
gen litr66=litr*yrdum6
gen litr67=litr*yrdum7
gen litr68=litr*yrdum8
gen litr69=litr*yrdum9
gen litr70=litr*yrdum10
gen litr71=litr*yrdum11
gen litr72=litr*yrdum12
gen litr73=litr*yrdum13
gen litr74=litr*yrdum14
gen litr75=litr*yrdum15
gen litr76=litr*yrdum16
gen litr77=litr*yrdum17
gen litr78=litr*yrdum18
gen litr79=litr*yrdum19
gen litr80=litr*yrdum20
gen litr81=litr*yrdum21
gen litr82=litr*yrdum22
gen litr83=litr*yrdum23
gen litr84=litr*yrdum24
gen litr85=litr*yrdum25
gen litr86=litr*yrdum26
gen litr87=litr*yrdum27
gen litr88=litr*yrdum28
gen litr89=litr*yrdum29
gen litr90=litr*yrdum30
gen litr91=litr*yrdum31
gen litr92=litr*yrdum32
gen litr93=litr*yrdum33
gen litr94=litr*yrdum34
gen litr95=litr*yrdum35
gen litr96=litr*yrdum36
gen litr97=litr*yrdum37
gen litr98=litr*yrdum38
gen litr99=litr*yrdum39
gen litr00=litr*yrdum40

*------------------------------------------------------------------------------


save "buliskeriabaxafinal.dta" 
*, replace
