
*==========================================================================
* Date : October 2021
* Author: Nino Buliskeria
* Paper: Do Rural Banks Matter That Much? Burgess and Pande (2005) Reconsidered
*			by Nino Buliskeria and Jaromir Baxa. 

* This code allows to replicates:
*		 Burgess, R., & Pande, R. (2005). 
*		"Do rural banks matter? 
*					evidence from the Indian social banking experiment."
*		American Economic Review, 95(3)
*
* This code also offers possibility to extend instrumental variables 
* excersise presented in Burgess and Pande (2005) by introducing additional 
* cut-years when summarizing the rural bank branch opening trend reversal. 
*
*------------------------------------------------------------------------------

clear all 
macro drop _all 

*------------------------------------------------------------------------------
*load data
*use "burgesspandeaerfinal.dta"
use "buliskeriabaxafinal.dta"

/*
*Additional Characteristics 
infmor "State-wise infant mortality rate for 1961"
litr "State-wise literacy rates for 1961 in population aged five years and above."
prod "Crop production per farm worker"
rwork "Percent laborers of rural farm workers"

var in 1961 * (T - 2000) trend = vart
var in 1961 * Post-T dummy = vard
*/


drop if year>2000

// The cut-years are named alphabethically, first being A, up to J. 
global manes A B C D E F G H I J	


												*___EDIT HERE: ____________________
												* Burgess and Pande (2005):
												   global years 77 90  
												 *txbreak: 68 74 79 84 89
												* Historic years:
												*	 global years 67 72 77 80 85 90 
												*__________________________________

*------------------------------------------------------------------------------	


*Generate Control Dummy Variables x*trend and x*dummy 

local num : word count $years
scalar n = `num'

forvalues i = 1(1)10{ 
local l`i' : word `i' of $manes
di "`l`i''"
}

forvalues i = 1(1)10{ 
local y`i' : word `i' of $years
di "`y`i''"
}

forvalues i = 1(1)`=n'{ 

gen trend`l`i''= year - (19`y`i''-1)
replace trend`l`i''=0 if year <19`y`i''

gen dum`l`i''=0
replace dum`l`i''=1 if year>(19`y`i''-1)

gen ubt`l`i''=unb61*trend`l`i''*dum`l`i''  			
gen ubdum`l`i''=unb61*dum`l`i''

gen popt`l`i''=((pop61)/larea)*trend`l`i''*dum`l`i''		
gen popd`l`i''=((pop61)/larea)*dum`l`i''

gen stint`l`i''=stinc61*trend`l`i''				
gen stind`l`i''=stinc61*dum`l`i''

gen rursht`l`i''=rursh61*trend`l`i''*dum`l`i''	
gen rurshd`l`i''=rursh61*dum`l`i''

gen infmort`l`i''=infmor*trend`l`i''*dum`l`i''
gen infmord`l`i''=infmor*dum`l`i''

gen litrt`l`i''=litr*trend`l`i''*dum`l`i''
gen litrd`l`i''=litr*dum`l`i''

gen prodt`l`i''=prod*trend`l`i''*dum`l`i''
gen prodd`l`i''=prod*dum`l`i'' 

gen rworkt`l`i''=rwork*trend`l`i''*dum`l`i''
gen rworkd`l`i''=rwork*dum`l`i''
}

*------------------------------------------------------------------------------
*Define Global Variables 
global In "popt61 rursht61 stint61"
global ubt61 "ubt61"

forvalues i = 1(1)`=n'{
global `l`i'' "popt`l`i'' popd`l`i'' rursht`l`i'' rurshd`l`i'' stint`l`i'' stind`l`i'' infmort`l`i'' infmord`l`i'' litrt`l`i'' litrd`l`i'' prodt`l`i'' prodd`l`i'' rworkt`l`i'' rworkd`l`i'' "
}

forvalues i = 1(1)`=n'{
global ubt`l`i''	"ubt`l`i''"
} 	 	 	 	 

forvalues i = 1(1)`=n'{
global ubdum`l`i''	"ubdum`l`i''"
} 	 	

*------------------------------------------------------------------------------
*Define Control Variables:

global controls $In $A $B $C $D $E $F $G $H $I $J
di "$controls"

global ubt $ubtA $ubtB $ubtC $ubtD $ubtE $ubtF $ubtG $ubtH $ubtI $ubtJ
global ubdum $ubdumA $ubdumB $ubdumC $ubdumD $ubdumE $ubdumF $ubdumG $ubdumH $ubdumI $ubdumJ								 	
global main $ubt61 $ubt $ubdum			
di "$main"			
			
global iv $ubt61 $ubdumA $ubdumB $ubdumC $ubdumD $ubdumE $ubdumF $ubdumG $ubdumH $ubdumI $ubdumJ
di "$iv"

*------------------------------------------------------------------------------

										*___EDIT HERE: _____________

										*Burgess and Pande (2005):
												global test "ubtA + ubtB" 					
										*Historic years:
										*		global test "ubtA + ubtB  + ubtC +	ubtD +	ubtE +	ubtF"
										*__________________________
		
*===========================================================================
						// STEP 2: Figrue 1	
*========

* generate the coefficients for the Figure 1
	drop if year>2000
*Figure 1: rural branches in unbanked locations (with controls)
	areg runbfor unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 infmor62-infmor00 litr62-litr00 prod62-prod00 rwork62-rwork00 stdum*, absorb(year) cluster(state)
*Start NB
	mata: b=st_matrix("e(b)")'
	getmata b, force
	gen temp=b[_n-1]
	replace b=temp
	replace b=. if _n==_N
	replace b = . if state > 1
	label variable b "rural branches in unbanked locations (with controls)"

*summarize these trend reversals by a linear trend break model:
	reg runbfor $main $controls stdum* yrdum*,cluster(state)
	mata: coef=st_matrix("e(b)")'
	getmata coef, force
	replace coef=. if _n> 2*n+1
	
	mkmat $main, matrix(X) 
	mkmat coef if coef < . , matrix(B) 
	matrix tr1 = X*B
	svmat tr1, names(trd)
			
	egen trend_m = mean(trd), by (year)
	gen mtrend = trend_m if state == 1
	gen trend = mtrend - mtrend[1]
		
	label variable trend "rural branches in unbanked locations (trend break)"
#delimit ;
line b trend year, 
legend(size(small) cols(1) symxsize(7)) 

lpattern(solid longdash_dot) 
lcolor(black black) 
graphregion(color(white)) 

xlabel(, labsize(small))
ylabel(, labsize(small) angle(horizontal)) 

xtitle("") 
ytitle("Initial financial development X year - coefficient {it}{&gamma}{subscript:t}", 
size(small));
#delimit cr


*===========================================================================
						//STEP 3: Regressions:
*======================

*For the regressions Burgess and Pande (2005) drop Haryana before 1965:
drop if state==5 & year<1965

*===========================================================================
*Table 1: Banking as a Function of Initial financial development

local table1outcomes "rurcrsh rursavsh bfor priorsh pcoopsh"

*---------------------------------------------------------
*Column 1: Branches in rural unbanked locations

reg runbfor $main $controls stdum* yrdum*,cluster(state)

	test ubt61+ubtA=0
	local F1 = r(F) 
	local p1 = r(p) 
	*test ubt61+ubtA+ubtB+ubtC+ubtD+ubtE=0
	test ubt61 + $test  = 0
	
outreg2 using "table_1.tex", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
	
*---------------------------------------------------------	
*Columns 2 & 3 - Rural bank: Rural bank Credit and Savings share
*& Column 4 - Branches in banked locations
*&& Columns 5 & 6 - Credit share: Priority sector and Cooperative
	
foreach v of local table1outcomes {
reg `v' $main $controls stdum* yrdum*, cluster(state)

	test ubt61+ubtA=0
	local F1 = r(F) 
	local p1 = r(p) 
	test ubt61 + $test = 0
	
outreg2 using "table_1.tex", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,`r(F)', P2,`r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons append 
}

*seeout using "table_1.txt"


*===========================================================================
*Table 2:  Bank Branch Expansion and Poverty: Reduced Form

local table2outcomes "h2 head lrwagenew lsalpw"

*---------------------------------------------------------
*Column 2 - Rural Headcount Ratio 

reg h1 $main $controls stdum* yrdum*, cluster(state)

	test ubt61+ubtA=0
	local F12 = r(F)
	local p12 = r(p)
	*test ubt61+ubtA+ubtB+ubtC+ubtD+ubtE=0
	test ubt61 + $test = 0
	
outreg2 using "table_2.tex", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F12', P1 , `p12', F-test 2,  `r(F)', P2, `r(p)')  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *)  nolabel nocons replace



*---------------------------------------------------------
*Columns 3 & 4 - Urban & Aggregate Headcount Ratio 
* & Columns 5 & 6 - Agricultural & Factory wages

foreach v of local table2outcomes {
 reg `v' $main $controls stdum* yrdum*, cluster(state)
 
	test ubt61+ubtA=0
	test ubt61+ubtA=0
	local F12 = r(F)
	local p12 = r(p)
	test ubt61 + $test = 0
	
outreg2 using "table_2.tex", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F12', P1 , `p12', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *)  nolabel nocons append
}


*seeout using "table_2.txt"


*===========================================================================
*Table3: BANK BRANCH EXPANSION AND POVERTY: INSTRUMENTAL VARIABLES EVIDENCE

														*___EDIT HERE: _________________
														*choose value for "Tr" - sample restriction for Table 3, column 7.
														*(after treatment period T - 1 )
														*Burgess and Pande (2005):
															scalar Tr = 1976 
														*Historic years:
														*	scalar Tr = 1966 
														*______________________________


local table3 "h1 h2 head lrwagenew lsalpw"
*------------------------------------------------------------------------------
*Column 1: OLS with one regressor: 
*Number branches opened in rural unbanked locations per capita

reg h1 runbfor stdum* yrdum*, cluster(state)
	
outreg2 using "table_3.tex", se keep(runbfor) coefastr  paren /// 
bdec(2) adjr2 symbol(***, **, *) nolabel nocons /// 
addtext(State and year dummies, YES, Other controls, YES) replace


*------------------------------------------------------------------------------
*Column 2: OLS with additional controls 

reg h1 runbfor $iv $controls stdum* yrdum*, cluster(state)
	
outreg2 using "table_3.tex", se  ///
keep(runbfor $iv)    ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append


*------------------------------------------------------------------------------
*Columns 3, 4, 5  - IV: Rural, Urban & Aggraget Headcount Ratio 
*& Columns 9, 10  - IV: Agricultural & Factory wages 

foreach v of local table3{
reg `v'  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*), cluster(state)

outreg2 using "table_3.tex", se ///
keep(runbfor $iv) ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append
 
capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
}


*------------------------------------------------------------------------------
*Columns 6, 7, 8 -- *restricted sample for h1 
*---------------------------------------------------------------------------
*column 6, earlier then 1990

reg h1 runbfor  $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*) if year<1990, cluster(state) 

outreg2 using "table_3.tex", se ///
keep(runbfor $iv)  ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) symbol(***, **, *) nolabel nocons append
*coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append
*------------------------------------------------------------------------------
*column 7, earlier then treatment year (BP05 1976)

*Tr set in file 0_master.do
reg h1 runbfor  $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*) if year>Tr, cluster(state) 

outreg2 using "table_3.tex", se ///
keep(runbfor $iv)  ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append


*------------------------------------------------------------------------------
*column 8, survey years

reg h1 runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*) if round~=.,cluster(state)

outreg2 using "table_3.tex", se /// 
keep(runbfor $iv) ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append 

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob

*seeout using "table_3.txt"

*===========================================================================
*Table4: RURAL CREDIT AND SAVINGS AND POVERTY: INSTRUMENTAL VARIABLES EVIDENCE

*Table 4: rural credit and savings=========================
local table4outcomes " h2 head "
*------------------------------------------------------------------------------
*Column 1
reg h1  rurcrsh $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  ///
keep(rurcrsh $iv)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) replace

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
*------------------------------------------------------------------------------
*Column 2
reg h1  rursavsh $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  ///
keep(rursavsh $iv)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)

*------------------------------------------------------------------------------
*Columns 3 and 5
disp sargan prob
foreach v of local table4outcomes {
reg `v'  rurcrsh $iv $controls stdum* yrdum* ///
($main  $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se  ///
keep(rurcrsh $iv)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob

*------------------------------------------------------------------------------
*Columns 4 and 6
reg `v' rursavsh $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_4.tex", se ///
keep(rursavsh $iv)  ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust   
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob

}

*seeout using "table_4.txt"


*===========================================================================
*Table5: BANK BRANCH EXPANSION AND POVERTY REDUCTION: ROBUSTNESS CHECKS

*Table 5: robustness
macro define policy 	"clre hcapsh2 odevsh2"
macro define politics 	"pcona pjan phdlft preg phind"
*------------------------------------------------------------------------------
*Column 1
reg h1  runbfor $policy  $iv  $controls stdum* yrdum* ///
($policy $main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  ///
keep(runbfor $policy)   ///
coefastr  paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) replace

*coefastr  paren bdec(2) symbol(***, **, *) nolabel nocons ///

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust 
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
*------------------------------------------------------------------------------
*Column 2
reg h1  runbfor $policy  $politics $iv  $controls stdum* yrdum* ///
($policy $politics $main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se     ///
keep(runbfor $policy $politics ) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust 
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
*------------------------------------------------------------------------------
*Column 3
reg h2  runbfor $policy  $iv $controls stdum* yrdum* ///
($policy $main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  ///
keep(runbfor $policy)   ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append
*coefastr paren bdec(2) symbol(***, **, *) nolabel nocons ///

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust   
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
*------------------------------------------------------------------------------
*Column 4
reg h2  runbfor $policy $politics $iv $controls stdum* yrdum* ///
($policy $politics $main $controls stdum* yrdum* ), cluster(state)

outreg2 using "table_5.tex", se  ///
keep(runbfor $policy $politics)  ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons ///
addtext(State and year dummies, YES, Other controls, YES) append

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust 
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
*seeout using "table_5.txt"

*==============================================================================		
