%__________________________________________________________________________
% STRUCTURAL VAR SIMULATION       
% This runs the alternative simulations shown in Online Supplement B.3
% for a value of m = 10
%__________________________________________________________________________ 
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir))

%__________________________________________________________________________
% SET PARAMETERS
%__________________________________________________________________________
% Control
  rDir      =  'Sim_Results_2\';                 % Results sub-directory 
  fnroot    =  [cDir rDir 'Sim_2_'];             % Results filename root
  
  M_.nsim   =  1000;                             % Nr of simulations
  M_.nd     =   200;                             % Nr of draws for indiv VAR
  M_.T      =   200;                             % Sample length
  M_.Nstar  =   10;                              % Nr of nonzero values of z (m) 
  M_.QNT    =   [0.10 0.16 .50 .84 .90];
     
% DGP VAR (see Online Supplement B.3)
  rho      =   0.90;
  g        =   0.20;
  a        =   pi/4;
  r        =   0.3;
  M_.A1    =   rho*[cos(g) sin(g); -sin(g) cos(g)];
  M_.B1    =   chol([1.0 r; r 1.0]) * [cos(a) sin(a); -sin(a) cos(a)];          
  M_.c0    =   [0;1];                                                          
  M_.se    =   0.01;

% Select instrument from Nshare largest realisations of policy innovation 
  Nshare =   [40 100];                    
 
%__________________________________________________________________________
% RUN  for i = 1 and j = [1 2]
%__________________________________________________________________________
  for i = 1
  for j = [1 2]
      clc, disp(['Sim ' num2str(M_.Nstar) '_' num2str(i) '_' num2str(j)])
      disp('_______________________________ ')
 
    % SET PARAMETERS  
      M_.Nshare = Nshare(j);

    % VAR estimation & SC prior  
      M_.lags  =  1;
      M_.const =  0;
      M_.SC_a  =  1;
      M_.SC_b  =  1;
      M_.SC_L  =  1.0;
      M_.SC_U  =  1.0;
      
    % Run && save
      [H_,tR_]  = Sim_Run_2(M_);
      
      fn  = [fnroot num2str(M_.Nstar) '_' num2str(i) '_' num2str(M_.Nshare)];
      save(fn,'H_','tR_','M_')
      disp(' ')
      disp(['Results saved to ' fn])           
      clear H_ tR_
  end
  end