%__________________________________________________________________________
% STRUCTURAL VAR SIMULATION       
% This runs the Monte Carlo simulations of section 3 for a value of m = 20
%__________________________________________________________________________  
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir))

%__________________________________________________________________________
% SET PARAMETERS
%__________________________________________________________________________
% Control
  rDir     =  'Sim_Results_1\';              % Results sub-directory 
  fnroot   =  [cDir rDir 'Sim_1_'];        % Results file root
  
  M_.nsim  =   1000;                          % Nr of simulations
  M_.nd    =   200;                           % Nr of draws for indiv VAR
  M_.T     =   200;                           % Sample length of VAR
  M_.Nstar =   20;                            % Nr of nonzero values of z (m) 
  M_.QNT   =   [0.10 0.16 .50 .84 .90];
     
% DGP VAR (see Online Supplement B.3)
  rho      =   0.90;
  g        =   0.20;
  a        =   pi/4;
  r        =   0.3;
  M_.A1    =   rho*[cos(g) sin(g); -sin(g) cos(g)];
  M_.B1    =   eye(2);                                                         
  M_.c0    =   [0;1];                                                          
  M_.se    =   0.01;
  
% DGP policy function and instrument pollution
% See Sim_Generate_1 for details
  Si       =  nan(4,4);
  Si(1,:)  = [  0.0  0.0  0.0  0.0  ];   %  Basic
  Si(2,:)  = [  0.5  0.0  0.0  0.0  ];   %  Lagged dependeny 
  Si(3,:)  = [  0.0  0.5  0.5  0.0  ];   %  Unobserved events 
  Si(4,:)  = [  0.0  0.0  0.0  1.0  ];   %  Redundant events
  scale    = [  0.5  1.0 ];              %  Std dev  of macropru measures 
  
% Critical value eta0 for all (Si(i,;),scale(j)) 
  eta0       =  nan(4,2);
  eta0(1,:)  = [ 1.28   nan ];
  eta0(2,:)  = [ nan    nan ] ;
  eta0(3,:)  = [ 1.28   nan ] ;
  eta0(4,:)  = [ nan    nan ];                
   
%__________________________________________________________________________
% RUN
% The relevant combinations are i = [1 3] with  j =  1
%__________________________________________________________________________
  for i = [1 3]
  for j =  1
      clc, disp(['Sim ' num2str(M_.Nstar) '_' num2str(i) '_' num2str(j)])
      disp('_______________________________ ')
 
    % Parameters DGP  
      M_.lam1   =  Si(i,1);
      M_.sp     =  0.01;
      M_.etaP   =  M_.se;                                                    
      M_.etaN   =  0;                                                        
      M_.scale  =  scale(j);              
      M_.eta0   =  eta0(i,j) * M_.se;               

    % Parameters DGP pollution  
      M_.pp     =  Si(i,2);
      M_.pn     =  Si(i,3);
      M_.pA     =  Si(i,4);
      
    % VAR estimation & SC prior   
      M_.lags   =  1;
      M_.const  =  0;
      M_.SC_a   =  1;
      M_.SC_b   =  1;
      M_.SC_L   =  0.9;
      M_.SC_U   =  1.0;
      
    % Adjustment SC prior
      if M_.pA == 1.0, M_.SC_L  =  M_.SC_L - 0.10; end
      if M_.pp == 0.5, M_.SC_L  =  M_.SC_L - 0.05; end
      
    % Run simulation & save
      if ~isnan(M_.eta0),  [H_,tR_]  = Sim_Run_1(M_);
      else                  H_       = []; 
                            tR_      = [];
      end
      
      fn  = [fnroot num2str(M_.Nstar) '_' num2str(i) '_' num2str(j)];
      save(fn,'H_','tR_','M_')
      disp(' ')
      disp(['Results saved to ' fn])           
      clear H_ tR_
  end
  end