%__________________________________________________________________________
% THIS PROCESSES THE SIMULAION RESULTS FROM SIMULATION 1 REPORTED IN 
% ONLINE SUPPLEMENT TABLE C1       
%
% This produces the results for a single simulation as reported in Table C1.
%
% Choose 'sim' and 'lags' to select the simulation. 
% To run the simulations please run Sim_Main_V1_10 and Sim_Main_V1_20. 
%__________________________________________________________________________  
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir))

%__________________________________________________________________________  
% OPTIONS
% sim    Nr of simulation to be inspected
% lags   Lags - Table C1 shows Lag 1 only
%__________________________________________________________________________  
  sim   =  2;  
  
%__________________________________________________________________________  
% LOAD
%__________________________________________________________________________  
  switch sim
    case {1}, fn1  =  'Sim_Results_2\Sim_2_10_1_100';
    case {2}, fn1  =  'Sim_Results_2\Sim_2_10_1_40';    
  end

  load([cDir fn1]);
  if isempty(tR_), error(['Empty simulation: ' fn1]), end

%__________________________________________________________________________  
% OPTIONS
% Analyse series ser
% Lags is the horizon of the IRF to be inspected  
% bU and bL are the indices of quantiles to be used from M_.QNT
% Either bU = 5, bL = 1  and  Q = [.10 .50 .90] 
% or     bU = 4, bL = 2  and  Q = [.16 .50 .84]
% lags   is the lags to be shown in the tables
%__________________________________________________________________________  
  ser    =   1;                                      
  lags   =   1;
  bU     =   5;                                              
  bL     =   1;                                               
  Q      =  [M_.QNT(bL) 0.5 M_.QNT(bU)];                              

%__________________________________________________________________________  
% BASIC DEFINITIONS AND VARIOUS ADJUSTMENTS
%__________________________________________________________________________  
% Dimensions 
 [irf_H, n, nq, nsim] = size(H_(1).L_);                
  
% Model names 
  Models =  cell(length(H_),1);                           
  for m = 1:length(H_) 
      Models{m} = H_(m).mod; 
  end

% Invert the order of quantiles for proxy VARs
  for i = 7:8 
      H_(i).L_  =  H_(i).L_(:,:,[5 4 3 2 1],:); 
  end
  
% LP, RecVAR and dummy VAR to shock of size 1 
  H_(10).L_  =  H_(10).L_ / sqrt(M_.Nstar/M_.T);
  
  for s = 1:nsim
      mean_z = mean(abs(tR_.zv(tR_.zv(:,s)~=0,s)));
      H_(9).L_(:,:,:,s)  =   H_(9).L_(:,:,:,s) / (mean_z *100);
      H_(11).L_(:,:,:,s) =  H_(11).L_(:,:,:,s) / (mean_z *100);
  end  
  
%__________________________________________________________________________  
% ELIMINATE DRAWS WHERE SC OR DSC DID NOT CONVERGE
%__________________________________________________________________________  
  ix = zeros(nsim,m);
       
  for m = 1:length(H_)
  for d = 1:nsim    
          ix(d,m) = isnan(H_(m).L_(1,1,3,d));
  end
  end
  
  ix = sum(ix,2) > 0;
  for m = 1:length(H_)
      H_(m).L_  =  H_(m).L_(:,:,:,~ix);
      H_(m).LZ  =  H_(m).LZ(:,:,:,~ix);
  end     
  tR_.L_  =  tR_.L_(:,:,~ix);
  tR_.LZ  =  tR_.LZ(:,:,~ix);
  tR_.zz  =  tR_.zz(:,~ix);
  tR_.zv  =  tR_.zv(:,~ix);

  
  nsim = size(H_(m).L_,4);
  disp(' ')
  disp([num2str(nsim) ' Simulations kept'])
  
%__________________________________________________________________________  
% PROPERTIES OF THE TRUE DATA PROCESS 
%__________________________________________________________________________  
  XX    = zeros(length(Q),4);

% Basic Statistixs on ps and z
  zv_m  = nan(nsim,1);
  zv_s  = nan(nsim,1);
  for d = 1:nsim
      zv      = tR_.zv(:,d);
      zv_m(d) = mean(abs(zv(zv~=0)));
      zv_s(d) =  std(abs(zv(zv~=0)));
  end

  XX(:,1) =  quantile(sum(tR_.zv ~= 0,1),Q);          % Nr of non-zero ps
  XX(:,2) =  quantile(sum(tR_.zz ~= 0,1),Q);          % Nr of non-zero z
  XX(:,3) =  quantile(zv_m,Q);                        % Mean abs ps (ps ~=0)
  XX(:,4) =  quantile(zv_s,Q);                        % Std  abs ps (ps ~=0)
  
 
%__________________________________________________________________________    
% STATISTICS ON INSTRUMENT AND ESTIMATED POLICY SHOCKS
%__________________________________________________________________________  
  bands  = [bL 3 bU];  

  XX     =  zeros(9,5);
  for m  = 1:length(H_)
       H_(m).Sm   = mean(H_(m).S_,3);
       XX(1:3,m)  = H_(m).Sm(1,bands)';
       XX(4:6,m)  = H_(m).Sm(2,bands)';
       XX(7:9,m)  = H_(m).Sm(3,bands)';
  end
  RLabs  = {'Corr(.1)','Corr(.5)','Corr(.9)','SC(.1)','SC(.5)','SC(.9)',...
            'mEZ(.1)','mEZ(.5)','mEZ(.9)'}; 
  
  disp(' ')
  disp('_________________________________________________________________')
  disp(['Simulation ' fn1])
  disp('Rows 1 -  3 show corr btwn z and the shock (Quantiles)');
  disp('Rows 4 -  6 show SC   btwn z and the shock (Quantiles)');
  disp('Rows 7 - 10 show mean z*shock) | z~= 0     (Quantiles)');
  disp('_________________________________________________________________')
  my_prtmat(XX,[],RLabs,Models) 
  
  
%__________________________________________________________________________  
% IRF Calculations
%__________________________________________________________________________  
% Obtain : true IRF (for fixed C0,C1 this is actually the same for all draws)
%          Bias and width of confid bands from each draw
%          Quantiles of median IRF across draws ("true" confidence bounds)
%          Means   of  IRF quantiles from each draw  (both L_ and LZ)
%          Medians of  IRF quantiles from each draw  (both L_ and LZ) 
%__________________________________________________________________________  
  IRF       =  struct('mod',Models);            % Statistics of model IRFs
  IRF_true  = squeeze(tR_.L_(:,:,1));           % Statistics of true IRF
  
% True confidence set: Quants of individual median responses ([irf_H,n,nq])
  for m = 1:length(H_)
      IRF(m).Qmdn  = squeeze(quantile(H_(m).L_(:,:,3,:) ,Q,4));
  end
  
% Bias and interquantile difference of L_  ([irf_H,n,nsim])
  for m = 1:length(H_)
      IRF(m).bias = nan([irf_H, n, nsim]); IRZ(m).bias = IRF(m).bias;
      for d = 1:nsim
          IRF(m).bias(:,:,d) = H_(m).L_(:,:,3,d)  - IRF_true;
      end
  end    
  
  for m = 1:length(H_)
      IRF(m).Qdif = nan([irf_H, n, nsim]); IRZ(m).Qdif = IRF(m).Qdif;
      for d = 1:nsim
          IRF(m).Qdif(:,:,d) = H_(m).L_(:,:,bU,d) - H_(m).L_(:,:,bL,d);
      end
  end      
  
% Mean squared error of point estimate  
  for m = 1:length(H_)
      IRF(m).mse = nan([irf_H, n, nsim]); 
      for d = 1:nsim
          IRF(m).mse(:,:,d) = (H_(m).L_(:,:,3,d) - IRF_true(:,:)).^2;
      end
  end  
  
% Coverage ratio  
  for m = 1:length(H_)
      IRF(m).cr = nan([irf_H, n, nsim]); 
      IRZ(m).cr = IRF(m).cr;

      for d = 1:nsim
        IRF(m).cr(:,:,d) = (IRF_true(:,:) > H_(m).L_(:,:,bL,d)) &  ... 
                           (IRF_true(:,:) < H_(m).L_(:,:,bU,d));
      end   
     IRF(m).cr  =  mean(IRF(m).cr,3);
  end  
  
% Means of quantiles
  for m = 1:length(H_)
     IRF(m).mdn   =  squeeze(mean(H_(m).L_(:,:,3,:),4));       % Median
     IRF(m).qL    =  squeeze(mean(H_(m).L_(:,:,bL,:),4));      % Lower 
     IRF(m).qU    =  squeeze(mean(H_(m).L_(:,:,bU,:),4));      % Upper
     IRF(m).Qbs   =  squeeze(mean(IRF(m).bias(:,:,:),3));      % Bias
     IRF(m).QQd   =  squeeze(mean(IRF(m).Qdif(:,:,:),3));      % UB
     IRF(m).rmse  =  squeeze(mean(sqrt(IRF(m).mse(:,:,:)),3)); % RMSE
  end
  
  
%__________________________________________________________________________  
% PRINT IRF STATISTICS
%__________________________________________________________________________  
  XX     = nan(length(H_),9);
  for m  = 1:length(H_)
    XX(m,1)  =  IRF_true(lags,ser)';
    XX(m,2)  =  IRF(m).qL(lags,ser)';
    XX(m,3)  =  IRF(m).mdn(lags,ser)';
    XX(m,4)  =  IRF(m).qU(lags,ser)';

    XX(m,5)  =  IRF(m).rmse(lags,ser);
    XX(m,6)  =  IRF(m).Qbs(lags,ser)';
    XX(m,7)  =  IRF(m).Qmdn(lags,ser,3) - IRF(m).Qmdn(lags,ser,1);
    XX(m,8)  =  IRF(m).QQd(lags,ser)';
    XX(m,9)  =  IRF(m).cr(lags,ser);
  end
  
 % Rearrange to fit Table  
  XX       =  XX([4 3 1 2 5 7 9 6 8 10 11],:);
  RLabs    =  Models([4 3 1 2 5 7 9 6 8 10 11]);
  CLabs    =  {'True','Low','Median','Upper','RMSE','Bias','IQD ','UB','CR'};
  
  disp('_________________________________________________________________')
  disp(['Simulation ' fn1])
  disp('TABLE 1')
  disp('_________________________________________________________________')
  my_prtmat(XX(1:7,:)*100,[],RLabs(1:7),CLabs) 

  disp('_________________________________________________________________')
  disp(['Simulation ' fn1])
  disp('TABLE 1 Further models not shown in final version')
  disp('SC_ng is SC prior w/o Gibbs sampler mean adjustment')
  disp('iV5 is proxy VAR with Jentsch-Lunsford (2016) bootstrap')
  disp('rV is standard VAR adding instrument as endogenous variable')
  disp('dV is standard VAR adding instrument as exogenous regressor')
  disp('_________________________________________________________________')
  my_prtmat(XX(8:11,:)*100,[],RLabs(8:11),CLabs) 


%__________________________________________________________________________  
% PLOT IRFs 
%__________________________________________________________________________  
  Models   = Models([1 2 3 4 5 6]);
  IRF      =    IRF([1 2 3 4 5 6]);

  ModNames = {'BV_z','DC','DSC','SC','pV','LP'};
  sm       =  fn1(24:end);
  show     =  ones(length(Models),1);
  switch sm
      case {'1_100'},   header  = 'Weak instrument (1)'; 
      case {'1_40'},    header  = 'Strong instrument (2)'; 
  end
  Sim_plot_IRF(IRF_true, IRF, ser, ModNames, header,show)

