%_________________________________________________________________________
% ANALYZE THE NARRATIVE VAR WITH DC / SC RESTRICTIONS
% Analysis for robustness checks F-14 and M-14 
%__________________________________________________________________________
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir));
  
%__________________________________________________________________________
% SELECT RESULTS FILE Results   
%__________________________________________________________________________
  MODEL  =  1;               %  Set Model as from the below list 
                             %  1 = Robustness check as shown in Table 4
                             %  2 = Alternative check as in Online Suppl C4
  z_ix   =  1;               %  1 = Capital req , 2= Underwriting standards 

  switch MODEL
      case{1},  fn = ['R_DC_Gibbs_Z'  num2str(z_ix) '_F-14'];    % Table 4
      case{2},  fn = ['R_DSC_Gibbs_Z' num2str(z_ix) '_M-14'];    % related to 
  end 
  load([cDir 'Results_DSC\' fn])
  
%__________________________________________________________________________
% OPTIONS
%__________________________________________________________________________
  iC     =  [1 1 0 0 1 1 1];                     % Accumulation of IRF
  pct    = [0.10 0.16 0.50 0.84 0.90];           % Quantiles
  h_L    =  32;                                  % Length of IRF in plot

%__________________________________________________________________________
% SHOCKS
% POSTERIOR QUANTILES OF SC AND AVERAGE GAMMA 
%__________________________________________________________________________
  n      =  length(yName);
  ns     =  length(sName); 
  T      =  size(E_,1);
  nd     =  size(E_,3);
  
  E_     =  squeeze(E_(:,1,:));
  Em_    =  E_ .* ZZ_;  

% Calculate model-based SC and Gamma 
  S_.sumZ   =   nan(nd,1);
  S_.E      =   nan(nd,2);
  S_.sumZ   =   nan(nd,1);
  S_.SC     =   nan(nd,1);
  S_.gamma  =   nan(nd,1);
 
% Calculate SC and Gamma for lags of Z as in estimation
  for d = 1:nd
      S_.E(d,1)   =  nanmean(E_(:,d));
      S_.E(d,2)   =  nanstd(E_(:,d));
      
      S_.sumZ(d)  =  nansum(ZZ_(:,d) ~= 0); 
      S_.SC(d)    =  nansum(Em_(:,d) > 0) ./ S_.sumZ(d); 
      S_.gamma(d) =  nansum(Em_(:,d))     ./ S_.sumZ(d);
  end 
 
  S_.E_Q   =  quantile(S_.E    , pct);
  S_.SC_Q  =  quantile(S_.SC   , pct);
  S_.GZ_Q  =  quantile(S_.gamma, pct); 
  
  r_lab    =  num2str(pct,'%5.2f');
  c_lab    =  {'SC','Gamma'};
  t_line   = ['SC and Gamma for Z as in estimation '  fn];
  my_prtmat([S_.SC_Q' S_.GZ_Q'],t_line,r_lab,c_lab)
  
% Plot 
  r_lab    =  num2str(pct,'%5.2f');
  c_lab    =  [' Model'];
   
%__________________________________________________________________________
% POSTERIOR LAGS OF Z  
%__________________________________________________________________________
  if ~strcmp(iV.priorZ,'F')
      n1      = max(lag_(1,:)); 
      n2      = max(lag_(2,:)); 
      nZ      = max([n1 n2]);
      countZ1 = zeros(1+nZ,1);
      countZ2 = zeros(1+nZ,1);
      
      for i = 0:nZ, countZ1(i+1) = sum(lag_(1,:) == i); end 
      for i = 0:nZ, countZ2(i+1) = sum(lag_(2,:) == i); end 
      
      figure('position', [900, 1100, 500, 200])
      subplot(1,2,1), bar(countZ1), title('Posterior lead Z')
      xticklabels(mat2cell((0:nZ)',nZ+1))
      
      subplot(1,2,2), bar(countZ2), title('Posterior lag Z')
      xticklabels(mat2cell((0:nZ)',nZ+1))
      
      t_line   =  ['Posterior of lags of Z '];
      S_.lagZ  =  [countZ1 countZ2];
      c_lab    =  {'Leads','Lags'};
      r_lab    =  num2str(0:nZ,'%3.0f');
      my_prtmat(S_.lagZ,t_line,r_lab,c_lab)
  end
   
%__________________________________________________________________________
% CALCULATE IMPULSE RESPONSES TIMES GAMMA (IOZ)  
%__________________________________________________________________________
  iC   =  logical(iC);
  LC_  =  nan(size(L_));
  IOZ  =  nan(size(L_));
  nh   =  size(L_,1)-1;
  
  for d = 1:nd
      LC_(1,:,:,d)  = L_(1,:,:,d);
      for h = 2:(nh+1)
          LC_(h,:,:,d) = LC_(h-1,:,:,d) + L_(h,:,:,d);
      end  
  end
  L_(:,iC,:,:) = LC_(:,iC,:,:);  
  L_(:,7,:,:) =  L_(:,2,:,:) +  L_(:,7,:,:);

  for d = 1:nd
      IOZ(:,:,:,d) = L_(:,:,:,d) * (sum(Em_(:,d)) ./ sum(abs(ZZ_(:,d))));
  end
  
% Quantiles  
  L_mean =  mean(L_,4);
  L_q    =  store_IRFs(L_ ,pct);
  IZq    =  store_IRFs(IOZ,pct);
  
%__________________________________________________________________________
% TABLE 4: ROBUSTNESS CHECK AGAINST LAGGED IMPACTS 
%__________________________________________________________________________
  h_Y     = 1;  
  Sp1     = squeeze(IZq(h_Y+1,:,:,:))*100;
  t_line  = ['Average Impact of Innovations at Horizon '  num2str(h_Y)];
  my_prtmat(Sp1,t_line,[yName],num2str(pct))
  
  h_Y     = 4;  
  Sp4     = squeeze(IZq(h_Y+1,:,:,:))*100;
  t_line  = ['Average Impact of Innovations at Horizon '  num2str(h_Y)];
  my_prtmat(Sp4,t_line,[yName],num2str(pct))

  h_Y     = 32;  
  Sp32    = squeeze(IZq(h_Y+1,:,:,:))*100;
  t_line  = ['Average Impact of Innovations at Horizon '  num2str(h_Y)];
  my_prtmat(Sp32,t_line,[yName],num2str(pct))

% Table 4 combined
  SP_  = [Sp4(1:3,:); Sp1(4,:); Sp32(5:7,:)];
  t_line  = ['Table 4: Avg Impact of Innovations (different horizons)'];
  my_prtmat(SP_,t_line,[yName],num2str(pct))

