%_________________________________________________________________________
% ANALYZE THE NARRATIVE VAR WITH DC / SC RESTRICTIONS MAIN MODEL F00
% Set model = 1 to obtain Table 3
% Set model = 5 to obtain Table 4 
%__________________________________________________________________________
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir));
  
%__________________________________________________________________________
% SELECT RESULTS FILE Results   
%__________________________________________________________________________
  MODEL   =  1;             %   Set Model as from the below list 
  z_ix    =  2;             %   1 = Capital req , 2= Underwriting standards 
  
  switch MODEL
      case{1},  fn = ['R_DSC_Gibbs_Z'   num2str(z_ix) '_F00'];    % Table 3
      case{2},  fn = ['R_DC_Gibbs_Z'    num2str(z_ix) '_F00'];
      case{3},  fn = ['R_Gibbs_SC'      num2str(z_ix) '_F00'];
  end
  load([cDir 'Results_DSC\' fn])

%__________________________________________________________________________
% OPTIONS
%__________________________________________________________________________
  iC    =  [1 1 0 0 1 1 1];                     % Accumulation of IRF
  pct   =  [0.10 0.16 0.50 0.84 0.90];          % Quantiles
  h_L   =  32;                                  % Length of IRF in plot
  hlist = -1:4;                                 % Calculation of SC and Gamma 

%__________________________________________________________________________
% SHOCKS
% POSTERIOR QUANTILES OF SC AND AVERAGE GAMMA 
%__________________________________________________________________________
  n    =  length(yName);
  ns   =  length(sName); 
  T    =  size(E_,1);
  nd   =  size(E_,3);
  nh   =  length(hlist);

  E_   =  squeeze(E_(:,1,:));
  Z_   =  iV.z(p+1:end);
  Em_  =  E_ .* ZZ_;  

% Statistics on Z_  
  S_.sumZ   =   nansum(Z_ ~= 0);
  S_.sumP   =   nansum(Z_ >  0);
  S_.sumN   =   nansum(Z_ <  0);
  S_.sumA   =   nan(nd,1);
  
% Calculate SC and Gamma at indiviudal lags of original Z
  S_.E      =   nan(nd,2);
  S_.SC     =   nan(nd,nh+1);
  S_.gamma  =   nan(nd,nh+1);

  for h = 1:nh
  for d = 1:nd
      EZ  =  lagmatrix(E_(:,d),-hlist(h)) .* ZZ_(:,d);
      
      S_.E(d,1)     =  nanmean(E_(:,d));
      S_.E(d,2)     =  nanstd(E_(:,d));
      S_.SC(d,h)    =  nansum(EZ  > 0) / S_.sumZ; 
      S_.gamma(d,h) =  nansum(EZ)      / S_.sumZ;
  end
  end
  
% Calculate SC and Gamma for lags of Z as in estimation
  for d = 1:nd
     S_.sumA(d)       =  nansum(ZZ_(:,d) ~= 0); 
     S_.SC(d,nh+1)    =  nansum(Em_(:,d) > 0) ./ S_.sumA(d); 
     S_.gamma(d,nh+1) =  nansum(Em_(:,d))     ./ S_.sumZ;
  end 

% Adjust Gamma (to be improved for lags)
  S_.gamma  = S_.gamma * (1 + S_.sumZ/T);
   
  
% Table 
  disp('______________________________________________________________')
  disp(['Results for ' fn])
  disp('______________________________________________________________')
  disp(['sum Z     : '  num2str(S_.sumZ)])
  disp(['sum Z pos : '  num2str(S_.sumP)])
  disp(['sum Z neg : '  num2str(S_.sumN)])
 
  S_.E_Q   =  quantile(S_.E    , pct);
  S_.SC_Q  =  quantile(S_.SC   , pct);
  S_.GZ_Q  =  quantile(S_.gamma, pct); 
  
  r_lab    =  num2str(pct,'%5.2f');
  c_lab    =  {'SC','Gamma'};
  t_line   = ['SC and Gamma for Z as in estimation '  fn];
  my_prtmat([S_.SC_Q(:,nh+1) S_.GZ_Q(:,nh+1)],t_line,r_lab,c_lab)
  
% Plot 
  r_lab    =  num2str(pct,'%5.2f');
  c_lab    =  [num2str(hlist) ' Model'];
  
  t_line   = ['Sign concordance of Z(t) with E(t+h) '  fn]; 
  my_prtmat(S_.SC_Q,t_line,r_lab,c_lab)
  t_line   = ['Size of sign-adj policy E (t+h)']; 
  my_prtmat(S_.GZ_Q,t_line,r_lab,c_lab)
  
% Check for complete separation  
  min_1     =  nan(nd,1);
  max_0     =  nan(nd,1);
  sc        =  nan(nd,1);
  count_0   =  nan(nd,1);
  for d = 1:nd
       EZ  =  E_(:,d) .* Z_;
       Ed  =  E_(:,d);
       
       min_1(d)  =  min(EZ(Z_ ~= 0));
       max_0(d)  =  max(Ed(Z_ == 0));
       sc(d)     =  sum(EZ(Z_ ~= 0) > 0) ./ sum(abs(Z_));
  end
   
%__________________________________________________________________________
% CALCULATE IMPULSE RESPONSES TIMES GAMMA  
%__________________________________________________________________________
  iC   =  logical(iC);
  LC_  =  nan(size(L_));
  IOZ  =  nan(size(L_));
  nh   =  size(L_,1)-1;
  
  for d = 1:nd
      LC_(1,:,:,d)  = L_(1,:,:,d);
      for h = 2:(nh+1)
          LC_(h,:,:,d) = LC_(h-1,:,:,d) + L_(h,:,:,d);
      end  
  end
  L_(:,iC,:,:) = LC_(:,iC,:,:);  
  L_(:,7,:,:) =  L_(:,2,:,:) +  L_(:,7,:,:);

  for d = 1:nd
       IOZ(:,:,:,d) = L_(:,:,:,d) * (sum(Em_(:,d)) ./ sum(abs(ZZ_(:,d))));
  end
  
  L_mean =  mean(L_,4);
  L_q    =  store_IRFs(L_ ,pct);
  IZq    =  store_IRFs(IOZ,pct);
  
% Plot  
%  rx   = [-0.5 0.5 0.5;-0.8 0.8 0.8 ; -0.8 0.8 0.8; -0.5 0.5 0.5;  ... 
%          -1.0 1.0 1.0 ; -1.0 1.0 1.0 ];
%  plot_IRFs(L_q(1:h_L+1,:,1,[2 3 4])*100,yName,sName(1),[])
%  plot_IRFs(IZq(1:h_L+1,:,1,[2 3 4])*100,yName,sName(1),[])

  
%__________________________________________________________________________
% TABLE 3: AVERAGE IMPACT OF POLICY INNOVATIONS  
%__________________________________________________________________________
  h_Y     = 1;  
  Sp1      = squeeze(IZq(h_Y+1,:,:,:))*100;
  t_line  = ['Average Impact of Innovations at Horizon '  num2str(h_Y)];
  my_prtmat(Sp1,t_line,[yName],num2str(pct))
  
  h_Y     = 4;  
  Sp4      = squeeze(IZq(h_Y+1,:,:,:))*100;
  t_line  = ['Average Impact of Innovations at Horizon '  num2str(h_Y)];
  my_prtmat(Sp4,t_line,[yName],num2str(pct))

  h_Y     = 32;  
  Sp32      = squeeze(IZq(h_Y+1,:,:,:))*100;
  t_line  = ['Average Impact of Innovations at Horizon '  num2str(h_Y)];
  my_prtmat(Sp32,t_line,[yName],num2str(pct))

% Table 3 combined
  SP_  = [Sp4(1:3,:); Sp1(4,:); Sp32(5:7,:)];
  t_line  = ['Table 3: Avg Impact of Innovations (different horizons)'];
  my_prtmat(SP_,t_line,[yName],num2str(pct))

  
