%__________________________________________________________________________
% PLOT FIGURES ANNEX C2 TO C5          
% Set cDir in line 11 to your root directory
% Run Estimates from Estimate_DSC first to obtain the results files
% This requires cycling through values ''DSC', 'DC', and 'SC' of variable 
% MODEL in Estimate_DC
%
% Set Fig_nr on line 14 to choose the plot
%__________________________________________________________________________
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir));
   
  Qd        =  [0.10 0.10 0.5 0.90 0.90];          % Vector of length 5!
  iC        =  [1 1 0 0 1 1 1];                    % Accum IRF
  
  flag_IOZ  =   0;                                 % = 1 -> IOZ scaling
  ph        =   32;                                % IRF horizon length
  
% Main graph  
  fn{1}     =  'Results_DSC\R_DSC_Gibbs_Z1_F00';              
  fn{2}     =  'Results_DSC\R_DC_Gibbs_Z1_F00';               
  fn{3}     =  'Results_DSC\R_SC_Gibbs_Z1_F00';              
  fn{4}     =  'Results_DSC\R_DSC_Gibbs_Z2_F00';            
  fn{5}     =  'Results_DSC\R_DC_Gibbs_Z2_F00';              
  fn{6}     =  'Results_DSC\R_SC_Gibbs_Z2_F00';              
  
  ylabels   = {'GDP','Consumer Prices','BAA Spread', ... 
               'Corporate Credit','Household Credit', 'House Prices'}; 
           
% Sign concordance prior           
  M_.a   =   1;                        
  M_.b   =   1;                       
  M_.L   =   0.90;
  M_.U   =   1.00;
 
% Colours  
  col    =  [210 210 210; 210 210 210]  / 256;             % Grey for bands 
  col_r  =  [205 000 000]               / 256;             % Red
  
  col_b  =  col_r;         
  col_k  =  [0 0 0];                                       % Black
  
            
%__________________________________________________________________________
% LOAD AND CALCULATE STATISTICS  
%__________________________________________________________________________
  for m = 1:6
      load([cDir fn{m}])
      n      =  length(yName);
      T      =  size(E_,1);
      irf_H  =  size(L_,1) - 1;
      ndraw  =  size(L_,4);

   % IRF 
     iC      =  logical(iC);
     LC_     =  nan(size(L_));
     IOZ     =  nan(size(L_));
  
     for i = 1:ndraw
        LC_(1,:,:,i)  = L_(1,:,:,i);
        for h = 2:(irf_H+1)
            LC_(h,:,:,i) = LC_(h-1,:,:,i) + L_(h,:,:,i);
        end  
     end
     L_(:,iC,:,:) =  LC_(:,iC,:,:);
     L_(:,7,:,:)  =   L_(:,2,:,:) +  L_(:,7,:,:); 
     
   % Remove FedFundRate   
     L_            =   L_(:,[1 2 4 5 6 7],:,:);
     R(m).L_q      =   store_IRFs(L_,Qd);
     zz            =   iV.z(p+1:end);

    [S1,R(m).S2]   =   nVStat(zz,E_,1,sName{1},Qd,0);
     SC            =   R(m).S2(:,2);
     nz            =   sum(zz ~=0);
      
     x_post         =  unique(SC)*nz;
     SC_post        =  hist(SC,length(x_post));
     y_post         =  zeros(nz,1);
     y_post(x_post) =  SC_post;
     R(m).nz        =  nz;
     R(m).y_post    =  y_post  / sum(y_post);
     
   % IOZ 
     if flag_IOZ == 1
        for i = 1:ndraw
            IOZ(:,:,:,i) = L_(:,:,:,i) * R(m).S2(i,5);             
        end
        R(m).L_q  =  store_IRFs(IOZ,Qd);
     end
  end
  
%__________________________________________________________________________
% CALCULATE PRIOR SC
%__________________________________________________________________________
  mm  =  unique(vertcat(R.nz));

  for jj     =  1:length(mm)
    M_.sumZ  =  mm(jj);
    ndraw    =  100000;
    pi0      =  nan(ndraw,1);
    p_       =  nan(ndraw,1);
   
  % Draw
    for d = 1:ndraw
        pi0(d) =  prior_pi(M_.a,M_.b,M_.L,M_.U);
        p_(d)  =  random('bino',M_.sumZ,pi0(d)) / M_.sumZ;
    end
    
  % Get histogram  
    x_prior   =  unique(p_*M_.sumZ);             
    SC_prior  =  hist(p_,length(x_prior));
    
  % Map histogram into [1:M_.sumZ)
    y_prior            = zeros(M_.sumZ,1);
    y_prior(x_prior)   = SC_prior;
    P(M_.sumZ).y_prior = y_prior / sum(y_prior); 
  end
  

%__________________________________________________________________________
% PLOT SC POSTERIOR (Figure 2 in paper)
%__________________________________________________________________________
  figure('name','SC Posterior','position',[250, 250, 600*1.25, 400*1.25])
 
% Capital Requirements %%%
  sub1 = subplot(1,2,1);
  plotname(1) = bar(1:R(1).nz, R(1).y_post,1, 'EdgeColor','none', ... 
                                       'FaceColor',[210 210 210]/256); 
  hold on
  shading flat
  ymax = 0.625;  
 
  set(sub1, 'Position',[0.1 0.5 0.3347 0.31] );
  Linecol  = [[0 0 0]; col_r ; col_b];
  Linesty  = {'-';'--';':'};
  LineW    = [1.5; 1.0; 1.5]; 
  
  
  for jj=2:3
    x1          = 0:R(jj).nz+1 ;
    x1(:,2:end) = x1(:,2:end)-0.5;
    x2          = [0; R(jj).y_post;R(jj).y_post(R(jj).nz)]; 
    c           = [x1' x2];
 
    for i = 1:R(jj).nz+1
     plotname(jj) =  plot([c(i,1) c(i+1,1)],[c(i,2) c(i,2)],'LineWidth', LineW(jj,:), ... 
                    'Color',Linecol(jj,:),'LineStyle', Linesty{jj});
     hold on
     plot([c(i,1)+1 c(i,1)+1],[c(i,2) c(i+1,2)],'LineWidth',  LineW(jj,:), 'Color', ... 
                                  Linecol(jj,:), 'LineStyle', Linesty{jj})
     hold on
     if i == R(jj).nz+1 
             plot([c(i,1)+1 c(i,1)+1],[c(i,2) 0], ... 
             'LineWidth', LineW(jj,:), 'Color',Linecol(jj,:),'LineStyle', Linesty{jj}) 
             hold on
     end    
    end
  end
  
  line(1:R(1).nz,P(R(1).nz).y_prior,'LineWidth', 1.5, 'Color','k')
  title('Capital Requirements', 'FontWeight','normal')
  xlim([1 R(jj).nz+1])
  ylim([0 ymax])   
  set(gca,'YTick',0:0.2:ymax)
  set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
  set(gca,'Fontsize',8)
  hold off
  
% Underwriting Standards 
  sub2 = subplot(1,2,2);
  DCR_SC = bar(1:R(4).nz, R(4).y_post,1, 'EdgeColor','none', ... 
                                   'FaceColor',[210 210 210]/256); 
  hold on
  shading flat
  set(sub2,'Position',[0.6 0.5 0.3347 0.31]) 

  for jj=5:6
    x1          = 0:R(jj).nz+1 ;
    x1(:,2:end) = x1(:,2:end)-0.5;
    x2          = [0; R(jj).y_post;R(jj).y_post(R(jj).nz)];
    c           = [x1' x2];

    for i=1:R(jj).nz+1
        plot([c(i,1) c(i+1,1)],[c(i,2) c(i,2)],   'LineWidth', LineW(jj-3,:), ... 
              'Color',Linecol(jj-3,:),'LineStyle', Linesty{jj-3}) 
        hold on
        plot([c(i,1)+1 c(i,1)+1],[c(i,2) c(i+1,2)],'LineWidth', LineW(jj-3,:), ... 
            'Color',Linecol(jj-3,:), 'LineStyle', Linesty{jj-3}) 
        hold on
        if i == R(jj).nz+1 
        plot([c(i,1)+1 c(i,1)+1],[c(i,2) 0],'LineWidth', LineW(jj-3,:), ... 
                'Color',Linecol(jj-3,:),'LineStyle', Linesty{jj-3}) 
        hold on, end    
    end
 
  end
 
  Prior = line(1:R(4).nz,P(R(4).nz).y_prior,'LineWidth',1.5, 'Color','k');

  title('Underwriting Standards', 'FontWeight','normal')  
  xlim([1 R(jj).nz+1])
  ylim([0 ymax])   
  set(gca,'YTick',0:0.2:ymax)
  set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
  set(gca,'Fontsize',8)
  
  hold off
  legend([Prior plotname(1) plotname(3) plotname(2)],{'Prior',  ... 
      'DC Regression with SC Prior','SC Prior', ... 
      'DC Regression'},...
      'Orientation','horizontal','Position',[0.495 0.38 0.05 0.05])
  legend('boxoff') 
  
  change_gap([sub1 sub2], 1, -0.05) 
  
  
%__________________________________________________________________________
% PLOT 2: GAMMA POSTERIOR (not shown in paper) 
%__________________________________________________________________________
  LineW   = [1.5; 1.0; 1.75]; 
  xi      = 50;                      % Estimate the ksdensity at xi points 
 
  figure('Name','Gamma Posterior','Position',[250, 250, 600*1.25, 400*1.25]);
  rx   = [-0.5; 1.5];                     
  
% Capital Requirements 
  sub3  = subplot(1,2,1); 
  set(sub3, 'Position',[0.1 0.5 0.3347 0.310] );
 
  for m = 1:3 
      x1     = R(m).S2(R(m).S2(:,4)>=0,4);
      pts    = linspace(rx(1),rx(2),xi);
     [f1,~]  = ksdensity(x1,pts);
      plotname(m) = plot(pts,f1,'Color',     Linecol(m,:), ... 
                                'LineWidth', LineW(m), ... 
                                'LineStyle', Linesty{m});
     hold on  
  end
  ylim([0 3])
  set(gca,'YTick',100)
  set(gca,'Fontsize',8)
  title('Capital Requirements', 'FontWeight','normal')
  hold on
 
% Underwriting Standards 
  sub4 = subplot(1,2,2); % right chart
  set(sub4, 'Position',[0.6 0.5 0.3347 0.310] );
 
  for m = 4:6
     x1      = R(m).S2(R(m).S2(:,4)>=0,4);
     pts     = linspace(rx(1),rx(2),xi);
    [f1,~]   = ksdensity(x1,pts);
     plotname(m) = plot(pts,f1,'Color',Linecol(m-3,:), ... 
                               'LineWidth', LineW(m-3), ... 
                               'LineStyle',Linesty{m-3});
    hold on  
  end
  
  ylim([0 3])
  set(gca,'YTick',100)
  set(gca,'Fontsize',8)
  title('Underwriting Standards', 'FontWeight','normal')

  leg2 = legend([plotname(1) plotname(3) plotname(2)], ... 
        {'DC Regression with SC Prior','SC Prior', ... 
         'DC Regression'},...
         'Orientation','horizontal','Position',[0.505 0.38 0.05 0.05]);
  set(leg2,'Box','off');
  
  change_gap([sub3 sub4], 1, -0.05) 

   
%__________________________________________________________________________
% PLOT IMPULSE RESPONSES (Figures 3 & 4 in paper) 
%__________________________________________________________________________
% Scaling IRFs
  if flag_IOZ == 0
     rx   = [-1.0 0.5 1.5;  -2.0 2.0 4.0 ;  -0.1 0.2 0.3; ...   
             -2.0 1.0 3.0;  -2.0 2.0 4.0 ;  -6.0 2.0 6.0]; 
         
     rx   = [-1.0 0.5 0.5;  -2.0 2.0 1.0 ;  -0.1 0.2 0.1; ...   
             -3.0 1.0 1.0;  -3.0 2.0 1.0 ;  -6.0 2.0 2.0]; 
         
  else
     rx   = [-0.9 0.3 1.2;  -1.5 1.0 2.5 ;  -0.1 0.2 0.3;  ...  
             -2.0 1.0 3.0 ; -2.0 1.0 3.0  ; -4.0 2.0 6.0]; 
  end
  h   = (0:ph)';
  ny  = length(ylabels);
  ns  = length(R);
    
% ______________________________________________________________________  
% Capital Requirements 
  figure('Name', 'Capital Requirements','position', [100, 50, 600, 360])
  set(gca,'Fontsize',6)
  col_D  =  col(1,:);                                
  nQ     = (length(Qd)-1)/2;
% sQ     =  1;                   % Initial quantile: 1 if both conf bands, 
                                 %                   2 if only inner on
  
  for i  = 1:ny 
     sub         =  subplot(2,3,i);
     bands       =  squeeze(R(1).L_q(1:ph+1,i,1,[1:nQ nQ+2:end])) * 100;
     centerline  =  squeeze(R(1).L_q(1:ph+1,i,1,nQ+1)) * 100;
     xplot       =  h([1:end end:-1:1]);
  
     for k = 1:nQ
         patch(xplot, [bands(:,0+k); flipud(bands(:,end-k+1))]',  ... 
                          col(k,:),'EdgeColor',col_D,'FaceAlpha',0.4);
         hold on                        
     end
     
     DCR_SC  = line(h, centerline, 'LineWidth', 1.75, 'Color',col_r);
     hold on
     DC      = plot(h,R(2).L_q(1:ph+1,i,1,3)*100,'Color',col_r, ... 
                                 'LineWidth',1.25,'LineStyle','--'); 
     hold on       
     SC     = plot(h,R(3).L_q(1:ph+1,i,1,3)*100,'Color',col_b, ... 
                                 'LineWidth',1.75,'LineStyle',':');            
     hold on                 
     line(h, zeros(ph+1,1),'LineWidth', 0.5, 'Color', 'k');
     grid on
     
    % X axis 
      xlim([0 h(end)]) 
      if h(end) <= 41,  set(gca,'XTick',0:8:h(end))
      else              set(gca,'XTick',0:12:h(end))
      end
            
    % Y axis 
      if isempty(rx)
         axis tight
      else
         ylim([rx(i,1) rx(i,2)])   
         set(gca,'YTick',rx(i,1):rx(i,3):rx(i,2))
         set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
         set(gca,'Fontsize',8)
         line(h, ones(ph+1,1)*rx(i,1),'LineWidth', 0.5, 'Color', 'k');
         line(h, ones(ph+1,1)*rx(i,2),'LineWidth', 0.5, 'Color', 'k');
      end
      
    % Axis description  
      title (ylabels{i}, 'FontWeight','normal')

    % Legend  
      if i==ny 
        pos = [0.48 0.01  0.05 0.001];    
        legend([DCR_SC DC SC],{'DC Regression with SC Prior',  ... 
                               'DC Regression','SC Prior',}   ... 
                               ,'Orientation', 'horizontal',...
                               'Position',pos ,'Interpreter','Latex');
        legend boxoff  
      end   
      
    % Widen vertical gap between plots 
      hx   =  0.075;                                
      h1   =  get(sub,'Position');
      switch i
         case {3,6},   hor = hx*1; 
         case {1,4},   hor = hx*-1; 
         otherwise  ,  hor = hx*0; 
      end
      set(sub, 'Position', [h1(1)+hor h1(2) h1(3) h1(4)]);   
  end
      
% ______________________________________________________________________  
% Underwriting Standards 
  figure('Name', 'Underwriting Standards','position', [100, 50, 600, 360])
  set(gca,'Fontsize',6)
 
  for i  = 1:ny 
     sub         =  subplot(2,3,i);
     bands       =  squeeze(R(4).L_q(1:ph+1,i,1,[1:nQ nQ+2:end])) * 100;
     centerline  =  squeeze(R(4).L_q(1:ph+1,i,1,nQ+1)) * 100;
     xplot       =  h([1:end end:-1:1]);
     for k = 1:nQ
         patch(xplot, [bands(:,0+k); flipud(bands(:,end-k+1))]',  ... 
                          col(k,:),'EdgeColor',col_D,'FaceAlpha',0.4);
         hold on                        
     end
     
     DCR_SC  = line(h, centerline,'LineWidth', 1.75, 'Color',col_r);
     hold on
     DC      = plot(h,R(5).L_q(1:ph+1,i,1,3)*100,'Color',col_r, ... 
                                  'LineWidth',1.25,'LineStyle','--'); 
     hold on       
     SC     = plot(h,R(6).L_q(1:ph+1,i,1,3)*100,'Color',col_b, ... 
                                 'LineWidth',1.75,'LineStyle',':');            
     hold on                 
     line(h, zeros(ph+1,1),'LineWidth', 0.5, 'Color', 'k');
     grid on
      
    % X axis 
      xlim([0 h(end)]) 
      if h(end) <= 41,  set(gca,'XTick',0:8:h(end))
      else              set(gca,'XTick',0:12:h(end))
      end
            
    % Y axis 
      if isempty(rx)
         axis tight
      else
         ylim([rx(i,1) rx(i,2)])   
         set(gca,'YTick',rx(i,1):rx(i,3):rx(i,2))
         set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
         set(gca,'Fontsize',8)
         line(h, ones(ph+1,1)*rx(i,1),'LineWidth', 0.5, 'Color', 'k');
         line(h, ones(ph+1,1)*rx(i,2),'LineWidth', 0.5, 'Color', 'k');
      end
      
    % Axis description  
      title (ylabels{i}, 'FontWeight','normal')

    % Legend  
      if i==ny 
        pos = [0.48 0.01  0.05 0.001];    
        legend([DCR_SC DC SC],{'DC Regression with SC Prior',  ... 
                               'DC Regression','SC Prior',}   ... 
                               ,'Orientation', 'horizontal',...
                               'Position',pos ,'Interpreter','Latex');
        legend boxoff  
      end   
      
    % Widen vertical gap between plots 
      hx   =  0.075;                                
      h1   =  get(sub,'Position');
      switch i
         case {3,6},   hor = hx*1; 
         case {1,4},   hor = hx*-1; 
         otherwise  ,  hor = hx*0; 
      end
      set(sub, 'Position', [h1(1)+hor h1(2) h1(3) h1(4)]);   
  end
 
  
  
 