%__________________________________________________________________________
% PLOT FIGURE ANNEX C6         
% Set cDir in line 14 to your root directory
% Run Estimate_proxyVAR and Estimate_RecVAR beforehand and make sure 
% that paths to results files are set correctly 
%__________________________________________________________________________
  clear
  clc
  cDir   = [pwd '\'];
  addpath(genpath(cDir));
   
  nQ     =  2;
  ph     =  33;
  iC     =  [1 1 0 0 1 1 1];
  
% Take care of the lags 
  fn{1}  =  'Results_DSC\R_BV_Z1_F00';                   xiV(1) = 0;
  fn{2}  =  'Results_DSC\R_BV_Z2_F00';                   xiV(2) = 0;
  fn{3}  =  'Results_pV\R_pV_Z1_B2';                     xiV(3) = 1;
  fn{4}  =  'Results_pV\R_pV_Z2_B2';                     xiV(4) = 1;
  
% Benchmark
  Qd     =  [0.05 0.16 0.50 0.84 0.95];
  fn{5}  =  'Results_DSC\R_DSC_Gibbs_Z1_F00';     xiV(5) = 2;
  fn{6}  =  'Results_DSC\R_DSC_Gibbs_Z2_F00';     xiV(6) = 2;

  
%__________________________________________________________________________
% LOAD   
%__________________________________________________________________________
  for m = 1:length(fn)
      load([cDir fn{m}])

      switch xiV(m) 
        case {1}  
           [T,n]           =  size(SVARIV.vars);
            R(m).L_q       =  nan(ph,n,1,5);
 
            L_             =  nan(SVARIV.irhor,n,5);
            L_(:,:,3)      =  SVARIV.irs;
            L_(:,:,1:2)    =  SVARIVci.irsL;
            L_(:,:,[5 4])  =  SVARIVci.irsH;
            R(m).L_q(:,:,1,:) =  L_(1:ph,:,:);
  
        case {0,2}
            n      =  length(yName);
            T      =  size(E_,1);
            irf_H  =  size(L_,1) - 1;
            ndraw  =  size(L_,4);

            iC     =  logical(iC);
            LC_    =  nan(size(L_));
  
            for i = 1:ndraw
               LC_(1,:,:,i)  = L_(1,:,:,i);
               for h = 2:(irf_H+1)
                   LC_(h,:,:,i) = LC_(h-1,:,:,i) + L_(h,:,:,i);
               end  
            end
            L_(:,iC,:,:) =  LC_(:,iC,:,:);
            L_(:,7,:,:)  =  L_(:,2,:,:) +  L_(:,7,:,:); 
            R(m).L_q     =  store_IRFs(L_,Qd);     
      end
  end

%__________________________________________________________________________
% PLOT   
%__________________________________________________________________________
  slab  = {'Capital Requirements', 'Underwriting Standards', ... 
           'Capital Requirements', 'Underwriting Standards'};
      
  ylab  = {'GDP','CPI','FF Rate','BAA Spread',  ... 
           'CP Credit','HH Credit','House Prices'};  
 
  rx    = [-1.0 0.5 1.5;  -2.0 2.0  4.0  ; -1.0 1.0 2.0 ; ...  
           -0.1 0.2 0.3;  -2.0 2.0  4.0  ; -2.0 2.0 4.0 ;    -4.0 2.0  6.0]; 

  h     = (0:ph-1)';
  ny    = length(ylab);
  ns    = 4;
  C2    = [0.5 0.5 0.5];                                 

% _________________________________________________________________________
% PLOT WITH FAN 
% col: first row is is the outer band
%      a higher nr gives a lighter grey
% _________________________________________________________________________
% Colors  
  col    =  [240 240 240; 210 210 210]  / 256;             % Grey for bands 
  col_r  =  [205 000 000]               / 256;             % Red
  col_b  =  [ 36  16 135]               / 256;             % Blue

  figure('position', [100, 100, 200*ns, 150*ny])
  set(gca,'Fontsize',6)
  col_D  =  col(1,:);                                

  for i  = 1:ny 
  for j  = 1:ns 
     subplot(ny,ns,(i-1)*ns+j)
     bands      =  squeeze(R(j).L_q(1:ph,i,1,[1:nQ nQ+2:end])) * 100;
     centerline =  squeeze(R(j).L_q(1:ph,i,1,nQ+1)) * 100;
     xplot      =  h([1:end end:-1:1]);

     for k = 1:nQ
         patch(xplot, [bands(:,0+k); flipud(bands(:,end-k+1))]',  ... 
                                     col(k,:),'EdgeColor',col_D)
     end
     line(h, centerline, 'LineWidth', 1.5, 'Color', col_b);
        
     if j == 1 || j == 3
        hold on 
        plot(1:ph,squeeze(R(5).L_q(1:ph,i,1,3))*100,  ... 
        'Linewidth',2.0,'Color',col_b,'LineStyle',':')      
     end
     if j == 2 || j == 4
        hold on 
        plot(1:ph,squeeze(R(6).L_q(1:ph,i,1,3))*100,  ... 
        'Linewidth',2.0,'Color',col_b,'LineStyle',':')      
      end
     
      
     line(h, zeros(ph,1),'LineWidth', 0.5, 'Color', 'k');
     box off
     if j == 1;  ylabel(ylab{i});  end
     if i == 1;  title([slab{j}],'FontSize', 10); 
     end
      
    % X axis 
      xlim([0 h(end)]) 
      if h(end) <= 41,  set(gca,'XTick',0:8:h(end))
      else              set(gca,'XTick',0:12:h(end))
      end
            
    % Y axis 
      if isempty(rx)
         axis tight
      else
 
         ylim([rx(i,1) rx(i,2)])   
         set(gca,'YTick',rx(i,1):rx(i,3):rx(i,2))
         set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
         set(gca,'Fontsize',8)
         line(h, ones(ph,1)*rx(i,1),'LineWidth', 0.5, 'Color', 'k');
         line(h, ones(ph,1)*rx(i,2),'LineWidth', 0.5, 'Color', 'k');
      end
  end
  end
  
  text = {'Standard Bayesian Proxy VAR';'Frequentist Proxy VAR'};
  dim = [0.19 0.89 .1 .1;
         0.61 0.89 .1 .1];
  add_subheader(text, dim)

