%__________________________________________________________________________
% PLOT FIGURES ANNEX C2 TO C5          
% Run Estimates from Estimate_DSC first to obtain the results files
% Set Fig_nr on line 11 to choose the plot
%__________________________________________________________________________
  clear
  clc
  cDir  = [pwd '\'];
  addpath(genpath(cDir));

  Fig_nr  =   2;                                     % Choice of plot
  
  switch Fig_nr 
     case {1}    
   % Graph Annex C.2 
   % IRF DC and SC
     fn{1}     =  'Results_DSC\R_DC_Gibbs_Z1_F00';      
     fn{2}     =  'Results_DSC\R_DC_Gibbs_Z2_F00';     
     fn{3}     =  'Results_DSC\R_SC_Gibbs_Z1_F00';        
     fn{4}     =  'Results_DSC\R_SC_Gibbs_Z2_F00';       
  
     flag_IOZ  =   0;
     text      =  {'Discriminant Analysis', 'Sign Concordance'};
           
   case {2}    
   % Graph Annex C.3  
   % IOZ DC and SC  
     fn{1}     =  'Results_DSC\R_DC_Gibbs_Z1_F00';      
     fn{2}     =  'Results_DSC\R_DC_Gibbs_Z2_F00';     
     fn{3}     =  'Results_DSC\R_SC_Gibbs_Z1_F00';        
     fn{4}     =  'Results_DSC\R_SC_Gibbs_Z2_F00';       
     
     flag_IOZ  =   1;
     text      =  {'Discriminant Analysis', 'Sign Concordance'};
      
   case {3}    
   % Graph Annex C.4  
   % Invertibility check 
     fn{1}     =  'Results_DSC\R_DSC_Gibbs_Z1_M-14';  
     fn{2}     =  'Results_DSC\R_DSC_Gibbs_Z2_M-14';  
     fn{3}     =  'Results_DSC\R_DC_Gibbs_Z1_F-14';  
     fn{4}     =  'Results_DSC\R_DC_Gibbs_Z2_F-14'; 
  
     flag_IOZ  =   1;
     text      = {'Individual Lags', 'Compound Lags'}; 
       
   case {4}    
   % Graph Annex C.5  
   % Deregulation index / 4 lags 
     fn{1}     =  'Results_DSC\R_DSC_dr_Gibbs_Z1_F00';  
     fn{2}     =  'Results_DSC\R_DSC_dr_Gibbs_Z2_F00';  
     fn{3}     =  'Results_DSC\R_DSC_p4_Gibbs_Z1_F00';      
     fn{4}     =  'Results_DSC\R_DSC_p4_Gibbs_Z2_F00';     
  
     flag_IOZ  =   0;
     text      = {'Deregulation Index', 'Four Lags'};      
  end         
  
% Benchmark  
  fn{5}  = 'Results_DSC\R_DSC_Gibbs_Z1_F00';     
  fn{6}  = 'Results_DSC\R_DSC_Gibbs_Z2_F00';     
  
% Further controls   
  Qd     =  [0.05 0.16 0.5 0.84 0.95];            % Quantiles (length 5!)
  iC     =  [1 1 0 0 1 1 1];                      % =1 Accumulate IRF
  ph     =   33;                                  % Length of IRF horizon
  
  
%__________________________________________________________________________
% LOAD AND OBTAIn IRF AND IOZ  
%__________________________________________________________________________
  for m = 1:length(fn)
      load([cDir fn{m}])
      
      n      =  length(yName);
      T      =  size(E_,1);
      irf_H  =  size(L_,1) - 1;
      ndraw  =  size(L_,4);

    % Shocks
      E_     =  squeeze(E_(:,1,:));
      Zm     =  ZZ_;                                   
      Em_    =  E_ .* ZZ_;  
 
   % IRF 
     iC      =  logical(iC);
     LC_     =  nan(size(L_));
     IOZ     =  nan(size(L_));
  
     for i = 1:ndraw
        LC_(1,:,:,i)  = L_(1,:,:,i);
        for h = 2:(irf_H+1)
            LC_(h,:,:,i) = LC_(h-1,:,:,i) + L_(h,:,:,i);
        end  
     end
     L_(:,iC,:,:) =  LC_(:,iC,:,:);
     L_(:,7,:,:)  =   L_(:,2,:,:) +  L_(:,7,:,:); 
     R(m).L_q     =  store_IRFs(L_,Qd);

   % IOZ 
     if flag_IOZ == 1
        for d = 1:ndraw
          IOZ(:,:,:,d) = L_(:,:,:,d) * (sum(Em_(:,d)) ./ sum(abs(Zm(:,d))));            
        end
        R(m).L_q  =  store_IRFs(IOZ,Qd);
     end
  end

%__________________________________________________________________________
% PLOT   
%__________________________________________________________________________
  ylab = {'GDP','CPI','FF Rate','BAA Spread',  ... 
          'CP Credit','HH Credit','House Prices'};
      
  slab  = {'Capital Requirements', 'Underwriting Standards', ... 
           'Capital Requirements', 'Underwriting Standards'};
 
  if flag_IOZ == 0
     rx   = [-1.0 0.5 1.5;   -2.0 2.0 4.0 ; -1.0 1.0 2.0; ...  
             -0.1 0.2 0.3;   -2.0 2.0 4.0 ; -2.0 2.0 4.0  ;  -4.0 2.0 6.0]; 
  else
     rx   = [-0.8 0.2 1.0;  -1.5 1.0 2.5 ; -0.6 0.3 0.9; ...  
             -0.1 0.2 0.3;  -2.0 1.0 3.0 ; -2.0 1.0 3.0  ; -4.0 2.0 6.0]; 
  end
  
  h   = (0:ph-1)';
  ny  = length(ylab);
  ns  = 4;
  C2  = [0.5 0.5 0.5];                                 % Light Grey 
   
 
% _________________________________________________________________________
% PLOT WITH FAN 
% col: first row is is the outer band
%      a higher nr gives a lighter grey
% _________________________________________________________________________
% Back and grey  
  col      =  [ 240 240 240; 210 210 210] / 256;            % Grey
  col_b    =  [ 36   16  135]  / 256;                       % Blue
  col_k    =  [  0    0  0]    / 256;                       % Black
  col_r    =  [205	 000  000] / 256;                       % Red
  
  figure('position', [100, 50, 200*ns, 150*ny])
  set(gca,'Fontsize',6)
  col_D  =  col(1,:);                                
  nQ     = (length(Qd)-1)/2;

  for i  = 1:ny 
  for j  = 1:ns 
     subplot(ny,ns,(i-1)*ns+j)
     bands      = squeeze(R(j).L_q(1:ph,i,1,[1:nQ nQ+2:end])) * 100;
     centerline = squeeze(R(j).L_q(1:ph,i,1,nQ+1)) * 100;
     xplot      = h([1:end end:-1:1]);

     for k = 1:nQ
         patch(xplot, [bands(:,0+k); flipud(bands(:,end-k+1))]',  ... 
                                     col(k,:),'EdgeColor',col_D)
     end
     line(h, centerline, 'LineWidth', 1.5, 'Color', col_b);

     if j == 1 || j == 3
        hold on 
        plot(1:ph,squeeze(R(5).L_q(1:ph,i,1,3))*100,  ... 
        'Linewidth',2.0,'Color',col_b,'LineStyle',':')      
     end
     if j == 2 || j == 4
        hold on 
        plot(1:ph,squeeze(R(6).L_q(1:ph,i,1,3))*100,  ... 
        'Linewidth',2.0,'Color',col_b,'LineStyle',':')      
      end
                 
     line(h, zeros(ph,1),'LineWidth', 0.5, 'Color', 'k');
     box off
     if j == 1;  ylabel(ylab{i});  end
     if i == 1;  title([slab{j}],'FontSize', 10); 
     end
      
    % X axis 
      xlim([0 h(end)]) 
      if h(end) <= 41,  set(gca,'XTick',0:8:h(end))
      else              set(gca,'XTick',0:12:h(end))
      end
            
    % Y axis 
      if isempty(rx)
         axis tight
      else
         ylim([rx(i,1) rx(i,2)])   
         set(gca,'YTick',rx(i,1):rx(i,3):rx(i,2))
         set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
         set(gca,'Fontsize',8)
         line(h, ones(ph,1)*rx(i,1),'LineWidth', 0.5, 'Color', 'k');
         line(h, ones(ph,1)*rx(i,2),'LineWidth', 0.5, 'Color', 'k');
      end
  end
  end
  
  dim = [0.24 0.89 .1 .1;
         0.66 0.89 .1 .1];
  add_subheader(text, dim)
  
% Impulse responses at individual horizons
% Note that the Tables show [.1,.9] Quantiles
% Qd must be changed to [.10 .16 .50 .84 .90] fro comparison
  for m = 1:length(fn)
  for h = [1 4 32]
      if  flag_IOZ, ltext = 'IOZ'; 
      else          ltext = 'IRF';
      end
          
      disp(fn{m})
      disp([ltext ' for model ' num2str(m)  ' at horizon '  num2str(h)])
      squeeze(R(m).L_q(h+1,:,1,[1 3 5]))' * 100
  end
  end
