 function  Sim_plot_IRF_4_V2(IR_true,IR,ser,Models,header,show)
   
   irf_H    =  size(IR_true,1);
   h        =  0:irf_H-1;
   IR_true  =  IR_true(:,ser,:);

 % Colours  
   col_D   =   [230 230 230; 230 230 230] / 256;           % Grey for area
   col_b    =  [  0   50   90] / 256;                      % Blue
   col_r    =  [105	 000  000] / 256;                      % Red
   msize    =   3;                                         % Markersize
   posvec   =   1:length(IR);

   figure('position',[100, 50, 180, 180*6],'NumberTitle','off','Name',header)
   set(gca,'Fontsize',6)
   box on 
   grid on
   
   for m = 1:length(IR)
   % Means of quantiles
     IR(m).mdn  = IR(m).mdn(:,ser);   
     IR(m).qU   = IR(m).qU (:,ser);
     IR(m).qL   = IR(m).qL (:,ser);
       
   % Quantiles of median 
     IR(m).Um   = IR(m).Qmdn(:,ser,1);
     IR(m).Lm   = IR(m).Qmdn(:,ser,3);
     
     if show(m) == 0, 
        annotation('textbox',[0.15 0.0 1 0.95],'String',header,  ... 
                   'LineStyle', 'none','FontSize', 10)
     else
       subplot(length(IR),1,posvec(m))
       xplot = h([1:end end:-1:1]);
       for k = [1 3]
           patch(xplot, [IR(m).qL ; flipud(IR(m).qU)]',   ... 
           col_D(1,:) ,'EdgeColor', col_D(1,:));
       end
       
       line(h, zeros(irf_H,1),'LineWidth',  0.5,  'Color','k');
       line(h, IR_true,   'LineWidth', 1.50, 'Color','k', 'LineStyle','-'); 
       line(h, IR(m).mdn ,'LineWidth', 1.00, 'Color',col_b, 'LineStyle','-');
       
     % line(h, IR(m).Um,  'LineWidth', 1.50, 'Color',col_b, 'LineStyle',':');
     % line(h, IR(m).Lm,  'LineWidth', 1.50, 'Color',col_b, 'LineStyle','-');
       
       hold on,       plot(h, IR(m).Um,'d','Markersize', msize, ... 
                                           'MarkerEdgeColor',col_b, ...
                                           'MarkerFaceColor',col_b)
         
       hold on,       plot(h, IR(m).Lm,'d','Markersize', msize, ... 
                                           'MarkerEdgeColor',col_b, ...
                                           'MarkerFaceColor',col_b)
                                 
                                       
       xlim([0 length(h)-1])
       ylim([-.01 0.02])
       ylabel(Models{m},'Fontsize',8)
       set(gca,'Fontsize',8)
       set(gca,'YTickLabel','')
       set(gca,'XTick',0:8:16)
       box  on
     end
     if m  == 1, title(header,'Fontsize',10), end
    end
 end
   
   
   
   
   
   
