function plot_IRFs(L_q,yName,sName,rx)
%__________________________________________________________________________
% function plot_IRFs(L_,yName,sName,rx)
%__________________________________________________________________________
% Plots IRFs as produced by
%
%  INPUTS
%  L_q        IRF, 3 quantiles                   [h x ny x ns x 3]
%  yName      Series labels                      [n  x 1 cell of strings]
%  sName      Shock labels                       [ns x 1 cell of strings]
%  rx         Scaling of y-axis for series  
%                        (min / max / grid)      [N x 3]
%__________________________________________________________________________
  ny     = length(yName);
  ns     = length(sName);
  nh     = size(L_q,1);
  h      = 0:nh-1;
  
% Colour definitions
% CR  = [238/255 74/255 0/255];         % Red
  C1  = [0.6 0.6 0.6];                  % Dark Grey 
  C2  = [0.8 0.8 0.8];                  % Light Grey 
  
  figure('position', [0, 0, 200*ns, 200*ny])
  for i  = 1:ny 
  for j  = 1:ns 
        subplot(ny,ns,(i-1)*ns+j)
        plot(h,zeros(nh,1)   ,'LineWidth',1  ,'Color', C2,...
                              'LineStyle','-');               hold on
        plot(h,L_q(:,i,j,2),'LineWidth',1.5,'Color','k');     hold on
        plot(h,L_q(:,i,j,1),'LineWidth',1  ,'Color',C2);      hold on 
        plot(h,L_q(:,i,j,3),'LineWidth',1  ,'Color',C2);   
        
        if j == 1;  ylabel(yName{i});  end
        if i == 1;  title(sName{j});   end
      
      % X axis 
        xlim([0 h(end)])   
        set(gca,'XTick',0:10:h(end))

      % Y axis 
        if isempty(rx)
           axis tight
        else
           ylim([rx(i,1) rx(i,2)])   
           set(gca,'YTick',rx(i,1):rx(i,3):rx(i,2))
           set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
        end
        set(gca,'Fontsize',8)
  end
  end


