function LP1 = Plot_sim(IRF_0,IRF_1,IRF_D, yName,sName,rx,x,y, header, dir_, SCR)
%__________________________________________________________________________
% function plot_sim(L_,yName,sName,rx)
%__________________________________________________________________________
% Plots IRF fanchart
%
%  INPUTS
%  L_q        IRF, 3 or 5 quantiles              [h x ny x ns x 3/5]
%  yName      Series labels                      [n  x 1 cell of strings]
%  sName      Shock labels                       [ns x 1 cell of strings]
%  rx         Scaling of y-axis for series  
%                        (min / max / grid)      [N x 3]
% header      Additional text for graph header 
% cyc         Boom or bust 
%__________________________________________________________________________
% Colour definitions

% Grey for difference
  col_D   = [ 192   192 192;
              160	160 160] / 256;  
% Blue for Boom  
  col_1 =   [176	226	255	;       
             099	184	255] / 256;
% Red for Bust       
  col_0 =   [255	193	193 ;       
             255	106	106] / 256;           

% if set sacrifice ratio
  if SCR==1, yName(end+1) = {'SCR'}; end

% Dimensions
  nh    = size(IRF_0,1);
  var   = length(yName);
  sh    = length(sName);
  h     = 0:nh-1;
  nQ    = (size(IRF_0,4) - 1) / 2;
  
  figure('position', [x, y, 220*var, 200*sh],'NumberTitle', 'off', 'Name', header)
  set(gca,'Fontsize',6)
 % if var==3, rx= [-1 1 0.5; -2.0 2.0 1.0; -0.5 1 0.5]; end
  
  for j  = 1:sh 
  for i  = 1:var 
        subplot(sh,var,(i-1)*sh+j)
        xplot      = h([1:end end:-1:1]);
        
        for k = 1:nQ
            patch(xplot, [squeeze(IRF_D(:,i,j,0+k));  flipud(squeeze(IRF_D(:,i,j,end-k+1)))]', ... 
                                         col_D(k,:) ,'EdgeColor', col_D(k,:));
        end
        
        line(h, squeeze(IRF_0(:,i,j, nQ+1)), 'LineWidth', 1.25,  'Color', col_0(2,:));
        line(h, squeeze(IRF_1(:,i,j, nQ+1)), 'LineWidth', 1.25,  'Color', col_1(2,:));
        line(h, zeros(nh,1),'LineWidth', 0.5, 'Color', 'k');
        
             
        if j == 1;  title(yName{i}, 'FontSize', 12, 'FontWeight', 'bold'); end
           
      % X axis 
        xlim([0 h(end)])   
        set(gca,'XTick',0:8:h(end))

      % Y axis 
        if isempty(rx)
           axis tight
        else
           ylim([rx(i,1) rx(i,2)])   
           set(gca,'YTick',rx(i,1):rx(i,3):rx(i,2))
           set(gca,'YTickLabel', num2str(get(gca,'YTick')','%0.1f'))
           line(h, ones(nh,1)*rx(i,1),'LineWidth', 0.5, 'Color', 'k');
           line(h, ones(nh,1)*rx(i,2),'LineWidth', 0.5, 'Color', 'k');
        end
  end
  end
  
  dim = [0.45 0.9 .1 .1];
% annotation('textbox',dim,'String',header, 'LineStyle', 'none','FontWeight', 'bold','FontSize', 12)
% legend({'Difference 1SD','Bust','Boom'},'Orientation', 'horizontal','Position',[0.48 0.04 0.05 0.001],'rotation',90);
  set(gca,'Fontsize',10)
  dir_D  =  [dir_ 'Code\Results\'];   
  cd(dir_D);

  
