function L_q = store_IRFs(L_,QNT)

%__________________________________________________________________________
% L_q = store_IRFs_GR(L_,QNT)
%__________________________________________________________________________
% Derive quantiles of IRFs from the matrix of draws
%
% L_     =       IRF  (horizon x n_vars x n_shocks x n_draws)
% QNT    =       List of quantiles (k x 1)
%        =       0  ...  min
%        =       1  ...  max
%               -1  ...  mean
%
%__________________________________________________________________________
  n_draws =  size(L_,4);
  L_q     =  nan(size(L_,1),size(L_,2),size(L_,3),length(QNT));

% Quantiles of aggregate IRFs
  for h   = 1:size(L_,1)
  for n   = 1:size(L_,2)
  for m   = 1:size(L_,3)
  for q   = 1:length(QNT)
      if     QNT(q) ==  0; L_q(h,n,m,q) = min(L_(h,n,m,:)); 
      elseif QNT(q) ==  1; L_q(h,n,m,q) = max(L_(h,n,m,:)); 
      elseif QNT(q) == -1; L_q(h,n,m,q) = sum(L_(h,n,m,:))/ n_draws; 
      else                 L_q(h,n,m,q) = quantile(L_(h,n,m,:),QNT(q)); 
      end
  end
  end 
  end 
  end
 
end