function pi0 = prior_pi(a,b,L,U)
%__________________________________________________________________________
% function pi0 = prior_pi(a,b,U,L)
% Draws pi0 in [U,L] from a beta prior over support [U,L]
% [a,b] .... Parameters of beta - distribution  
% [U,L] .... Upper and lower bound of the distribution
%
%
%__________________________________________________________________________
  if L >  U, error('L <= U required'), end
  if L <  0, error('L => 0 required'), end
  if U >  1, error('U <= 1 required'), end

  pi0  = L + random('beta',a,b) * (U-L);

end




