
function [S1, S2] =  nVStat(z,E_,j,sName,Qd,plotflag)
%__________________________________________________________________________
% function nVStat(z,E_)
%__________________________________________________________________________
% Takes a narrative variable and errors as input and calculates diagnostics
%  INPUTS
%  z         The narrative variable                                 [T X 1]
%  E         Shocks                                         [T x n x ndraw]
%  j         Index of the shock instrumented by z                   [1 x 1] 
%  sname     Cell vector of names of shocks                         [n x 1]
%  Qd        Quantiles for displaying results                       [5 x 1]
%
% OUTPUTS
% S1        Quantiles of correlation of shocks with z
% S2        col 1 = corr(z,E)
%           col 2 = SC(z,E)    
%           col 3 = RelVar(E|z ~=0)
%           col 4 = Mean(E|z~=0)
%           col 6 = R-squared of z on E_
%__________________________________________________________________________
  T      = size(E_,1);
  n      = size(E_,2);
  ndraw  = size(E_,3);
  S1     = nan(ndraw,n);
  S2     = nan(ndraw,6);

  for i = 1:ndraw
      sc       =  sign(z) .* squeeze(E_(:,j,i));
     [b,u,r2]  =  ols(z,[squeeze(E_(:,j,i)) ones(T,1)]);
    % zhat     =  [squeeze(E_(:,j,i)) ones(T,1) ]*b;
     
      S1(i,:)  =  corr(z,squeeze(E_(:,:,i)));
      S2(i,1)  =  S1(i,j);
      S2(i,2)  =  sum(sc > 0)/sum(sc ~=0);
      S2(i,3)  =  std(squeeze(E_((sc ~= 0),j,i)));
      S2(i,4)  =  mean(sc(sc~=0));
      S2(i,5)  =  median(sc(sc~=0));
      S2(i,6)  =  r2;
  end
  
  if plotflag && T > 1
    disp(' ')
    disp('____________________________________________________')
    disp(['Diagnostics for ' sName ])
    disp('____________________________________________________')
    disp(['   Quantiles ' num2str(Qd,'%5.3g')])
    disp('  ');
  
    disp('   Corr with shocks 1:n')
    disp(quantile(S1,Qd))
    disp('    Corr      SignC     RelVar    MeanEZ    MedianEZ  R2(z)')
    disp(quantile(S2,Qd))
    
  end

